/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpDLQReceiverTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testCreateDurableReceiver() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        this.sendMessages(this.getQueueName(), 1);
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queue);
        receiver.flow(100);
        for (int i = 0; i < 10; ++i) {
            logger.debug("i = {}", (Object)i);
            AmqpMessage receive = receiver.receive(5000L, TimeUnit.MILLISECONDS);
            receive.modified(true, false);
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            logger.debug("receive = {}", (Object)receive.getWrappedMessage().getDeliveryCount());
            logger.debug("queueView.getMessageCount() = {}", (Object)queueView.getMessageCount());
            logger.debug("queueView.getDeliveringCount() = {}", (Object)queueView.getDeliveringCount());
            logger.debug("queueView.getPersistentSize() = {}", (Object)queueView.getPersistentSize());
        }
        receiver.close();
        connection.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        logger.debug("queueView.getMessageCount() = {}", (Object)queueView.getMessageCount());
        logger.debug("queueView.getDeliveringCount() = {}", (Object)queueView.getDeliveringCount());
        logger.debug("queueView.getPersistentSize() = {}", (Object)queueView.getPersistentSize());
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
    }
}

