/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.proton.amqp.security.SaslCode;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.amqp.security.SaslOutcome;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.Close;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpPipelinedConnectTest
extends AmqpClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected boolean isSecurityEnabled() {
        return true;
    }

    @Test
    @Timeout(value=30L)
    public void testPipelinedOpenWhenAnonymousWillFail() throws Exception {
        byte[] pipelined = new byte[]{65, 77, 81, 80, 3, 1, 0, 0, 0, 0, 0, 37, 2, 1, 0, 0, 0, 83, 65, -64, 24, 3, -93, 9, 65, 78, 79, 78, 89, 77, 79, 85, 83, 64, -95, 9, 108, 111, 99, 97, 108, 104, 111, 115, 116, 65, 77, 81, 80, 0, 1, 0, 0, 0, 0, 0, 71, 2, 0, 0, 0, 0, 83, 16, -64, 58, 4, -95, 36, 50, 48, 52, 99, 49, 100, 52, 53, 45, 57, 99, 52, 55, 45, 52, 48, 50, 100, 45, 56, 48, 57, 102, 45, 55, 100, 49, 55, 97, 52, 100, 57, 55, 100, 54, 101, -95, 9, 108, 111, 99, 97, 108, 104, 111, 115, 116, 112, 0, 2, 0, 0, 96, 127, -1, 0, 0, 0, 26, 2, 0, 0, 0, 0, 83, 17, -64, 13, 4, 64, 67, 112, 127, -1, -1, -1, 112, 127, -1, -1, -1, 0, 0, 0, 82, 2, 0, 0, 0, 0, 83, 18, -64, 69, 11, -95, 36, 50, 98, 52, 54, 97, 100, 53, 98, 45, 56, 51, 52, 98, 45, 52, 53, 52, 101, 45, 97, 50, 102, 55, 45, 50, 101, 53, 101, 48, 101, 51, 50, 52, 101, 50, 49, 67, 66, 80, 2, 80, 0, 0, 83, 40, 69, 0, 83, 41, -64, 11, 1, -95, 8, 101, 120, 97, 109, 112, 108, 101, 115, 64, 66, 67, 68};
        final AtomicBoolean closedReceived = new AtomicBoolean();
        final AtomicReference failure = new AtomicReference();
        final AtomicInteger saslPerformatives = new AtomicInteger();
        final AtomicInteger performatives = new AtomicInteger();
        try (final ClientConnection connection = new ClientConnection();){
            connection.open("localhost", 5672);
            connection.send(pipelined);
            connection.readFromRemote(new FrameDecoder(new FrameBodyHandler(){

                @Override
                public void onSaslFrame(SaslFrameBody saslType) {
                    SaslOutcome outcome;
                    saslPerformatives.incrementAndGet();
                    if (saslType instanceof SaslOutcome && (outcome = (SaslOutcome)saslType).getCode() != SaslCode.OK) {
                        failure.compareAndSet(null, new AssertionError((Object)"SASL outcome expected to be OK but wasn't"));
                    }
                }

                @Override
                public void onError(AssertionError error) {
                    failure.compareAndSet(null, error);
                }

                @Override
                public void onAMQPFrame(FrameBody amqpType) {
                    performatives.incrementAndGet();
                    if (amqpType instanceof Close) {
                        closedReceived.set(true);
                        Close close = (Close)amqpType;
                        if (close.getError() == null || !AmqpError.UNAUTHORIZED_ACCESS.equals(close.getError().getCondition())) {
                            failure.compareAndSet(null, new AssertionError((Object)"Connection should indicate access was unauthorized"));
                        }
                        connection.close();
                    }
                }
            }));
            Wait.waitFor(() -> closedReceived.get());
        }
        Assertions.assertEquals((int)2, (int)saslPerformatives.get());
        Assertions.assertEquals((int)2, (int)performatives.get());
        Assertions.assertNull(failure.get());
    }

    private class ClientConnection
    implements AutoCloseable {
        protected static final long RECEIVE_TIMEOUT = 10000L;
        protected Socket clientSocket;

        private ClientConnection() {
        }

        public void open(String host, int port) throws IOException {
            this.clientSocket = new Socket(host, port);
            this.clientSocket.setTcpNoDelay(true);
        }

        public void send(byte[] data) throws Exception {
            OutputStream outputStream = this.clientSocket.getOutputStream();
            outputStream.write(data);
            outputStream.flush();
        }

        @Override
        public void close() {
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * Loose catch block
         */
        public void readFromRemote(FrameDecoder decoder) throws Exception {
            this.clientSocket.setSoTimeout(10000);
            InputStream is = this.clientSocket.getInputStream();
            block2: while (true) {
                byte[] incoming = new byte[1024];
                int read = is.read(incoming);
                if (read == -1) {
                    is.close();
                    return;
                }
                ByteBuffer packet = ByteBuffer.wrap(incoming, 0, read);
                while (true) {
                    if (!packet.hasRemaining()) continue block2;
                    decoder.ingest(packet);
                }
                break;
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    private static class FrameDecoder {
        public static final int FRAME_SIZE_BYTES = 4;
        public static final byte AMQP_FRAME_TYPE = 0;
        public static final byte SASL_FRAME_TYPE = 1;
        private final FrameBodyHandler performativeHandler;
        private final DecoderImpl decoder = new DecoderImpl();
        private final EncoderImpl encoder = new EncoderImpl(this.decoder);
        private FrameParserStage stage = new HeaderParsingStage();
        private final FrameSizeParsingStage frameSizeParser = new FrameSizeParsingStage();
        private final FrameBufferingStage frameBufferingStage = new FrameBufferingStage();
        private final FrameParserStage frameBodyParsingStage = new FrameBodyParsingStage();

        FrameDecoder(FrameBodyHandler performativeHandler) {
            this.performativeHandler = performativeHandler;
            AMQPDefinedTypes.registerAllTypes((Decoder)this.decoder, (EncoderImpl)this.encoder);
        }

        public void ingest(ByteBuffer buffer) throws AssertionError {
            try {
                this.stage.parse(buffer);
            }
            catch (AssertionError ex) {
                this.transitionToErrorStage(ex);
                this.performativeHandler.onError(ex);
                throw ex;
            }
            catch (Throwable throwable) {
                AssertionError error = new AssertionError("Frame decode failed.", throwable);
                this.transitionToErrorStage(error);
                this.performativeHandler.onError(error);
                throw error;
            }
        }

        private FrameParserStage transitionToHeaderParsingStage() {
            this.stage = new HeaderParsingStage();
            return this.stage;
        }

        private FrameParserStage transitionToFrameSizeParsingStage() {
            this.stage = this.frameSizeParser.reset(0);
            return this.stage;
        }

        private FrameParserStage transitionToFrameBufferingStage(int frameSize) {
            this.stage = this.frameBufferingStage.reset(frameSize);
            return this.stage;
        }

        private FrameParserStage initializeFrameBodyParsingStage(int frameSize) {
            this.stage = this.frameBodyParsingStage.reset(frameSize);
            return this.stage;
        }

        private ParsingErrorStage transitionToErrorStage(AssertionError error) {
            if (!(this.stage instanceof ParsingErrorStage)) {
                this.stage = new ParsingErrorStage(error);
            }
            return (ParsingErrorStage)this.stage;
        }

        private class HeaderParsingStage
        implements FrameParserStage {
            private static final int HEADER_SIZE_BYTES = 8;
            private final byte[] headerBytes = new byte[8];
            private int headerByte;

            private HeaderParsingStage() {
            }

            @Override
            public void parse(ByteBuffer incoming) throws AssertionError {
                while (incoming.hasRemaining() && this.headerByte < 8) {
                    this.headerBytes[this.headerByte++] = incoming.get();
                }
                if (this.headerByte == 8) {
                    FrameDecoder.this.transitionToFrameSizeParsingStage();
                }
            }

            @Override
            public HeaderParsingStage reset(int frameSize) {
                this.headerByte = 0;
                return this;
            }
        }

        private static interface FrameParserStage {
            public void parse(ByteBuffer var1) throws AssertionError;

            public FrameParserStage reset(int var1);
        }

        private class FrameSizeParsingStage
        implements FrameParserStage {
            private int frameSize;
            private int multiplier = 4;

            private FrameSizeParsingStage() {
            }

            @Override
            public void parse(ByteBuffer input) throws AssertionError {
                while (input.hasRemaining()) {
                    this.frameSize |= (input.get() & 0xFF) << --this.multiplier * 8;
                    if (this.multiplier != 0) continue;
                }
                if (this.multiplier == 0) {
                    int length = this.frameSize - 4;
                    if (input.remaining() < length) {
                        FrameDecoder.this.transitionToFrameBufferingStage(length);
                    } else {
                        FrameDecoder.this.initializeFrameBodyParsingStage(length);
                    }
                    FrameDecoder.this.stage.parse(input);
                }
            }

            @Override
            public FrameSizeParsingStage reset(int frameSize) {
                this.multiplier = 4;
                this.frameSize = frameSize;
                return this;
            }
        }

        private class FrameBufferingStage
        implements FrameParserStage {
            private ByteBuffer buffer;

            private FrameBufferingStage() {
            }

            @Override
            public void parse(ByteBuffer input) throws AssertionError {
                if (input.remaining() < this.buffer.limit()) {
                    this.buffer.put(input);
                } else {
                    int remaining = this.buffer.remaining();
                    this.buffer.put(input.slice().limit(input.position() + remaining));
                    input.position(input.position() + remaining);
                    FrameDecoder.this.initializeFrameBodyParsingStage(this.buffer.flip().remaining());
                    FrameDecoder.this.stage.parse(this.buffer);
                }
            }

            @Override
            public FrameBufferingStage reset(int frameSize) {
                this.buffer = ByteBuffer.allocate(frameSize);
                return this;
            }
        }

        private class FrameBodyParsingStage
        implements FrameParserStage {
            private int frameSize;

            private FrameBodyParsingStage() {
            }

            @Override
            public void parse(ByteBuffer input) throws AssertionError {
                int frameBodySize;
                int dataOffset = input.get() << 2 & 0x3FF;
                int frameSize = this.frameSize + 4;
                int frameType = input.get() & 0xFF;
                input.getShort();
                if (dataOffset != 8) {
                    input.position(input.position() + dataOffset - 8);
                }
                if ((frameBodySize = frameSize - dataOffset) > 0) {
                    FrameDecoder.this.decoder.setByteBuffer(input);
                    Object body = FrameDecoder.this.decoder.readObject();
                    FrameDecoder.this.decoder.setByteBuffer(null);
                    logger.trace("Read Frame body: {}", body);
                    if (frameType == 0) {
                        FrameBody performative = (FrameBody)body;
                        FrameDecoder.this.transitionToFrameSizeParsingStage();
                        FrameDecoder.this.performativeHandler.onAMQPFrame(performative);
                    } else if (frameType == 1) {
                        SaslFrameBody performative = (SaslFrameBody)body;
                        if (performative instanceof SaslOutcome) {
                            FrameDecoder.this.transitionToHeaderParsingStage();
                        } else {
                            FrameDecoder.this.transitionToFrameSizeParsingStage();
                        }
                        FrameDecoder.this.performativeHandler.onSaslFrame(performative);
                    } else {
                        throw new AssertionError((Object)String.format("unknown frame type: %d", frameType));
                    }
                }
            }

            @Override
            public FrameBodyParsingStage reset(int frameSize) {
                this.frameSize = frameSize;
                return this;
            }
        }

        private static class ParsingErrorStage
        implements FrameParserStage {
            private final AssertionError parsingError;

            ParsingErrorStage(AssertionError parsingError) {
                this.parsingError = parsingError;
            }

            @Override
            public void parse(ByteBuffer input) throws AssertionError {
                throw this.parsingError;
            }

            @Override
            public ParsingErrorStage reset(int frameSize) {
                return this;
            }
        }
    }

    private static interface FrameBodyHandler {
        public void onSaslFrame(SaslFrameBody var1);

        public void onAMQPFrame(FrameBody var1);

        public void onError(AssertionError var1);
    }
}

