/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransactionTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=30L)
    public void testBeginAndCommitTransaction() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        session.begin();
        Assertions.assertTrue((boolean)session.isInTransaction());
        session.commit();
        connection.close();
    }

    @Test
    @Timeout(value=30L)
    public void testCoordinatorReplenishesCredit() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        for (int i = 0; i < 1000; ++i) {
            session.begin();
            Assertions.assertTrue((boolean)session.isInTransaction());
            session.commit();
        }
        connection.close();
    }

    @Test
    @Timeout(value=30L)
    public void testSentTransactionalMessageIsSettleWithTransactionalDisposition() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        AmqpSender sender = session.createSender(this.getQueueName());
        sender.setStateInspector(new AmqpValidator(){

            @Override
            public void inspectDeliveryUpdate(Sender sender, Delivery delivery) {
                if (delivery.remotelySettled()) {
                    DeliveryState state = delivery.getRemoteState();
                    if (state instanceof TransactionalState) {
                        logger.debug("Remote settled with TX state: {}", (Object)state);
                    } else {
                        logger.warn("Remote settled with non-TX state: {}", (Object)state);
                        this.markAsInvalid("Remote did not settled with TransactionState.");
                    }
                }
            }
        });
        session.begin();
        Assertions.assertTrue((boolean)session.isInTransaction());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        session.commit();
        sender.getStateInspector().assertValid();
        connection.close();
    }

    @Test
    @Timeout(value=30L)
    public void testBeginAndRollbackTransaction() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        session.begin();
        Assertions.assertTrue((boolean)session.isInTransaction());
        session.rollback();
        connection.close();
        System.err.println("Closed");
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageToQueueWithCommit() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        session.begin();
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        session.commit();
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        sender.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSendMessageToQueueWithRollback() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        session.begin();
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        session.rollback();
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        sender.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveMessageWithCommit() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        session.begin();
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        received.accept();
        session.commit();
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        sender.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveAfterConnectionClose() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        session.begin();
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        received.accept();
        connection.close();
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        receiver = session.createReceiver(this.getQueueName());
        session.begin();
        receiver.flow(1);
        received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        received.accept();
        session.commit();
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveMessageWithRollback() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        session.begin();
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        received.accept();
        session.rollback();
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        sender.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testMultipleSessionReceiversInSingleTXNWithCommit() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        sender.send(message);
        sender.send(message);
        sender.close();
        AmqpSession txnSession = connection.createSession();
        AmqpSession session1 = connection.createSession();
        AmqpSession session2 = connection.createSession();
        AmqpSession session3 = connection.createSession();
        AmqpReceiver receiver1 = session1.createReceiver(this.getQueueName());
        AmqpReceiver receiver2 = session2.createReceiver(this.getQueueName());
        AmqpReceiver receiver3 = session3.createReceiver(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)3L, () -> ((Queue)queue).getMessageCount());
        txnSession.begin();
        Assertions.assertTrue((boolean)txnSession.isInTransaction());
        receiver1.flow(1);
        receiver2.flow(1);
        receiver3.flow(1);
        AmqpMessage message1 = receiver1.receive(5L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver2.receive(5L, TimeUnit.SECONDS);
        AmqpMessage message3 = receiver3.receive(5L, TimeUnit.SECONDS);
        message1.accept(txnSession);
        message2.accept(txnSession);
        message3.accept(txnSession);
        Wait.assertEquals((long)3L, () -> ((Queue)queue).getMessageCount());
        txnSession.commit();
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testMultipleSessionReceiversInSingleTXNWithRollback() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        sender.send(message);
        sender.send(message);
        sender.close();
        AmqpSession txnSession = connection.createSession();
        AmqpSession session1 = connection.createSession();
        AmqpSession session2 = connection.createSession();
        AmqpSession session3 = connection.createSession();
        AmqpReceiver receiver1 = session1.createReceiver(this.getQueueName());
        AmqpReceiver receiver2 = session2.createReceiver(this.getQueueName());
        AmqpReceiver receiver3 = session3.createReceiver(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)3L, () -> ((Queue)queue).getMessageCount());
        txnSession.begin();
        Assertions.assertTrue((boolean)txnSession.isInTransaction());
        receiver1.flow(1);
        receiver2.flow(1);
        receiver3.flow(1);
        AmqpMessage message1 = receiver1.receive(5L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver2.receive(5L, TimeUnit.SECONDS);
        AmqpMessage message3 = receiver3.receive(5L, TimeUnit.SECONDS);
        message1.accept(txnSession);
        message2.accept(txnSession);
        message3.accept(txnSession);
        Wait.assertEquals((long)3L, () -> ((Queue)queue).getMessageCount());
        txnSession.rollback();
        Wait.assertEquals((long)3L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testMultipleSessionSendersInSingleTXNWithCommit() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession txnSession = connection.createSession();
        AmqpSession session1 = connection.createSession();
        AmqpSession session2 = connection.createSession();
        AmqpSession session3 = connection.createSession();
        AmqpSender sender1 = session1.createSender(this.getQueueName());
        AmqpSender sender2 = session2.createSender(this.getQueueName());
        AmqpSender sender3 = session3.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        txnSession.begin();
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        Assertions.assertTrue((boolean)txnSession.isInTransaction());
        sender1.send(message, txnSession.getTransactionId());
        sender2.send(message, txnSession.getTransactionId());
        sender3.send(message, txnSession.getTransactionId());
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
        txnSession.commit();
        Wait.assertEquals((long)3L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testMultipleSessionSendersInSingleTXNWithRollback() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession txnSession = connection.createSession();
        AmqpSession session1 = connection.createSession();
        AmqpSession session2 = connection.createSession();
        AmqpSession session3 = connection.createSession();
        AmqpSender sender1 = session1.createSender(this.getQueueName());
        AmqpSender sender2 = session2.createSender(this.getQueueName());
        AmqpSender sender3 = session3.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        txnSession.begin();
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        Assertions.assertTrue((boolean)txnSession.isInTransaction());
        sender1.send(message, txnSession.getTransactionId());
        sender2.send(message, txnSession.getTransactionId());
        sender3.send(message, txnSession.getTransactionId());
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
        txnSession.rollback();
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testSendersCommitAndRollbackWithMultipleSessionsInSingleTX() throws Exception {
        AmqpMessage message;
        int i;
        int NUM_MESSAGES = 5;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession txnSession = connection.createSession();
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        txnSession.begin();
        for (i = 0; i < 5; ++i) {
            message = new AmqpMessage();
            message.setText("Test-Message");
            sender.send(message, txnSession.getTransactionId());
        }
        txnSession.commit();
        txnSession.begin();
        for (i = 0; i < 5; ++i) {
            message = new AmqpMessage();
            message.setText("Test-Message");
            sender.send(message, txnSession.getTransactionId());
        }
        txnSession.rollback();
        txnSession.begin();
        for (i = 0; i < 5; ++i) {
            message = new AmqpMessage();
            message.setText("Test-Message");
            sender.send(message, txnSession.getTransactionId());
        }
        txnSession.commit();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(10);
        for (int i2 = 0; i2 < 10; ++i2) {
            AmqpMessage message2 = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message2);
            message2.accept(txnSession);
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testReceiversCommitAndRollbackWithMultipleSessionsInSingleTX() throws Exception {
        int NUM_MESSAGES = 10;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            int i;
            AmqpSession txnSession = connection.createSession();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            for (int i2 = 0; i2 < 11; ++i2) {
                AmqpMessage message = new AmqpMessage();
                message.setText("Test-Message");
                message.setApplicationProperty("msgId", i2);
                sender.send(message, txnSession.getTransactionId());
            }
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            ArrayList<AmqpMessage> messages = new ArrayList<AmqpMessage>(10);
            receiver.flow(24);
            for (i = 0; i < 10; ++i) {
                AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)message);
                messages.add(message);
            }
            txnSession.begin();
            for (i = 0; i < 5; ++i) {
                ((AmqpMessage)messages.get(i)).accept(txnSession);
            }
            txnSession.commit();
            txnSession.begin();
            for (i = 5; i < 10; ++i) {
                ((AmqpMessage)messages.get(i)).accept(txnSession, false);
            }
            txnSession.rollback();
            AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)10, (Object)message.getApplicationProperty("msgId"));
            message.release();
            message = receiver.receive(5L, TimeUnit.SECONDS);
            receiver.flow(1);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)10, (Object)message.getApplicationProperty("msgId"));
            message.release();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testCommitAndRollbackWithMultipleSessionsInSingleTX() throws Exception {
        int NUM_MESSAGES = 10;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession txnSession = connection.createSession();
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (int i = 0; i < 10; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setText("Test-Message");
            message.setApplicationProperty("msgId", i);
            sender.send(message, txnSession.getTransactionId());
        }
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(2);
        AmqpMessage message1 = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver.receive(5L, TimeUnit.SECONDS);
        txnSession.begin();
        message1.accept(txnSession);
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setApplicationProperty("msgId", 10);
        sender.send(message, txnSession.getTransactionId());
        txnSession.commit();
        txnSession.begin();
        message2.accept(txnSession);
        message = new AmqpMessage();
        message.setText("Test-Message");
        message.setApplicationProperty("msgId", 11);
        sender.send(message, txnSession.getTransactionId());
        txnSession.rollback();
        receiver.flow(10);
        for (int i = 1; i <= 10; ++i) {
            AmqpMessage message3 = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message3);
            Assertions.assertEquals((Object)i, (Object)message3.getApplicationProperty("msgId"));
            message3.accept();
        }
        Assertions.assertNull((Object)receiver.receive(1L, TimeUnit.SECONDS));
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testReceiversCommitAndRollbackWithMultipleSessionsInSingleTXNoSettlement() throws Exception {
        int NUM_MESSAGES = 10;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = client.connect();){
            int i;
            AmqpSession txnSession = connection.createSession();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            for (int i2 = 0; i2 < 11; ++i2) {
                AmqpMessage message = new AmqpMessage();
                message.setText("Test-Message");
                message.setApplicationProperty("msgId", i2);
                sender.send(message, txnSession.getTransactionId());
            }
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            ArrayList<AmqpMessage> messages = new ArrayList<AmqpMessage>(10);
            receiver.flow(24);
            for (i = 0; i < 10; ++i) {
                AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
                logger.debug("Read message: {}", message.getApplicationProperty("msgId"));
                Assertions.assertNotNull((Object)message);
                messages.add(message);
            }
            txnSession.begin();
            for (i = 0; i < 5; ++i) {
                logger.debug("Commit: Accepting message: {}", ((AmqpMessage)messages.get(i)).getApplicationProperty("msgId"));
                ((AmqpMessage)messages.get(i)).accept(txnSession, false);
            }
            txnSession.commit();
            txnSession.begin();
            for (i = 5; i < 10; ++i) {
                logger.debug("Rollback: Accepting message: {}", ((AmqpMessage)messages.get(i)).getApplicationProperty("msgId"));
                ((AmqpMessage)messages.get(i)).accept(txnSession, false);
            }
            txnSession.rollback();
            AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
            logger.debug("Read message: {}", message.getApplicationProperty("msgId"));
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)10, (Object)message.getApplicationProperty("msgId"));
            message.release();
            txnSession.begin();
            for (int i3 = 5; i3 < 10; ++i3) {
                ((AmqpMessage)messages.get(i3)).accept(txnSession);
            }
            txnSession.commit();
            receiver.flow(1);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            logger.debug("Read message: {}", message.getApplicationProperty("msgId"));
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)10, (Object)message.getApplicationProperty("msgId"));
            message.accept();
            receiver.flow(1);
            message = receiver.receive(1L, TimeUnit.SECONDS);
            if (message != null) {
                logger.debug("Read message: {}", message.getApplicationProperty("msgId"));
            }
            Assertions.assertNull((Object)message);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testCommitAndRollbackWithMultipleSessionsInSingleTXNoSettlement() throws Exception {
        int NUM_MESSAGES = 10;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = client.connect();
        AmqpSession txnSession = connection.createSession();
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (int i = 0; i < 10; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setText("Test-Message");
            message.setApplicationProperty("msgId", i);
            sender.send(message, txnSession.getTransactionId());
        }
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(2);
        AmqpMessage message1 = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver.receive(5L, TimeUnit.SECONDS);
        txnSession.begin();
        message1.accept(txnSession, false);
        logger.debug("Commit: accepting message: {}", message1.getApplicationProperty("msgId"));
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setApplicationProperty("msgId", 10);
        sender.send(message, txnSession.getTransactionId());
        txnSession.commit();
        txnSession.begin();
        message2.accept(txnSession, false);
        logger.debug("Rollback: accepting message: {}", message2.getApplicationProperty("msgId"));
        message = new AmqpMessage();
        message.setText("Test-Message");
        message.setApplicationProperty("msgId", 11);
        sender.send(message, txnSession.getTransactionId());
        txnSession.rollback();
        message2.release();
        receiver.flow(10);
        for (int i = 1; i <= 10; ++i) {
            AmqpMessage message3 = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message3, (String)("Expected a message for: " + i));
            logger.debug("Accepting message: {}", message3.getApplicationProperty("msgId"));
            Assertions.assertEquals((Object)i, (Object)message3.getApplicationProperty("msgId"));
            message3.accept();
        }
        receiver.flow(1);
        Assertions.assertNull((Object)receiver.receive(1L, TimeUnit.SECONDS));
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testSendPersistentTX() throws Exception {
        int MESSAGE_COUNT = 2000;
        AtomicInteger errors = new AtomicInteger(0);
        this.server.createQueue(QueueConfiguration.of((String)"q1").setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)));
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://localhost:5672");
        Connection sendConnection = factory.createConnection();
        Connection consumerConnection = factory.createConnection();
        try {
            Thread receiverThread = new Thread(() -> {
                try {
                    consumerConnection.start();
                    Session consumerSession = consumerConnection.createSession(true, 0);
                    jakarta.jms.Queue q1 = consumerSession.createQueue("q1");
                    MessageConsumer consumer = consumerSession.createConsumer((Destination)q1);
                    for (int i = 1; i <= MESSAGE_COUNT; ++i) {
                        Message message = consumer.receive(5000L);
                        if (message == null) {
                            throw new IOException("No message read in time.");
                        }
                        if (i % 100 != 0) continue;
                        if (i % 1000 == 0) {
                            logger.debug("Read message {}", (Object)i);
                        }
                        consumerSession.commit();
                    }
                    consumerSession.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            });
            receiverThread.start();
            Session sendingSession = sendConnection.createSession(true, 0);
            jakarta.jms.Queue q1 = sendingSession.createQueue("q1");
            MessageProducer producer = sendingSession.createProducer((Destination)q1);
            producer.setDeliveryDelay(1L);
            for (int i = 0; i < MESSAGE_COUNT; ++i) {
                producer.send((Message)sendingSession.createTextMessage("message " + i), 2, 4, 0L);
                if (i % 100 != 0) continue;
                if (i % 1000 == 0) {
                    logger.debug("Sending {}", (Object)i);
                }
                sendingSession.commit();
            }
            sendingSession.commit();
            receiverThread.join(50000L);
            Assertions.assertFalse((boolean)receiverThread.isAlive());
            Assertions.assertEquals((int)0, (int)errors.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sendConnection.close();
            consumerConnection.close();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testUnsettledTXMessageGetTransactedDispostion() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Assertions.assertNotNull((Object)session);
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.setStateInspector(new AmqpValidator(){

            @Override
            public void inspectDeliveryUpdate(Sender sender, Delivery delivery) {
                if (delivery.remotelySettled()) {
                    TransactionalState txState;
                    logger.debug("Receiver got delivery update for: {}", (Object)delivery);
                    if (!(delivery.getRemoteState() instanceof TransactionalState)) {
                        this.markAsInvalid("Transactionally acquire work no tagged as being in a transaction.");
                    } else {
                        txState = (TransactionalState)delivery.getRemoteState();
                        if (!(txState.getOutcome() instanceof Accepted)) {
                            this.markAsInvalid("Transaction state lacks any outcome");
                        } else if (txState.getTxnId() == null) {
                            this.markAsInvalid("Transaction state lacks any TX Id");
                        }
                    }
                    if (!(delivery.getLocalState() instanceof TransactionalState)) {
                        this.markAsInvalid("Transactionally acquire work no tagged as being in a transaction.");
                    } else {
                        txState = (TransactionalState)delivery.getLocalState();
                        if (!(txState.getOutcome() instanceof Accepted)) {
                            this.markAsInvalid("Transaction state lacks any outcome");
                        } else if (txState.getTxnId() == null) {
                            this.markAsInvalid("Transaction state lacks any TX Id");
                        }
                    }
                    TransactionalState localTxState = (TransactionalState)delivery.getLocalState();
                    TransactionalState remoteTxState = (TransactionalState)delivery.getRemoteState();
                    if (!localTxState.getTxnId().equals((Object)remoteTxState)) {
                        this.markAsInvalid("Message not enrolled in expected transaction");
                    }
                }
            }
        });
        session.begin();
        Assertions.assertTrue((boolean)session.isInTransaction());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(2L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        received.accept(false);
        session.commit();
        sender.getStateInspector().assertValid();
        connection.close();
    }
}

