/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class DrainTimeoutTest
extends AmqpClientTestSupport {
    final int NUMBER_OF_MESSAGES = 1000;

    @Test
    @Timeout(value=60L)
    public void testFlowControl() throws Exception {
        AtomicInteger errors = new AtomicInteger(0);
        String queueName = this.getQueueName();
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory("amqp://localhost:5672?jms.prefetchPolicy.all=1&jms.connectTimeout=60000&amqp.drainTimeout=1000");
        LongAdder sendCount = new LongAdder();
        LongAdder consumeCount = new LongAdder();
        Thread consumerThread = new Thread(() -> {
            try (JMSContext listenerContext = connectionFactory.createContext(1);
                 JMSConsumer consumer = listenerContext.createConsumer((Destination)listenerContext.createQueue(queueName));){
                while (!Thread.interrupted()) {
                    while (consumer.receiveNoWait() != null) {
                        consumeCount.increment();
                        if (consumeCount.sum() != 1000L) continue;
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                errors.incrementAndGet();
            }
        });
        consumerThread.start();
        try (JMSContext context = connectionFactory.createContext(1);){
            Message message = context.createMessage();
            message.setStringProperty("selector", "dude");
            JMSProducer producer = context.createProducer();
            Queue queue = context.createQueue(queueName);
            while (sendCount.sum() < 1000L && !Thread.interrupted()) {
                producer.send((Destination)queue, message);
                sendCount.increment();
                long l = sendCount.sum();
            }
        }
        consumerThread.join();
        Assertions.assertEquals((int)0, (int)errors.get());
    }
}

