/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.lang.constant.Constable;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.protonj2.test.driver.ProtonTestClient;
import org.apache.qpid.protonj2.test.driver.ProtonTestServer;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.MessageAnnotationsMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.TransferPayloadCompositeMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedAmqpValueMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jgroups.util.UUID;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationConnectTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    @Timeout(value=20L)
    public void testBrokerConnectsWithAnonymous() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect(new String[]{"PLAIN", "ANONYMOUS"});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederatedBrokerConnectsWithPlain() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLPlainConnect("user", "pass", new String[]{"PLAIN", "ANONYMOUS"});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            amqpConnection.setUser("user");
            amqpConnection.setPassword("pass");
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationConfiguredCreatesControlLink() throws Exception {
        int AMQP_MIN_LARGE_MESSAGE_SIZE = 10000;
        int AMQP_CREDITS = 100;
        int AMQP_CREDITS_LOW = 50;
        int AMQP_PULL_CREDITS_BATCH = 50;
        int AMQP_LINK_ATTACH_TIMEOUT = 60;
        boolean AMQP_TUNNEL_CORE_MESSAGES = false;
        boolean AMQP_INGNORE_CONSUMER_FILTERS = false;
        boolean AMQP_INGNORE_CONSUMER_PRIORITIES = false;
        HashMap<String, Constable> federationConfiguration = new HashMap<String, Constable>();
        federationConfiguration.put("amqpCredits", Integer.valueOf(100));
        federationConfiguration.put("amqpLowCredits", Integer.valueOf(50));
        federationConfiguration.put("amqpPullConsumerCredits", Integer.valueOf(50));
        federationConfiguration.put("minLargeMessageSize", Integer.valueOf(10000));
        federationConfiguration.put("attach-timeout", Integer.valueOf(60));
        federationConfiguration.put("ignoreQueueConsumerFilters", Boolean.valueOf(false));
        federationConfiguration.put("ignoreQueueConsumerPriorities", Boolean.valueOf(false));
        federationConfiguration.put("tunnel-core-messages", Boolean.valueOf(false));
        String controlLinkAddress = "test-control-address";
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect(new String[]{"PLAIN", "ANONYMOUS"});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"federation-"), CoreMatchers.containsString((String)"myFederation")})).withProperty(AMQPFederationConstants.FEDERATION_CONFIGURATION.toString(), federationConfiguration).withTarget().withDynamic(true).withCapabilities(new String[]{"temporary-topic"}).and().respond().withTarget().withAddress("test-control-address").and().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort() + "?amqpCredits=100&amqpLowCredits=50&amqpMinLargeMessageSize=10000");
            amqpConnection.setReconnectAttempts(0);
            AMQPFederatedBrokerConnectionElement federation = new AMQPFederatedBrokerConnectionElement("myFederation");
            federation.addProperty("attach-timeout", (Number)60);
            federation.addProperty("tunnel-core-messages", Boolean.toString(false));
            federation.addProperty("amqpPullConsumerCredits", (Number)50);
            amqpConnection.addElement((AMQPBrokerConnectionElement)federation);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.locateQueue("$ACTIVEMQ_ARTEMIS_FEDERATION.control.test-control-address") != null);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesControlLinkAndClosesConnectionIfCapabilityIsAbsent() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect(new String[]{"PLAIN", "ANONYMOUS"});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond();
            peer.expectClose().optional();
            peer.expectConnectionToDrop();
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPFederatedBrokerConnectionElement(this.getTestName()));
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesControlLinkAndClosesConnectionDetachIndicatesNotAuthorized() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect(new String[]{"PLAIN", "ANONYMOUS"});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()}).withSource().also().withNullTarget();
            peer.remoteDetach().withErrorCondition("amqp:unauthorized-access", "Not authroized").queue();
            peer.expectDetach().optional();
            peer.expectClose().optional();
            peer.expectConnectionToDrop();
            peer.expectSASLAnonymousConnect(new String[]{"PLAIN", "ANONYMOUS"});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind().withTarget().withAddress("dynamic-name");
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(1);
            amqpConnection.setRetryInterval(200);
            amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPFederatedBrokerConnectionElement(this.getTestName()));
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(10L, TimeUnit.SECONDS);
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationSendsReceiveFromQueuePolicyToRemoteWhenSendToIsConfigured() throws Exception {
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.OPERATION_TYPE.toString(), Matchers.is((Object)"ADD_QUEUE_POLICY"));
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("a");
        includes.add("b");
        includes.add("c");
        includes.add("d");
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("e");
        excludes.add("f");
        excludes.add("g");
        excludes.add("h");
        policyMap.put("policy-name", "test-policy");
        policyMap.put("include-federated", true);
        policyMap.put("priority-adjustment", 42);
        policyMap.put("queue-includes", includes);
        policyMap.put("queue-excludes", excludes);
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(policyMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic");
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectTransfer().withPayload((Matcher)payloadMatcher);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement sendToQueue = new AMQPFederationQueuePolicyElement();
            sendToQueue.setName("test-policy");
            sendToQueue.setIncludeFederated(true);
            sendToQueue.setPriorityAdjustment(Integer.valueOf(42));
            sendToQueue.addToIncludes("a", "b");
            sendToQueue.addToIncludes("c", "d");
            sendToQueue.addToExcludes("e", "f");
            sendToQueue.addToExcludes("g", "h");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addRemoteQueuePolicy(sendToQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationSendsReceiveFromQueuePolicyToRemoteWhenSendToIsConfiguredAndEventSenderRejected() throws Exception {
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.OPERATION_TYPE.toString(), Matchers.is((Object)"ADD_QUEUE_POLICY"));
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("a");
        includes.add("b");
        includes.add("c");
        includes.add("d");
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("e");
        excludes.add("f");
        excludes.add("g");
        excludes.add("h");
        policyMap.put("policy-name", "test-policy");
        policyMap.put("include-federated", true);
        policyMap.put("priority-adjustment", 42);
        policyMap.put("queue-includes", includes);
        policyMap.put("queue-excludes", excludes);
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(policyMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic");
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respond().withNullSource();
            peer.expectDetach().respond();
            peer.remoteFlow().withHandle(0L).withLinkCredit(10L).queue();
            peer.expectTransfer().withPayload((Matcher)payloadMatcher);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement sendToQueue = new AMQPFederationQueuePolicyElement();
            sendToQueue.setName("test-policy");
            sendToQueue.setIncludeFederated(true);
            sendToQueue.setPriorityAdjustment(Integer.valueOf(42));
            sendToQueue.addToIncludes("a", "b");
            sendToQueue.addToIncludes("c", "d");
            sendToQueue.addToExcludes("e", "f");
            sendToQueue.addToExcludes("g", "h");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addRemoteQueuePolicy(sendToQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationSendsReceiveFromAddressPolicyToRemoteWhenSendToIsConfigured() throws Exception {
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.OPERATION_TYPE.toString(), Matchers.is((Object)"ADD_ADDRESS_POLICY"));
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("include");
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("exclude");
        policyMap.put("policy-name", "test-policy");
        policyMap.put("auto-delete", true);
        policyMap.put("auto-delete-delay", 42L);
        policyMap.put("auto-delete-msg-count", 314L);
        policyMap.put("max-hops", 5);
        policyMap.put("enable-divert-bindings", false);
        policyMap.put("address-includes", includes);
        policyMap.put("address-excludes", excludes);
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(policyMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic");
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectTransfer().withPayload((Matcher)payloadMatcher);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement sendToAddress = new AMQPFederationAddressPolicyElement();
            sendToAddress.setName("test-policy");
            sendToAddress.setAutoDelete(Boolean.valueOf(true));
            sendToAddress.setAutoDeleteDelay(Long.valueOf(42L));
            sendToAddress.setAutoDeleteMessageCount(Long.valueOf(314L));
            sendToAddress.setMaxHops(5);
            sendToAddress.setEnableDivertBindings(Boolean.valueOf(false));
            sendToAddress.addToIncludes("include");
            sendToAddress.addToExcludes("exclude");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addRemoteAddressPolicy(sendToAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationSendsReceiveFromAddressPolicyToRemoteWhenSendToIsConfiguredAndEventSenderRejected() throws Exception {
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.OPERATION_TYPE.toString(), Matchers.is((Object)"ADD_ADDRESS_POLICY"));
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("include");
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("exclude");
        policyMap.put("policy-name", "test-policy");
        policyMap.put("auto-delete", true);
        policyMap.put("auto-delete-delay", 42L);
        policyMap.put("auto-delete-msg-count", 314L);
        policyMap.put("max-hops", 5);
        policyMap.put("enable-divert-bindings", false);
        policyMap.put("address-includes", includes);
        policyMap.put("address-excludes", excludes);
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(policyMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic");
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respond().withNullTarget();
            peer.expectDetach().respond();
            peer.remoteFlow().withHandle(0L).withLinkCredit(10L).queue();
            peer.expectTransfer().withPayload((Matcher)payloadMatcher);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement sendToAddress = new AMQPFederationAddressPolicyElement();
            sendToAddress.setName("test-policy");
            sendToAddress.setAutoDelete(Boolean.valueOf(true));
            sendToAddress.setAutoDeleteDelay(Long.valueOf(42L));
            sendToAddress.setAutoDeleteMessageCount(Long.valueOf(314L));
            sendToAddress.setMaxHops(5);
            sendToAddress.setEnableDivertBindings(Boolean.valueOf(false));
            sendToAddress.addToIncludes("include");
            sendToAddress.addToExcludes("exclude");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addRemoteAddressPolicy(sendToAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testConnectToBrokerFromRemoteAsFederatedSourceAndCreateControlLink() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, this.getTestName());
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
            logger.info("Test stopped");
        }
    }

    @Test
    @Timeout(value=20L)
    public void testConnectToBrokerFromRemoteAsFederatedSourceAndCreateEventsSenderLink() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, this.getTestName(), false, null, null, true, false);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
            logger.info("Test stopped");
        }
    }

    @Test
    @Timeout(value=20L)
    public void testConnectToBrokerFromRemoteAsFederatedSourceAndCreateEventsReceiverLink() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, this.getTestName(), false, null, null, false, true);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
            logger.info("Test stopped");
        }
    }

    @Test
    @Timeout(value=20L)
    public void testConnectToBrokerFromRemoteAsFederatedSourceAndCreateEventsLinks() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, this.getTestName(), false, null, null, true, true);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
            logger.info("Test stopped");
        }
    }

    @Test
    @Timeout(value=20L)
    public void testControlLinkPassesConnectAttemptWhenUserHasPrivledges() throws Exception {
        this.enableSecurity(this.server, "$ACTIVEMQ_ARTEMIS_FEDERATION");
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, this.getTestName(), this.fullUser, this.fullPass);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
            logger.info("Test stopped");
        }
    }

    @Test
    @Timeout(value=20L)
    public void testControlAndEventsLinksPassesConnectAttemptWhenUserHasPrivledges() throws Exception {
        this.enableSecurity(this.server, "$ACTIVEMQ_ARTEMIS_FEDERATION.#");
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemote(peer, this.getTestName(), true, this.fullUser, this.fullPass, true, true);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
            logger.info("Test stopped");
        }
    }

    @Test
    @Timeout(value=20L)
    public void testControlLinkRefusesConnectAttemptWhenUseDoesNotHavePrivledgesForControlAddress() throws Exception {
        this.enableSecurity(this.server, "$ACTIVEMQ_ARTEMIS_FEDERATION");
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            this.scriptFederationConnectToRemoteNotAuthorizedForControlAddress(peer, this.getTestName(), this.guestUser, this.guestPass);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
            logger.info("Test stopped");
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteConnectionCannotAttachEventReceiverLinkWithoutControlLink() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            peer.queueClientSaslAnonymousConnect();
            peer.remoteOpen().queue();
            peer.expectOpen();
            peer.remoteBegin().queue();
            peer.expectBegin();
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-event-receiver").withNullSource().withTarget();
            peer.expectDetach().withError(AmqpError.ILLEGAL_STATE.toString()).respond();
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withName("federation-event-receiver").withSenderSettleModeSettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withCapabilities(new String[]{"temporary-topic"}).withDynamic(true).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteConnectionCannotAttachEventSenderLinkWithoutControlLink() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            peer.queueClientSaslAnonymousConnect();
            peer.remoteOpen().queue();
            peer.expectOpen();
            peer.remoteBegin().queue();
            peer.expectBegin();
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withName("federation-event-sender").withSource().also().withNullTarget();
            peer.expectDetach().withError(AmqpError.ILLEGAL_STATE.toString()).respond();
            peer.remoteAttach().ofSender().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withName("federation-event-sender").withSenderSettleModeSettled().withReceivervSettlesFirst().withTarget().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withCapabilities(new String[]{"temporary-topic"}).withDynamic(true).and().withSource().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testControlLinkSenderQueueCreatedWithMaxConsumersOfOne() throws Exception {
        String controlLinkAddress = "test-control-address";
        String federationControlSenderAddress = "$ACTIVEMQ_ARTEMIS_FEDERATION.control.test-control-address";
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect(new String[]{"PLAIN", "ANONYMOUS"});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"federation-"), CoreMatchers.containsString((String)"myFederation")})).withTarget().withDynamic(true).withCapabilities(new String[]{"temporary-topic"}).and().respond().withTarget().withAddress("test-control-address").and().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            AMQPFederatedBrokerConnectionElement federation = new AMQPFederatedBrokerConnectionElement("myFederation");
            amqpConnection.addElement((AMQPBrokerConnectionElement)federation);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.locateQueue("$ACTIVEMQ_ARTEMIS_FEDERATION.control.test-control-address") != null);
            peer.expectAttach().ofSender().withName("test-control-link-suspect").withNullSource();
            peer.expectDetach().withClosed(true).withError(AmqpError.INTERNAL_ERROR.toString());
            peer.remoteAttach().ofReceiver().withName("test-control-link-suspect").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withTarget().also().withSource().withAddress("$ACTIVEMQ_ARTEMIS_FEDERATION.control.test-control-address").also().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testEventSenderLinkFromTargetUsesNamespacedDynamicQueue() throws Exception {
        String federationControlLinkName = "federation-test";
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            peer.queueClientSaslAnonymousConnect();
            peer.remoteOpen().queue();
            peer.expectOpen();
            peer.remoteBegin().queue();
            peer.expectBegin();
            peer.remoteAttach().ofSender().withName("federation-test").withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.expectAttach().ofReceiver().withName("federation-test").withTarget().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString());
            peer.expectFlow();
            String federationEventsSenderLinkName = "events-receiver-test";
            peer.remoteAttach().ofReceiver().withName("events-receiver-test").withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withTarget().also().withSource().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofSender().withName("events-receiver-test").withSource().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString());
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.locateQueue("$ACTIVEMQ_ARTEMIS_FEDERATION.events.events-receiver-test") != null);
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testEventsLinkAtTargetIsCreatedWithMaxConsumersOfOne() throws Exception {
        String federationControlLinkName = "federation-test";
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            peer.queueClientSaslAnonymousConnect();
            peer.remoteOpen().queue();
            peer.expectOpen();
            peer.remoteBegin().queue();
            peer.expectBegin();
            peer.remoteAttach().ofSender().withName("federation-test").withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.expectAttach().ofReceiver().withName("federation-test").withTarget().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString());
            peer.expectFlow();
            String federationEventsSenderLinkName = "events-receiver-test";
            String federationEventsSenderAddress = "$ACTIVEMQ_ARTEMIS_FEDERATION.events.events-receiver-test";
            peer.remoteAttach().ofReceiver().withName("events-receiver-test").withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withTarget().also().withSource().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofSender().withName("events-receiver-test").withSource().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString());
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.locateQueue("$ACTIVEMQ_ARTEMIS_FEDERATION.events.events-receiver-test") != null);
            peer.expectAttach().ofSender().withName("test-events-link-suspect").withNullSource();
            peer.expectDetach().withClosed(true).withError(AmqpError.INTERNAL_ERROR.toString());
            peer.remoteAttach().ofReceiver().withName("test-events-link-suspect").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withTarget().also().withSource().withAddress("$ACTIVEMQ_ARTEMIS_FEDERATION.events.events-receiver-test").also().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testFederationDemandAddedAndImmediateBrokerShutdownOverlaps() throws Exception {
        for (int i = 0; i < 2; ++i) {
            this.doTestFederationDemandAddedAndImmediateBrokerShutdown();
        }
    }

    private void doTestFederationDemandAddedAndImmediateBrokerShutdown() throws Exception {
        if (this.server == null || !this.server.isStarted()) {
            this.server = this.createServer();
        }
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSenderSettleModeSettled().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationQueuePolicyElement receiveFromQueue = new AMQPFederationQueuePolicyElement();
            receiveFromQueue.setName("queue-policy");
            receiveFromQueue.addToIncludes("test", "test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalQueuePolicy(receiveFromQueue);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerAMQPFederationPlugin(){

                public void beforeCreateFederationConsumer(FederationConsumerInfo consumerInfo) throws ActiveMQException {
                    logger.debug("Delaying attach of outgoing federation receiver");
                    ForkJoinPool.commonPool().execute(() -> {
                        try {
                            AMQPFederationConnectTest.this.server.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                    try {
                        Thread.sleep(new Random(System.currentTimeMillis()).nextInt(8));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().optional();
            peer.expectFlow().optional();
            peer.expectDetach().optional();
            peer.expectClose().optional();
            peer.expectConnectionToDrop();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                connection.start();
                try {
                    session.createConsumer((Destination)session.createQueue("test"));
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    private void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName) {
        this.scriptFederationConnectToRemote(peer, federationName, false, null, null);
    }

    private void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, String username, String password) {
        this.scriptFederationConnectToRemote(peer, federationName, true, username, password);
    }

    private void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, boolean auth, String username, String password) {
        this.scriptFederationConnectToRemote(peer, federationName, auth, username, password, false, false);
    }

    private void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, boolean auth, String username, String password, boolean eventsSender, boolean eventsReceiver) {
        String federationEventsSenderLinkName;
        String federationControlLinkName = "Federation:test:" + UUID.randomUUID().toString();
        if (auth) {
            peer.queueClientSaslPlainConnect(username, password);
        } else {
            peer.queueClientSaslAnonymousConnect();
        }
        peer.remoteOpen().queue();
        peer.expectOpen();
        peer.remoteBegin().queue();
        peer.expectBegin();
        peer.remoteAttach().ofSender().withName(federationControlLinkName).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
        peer.expectAttach().ofReceiver().withName(federationControlLinkName).withTarget().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString());
        peer.expectFlow();
        if (eventsSender) {
            federationEventsSenderLinkName = "Federation:events-sender:test:" + UUID.randomUUID().toString();
            peer.remoteAttach().ofSender().withName(federationEventsSenderLinkName).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.expectAttach().ofReceiver().withName(federationEventsSenderLinkName).withTarget().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString());
            peer.expectFlow();
        }
        if (eventsReceiver) {
            federationEventsSenderLinkName = "Federation:events-receiver:test:" + UUID.randomUUID().toString();
            peer.remoteAttach().ofReceiver().withName(federationEventsSenderLinkName).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withTarget().also().withSource().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofSender().withName(federationEventsSenderLinkName).withSource().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString());
        }
    }

    private void scriptFederationConnectToRemoteNotAuthorizedForControlAddress(ProtonTestClient peer, String federationName, String username, String password) {
        String federationControlLinkName = "Federation:test:" + UUID.randomUUID().toString();
        peer.queueClientSaslPlainConnect(username, password);
        peer.remoteOpen().queue();
        peer.expectOpen();
        peer.remoteBegin().queue();
        peer.expectBegin();
        peer.remoteAttach().ofSender().withName(federationControlLinkName).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
        peer.expectAttach().ofReceiver().withTarget(CoreMatchers.nullValue());
        peer.expectDetach().withError("amqp:unauthorized-access", "User does not have permission to attach to the federation control address").respond();
        peer.remoteClose().queue();
        peer.expectClose();
    }
}

