/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.broadcast;

import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.ChannelBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.apache.activemq.artemis.tests.util.ArtemisTestCase;
import org.jgroups.JChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JGroupsBroadcastTest
extends ArtemisTestCase {
    @AfterEach
    public void cleanupJChannel() {
        JChannelManager.getInstance().clear();
    }

    @BeforeEach
    public void prepareJChannel() {
        JChannelManager.getInstance().setLoopbackMessages(true);
    }

    @Test
    public void testRefCount() throws Exception {
        JChannel channel = null;
        JChannel newChannel = null;
        try {
            channel = new JChannel("udp.xml");
            String channelName1 = "channel1";
            ChannelBroadcastEndpointFactory jgroupsBroadcastCfg1 = new ChannelBroadcastEndpointFactory(channel, channelName1);
            BroadcastEndpoint channelEndpoint1 = jgroupsBroadcastCfg1.createBroadcastEndpoint();
            BroadcastEndpoint channelEndpoint2 = jgroupsBroadcastCfg1.createBroadcastEndpoint();
            BroadcastEndpoint channelEndpoint3 = jgroupsBroadcastCfg1.createBroadcastEndpoint();
            channelEndpoint1.close(true);
            Assertions.assertTrue((boolean)channel.isOpen());
            channelEndpoint2.close(true);
            Assertions.assertTrue((boolean)channel.isOpen());
            channelEndpoint3.close(true);
            Assertions.assertTrue((boolean)channel.isOpen());
            channel.close();
            try {
                channelEndpoint2.openClient();
                Assertions.fail((String)"this should be closed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            newChannel = new JChannel("udp.xml");
            jgroupsBroadcastCfg1 = new ChannelBroadcastEndpointFactory(newChannel, channelName1);
            channelEndpoint1 = jgroupsBroadcastCfg1.createBroadcastEndpoint();
            channelEndpoint1.openClient();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                channel.close();
            }
            catch (Throwable throwable) {}
            try {
                newChannel.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

