/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cli;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.RecoverMessages;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class RecoverTest
extends JMSTestBase {
    boolean useTX;
    String protocol;
    boolean paging;
    boolean large;
    String journalType;

    public RecoverTest(boolean useTX, String protocol, boolean paging, boolean large, String journalType) {
        this.useTX = useTX;
        this.protocol = protocol;
        this.paging = paging;
        this.large = large;
        this.journalType = journalType;
    }

    @Parameters(name="useTX={0}, protocol={1}, paging={2}, largeMessage={3}, journal-type={4}")
    public static Collection<Object[]> data() {
        Object[] journalType = LibaioContext.isLoaded() ? new Object[]{"AIO", "NIO", "MAPPED"} : new Object[]{"NIO", "MAPPED"};
        return RecoverTest.combine(new Object[]{true, false}, new Object[]{"AMQP", "CORE", "OPENWIRE"}, new Object[]{true, false}, new Object[]{true, false}, journalType);
    }

    protected static Collection<Object[]> combine(Object[] one, Object[] two, Object[] three, Object[] four, Object[] five) {
        ArrayList<Object[]> combinations = new ArrayList<Object[]>();
        for (Object o1 : one) {
            for (Object o2 : two) {
                for (Object o3 : three) {
                    for (Object o4 : four) {
                        for (Object o5 : five) {
                            combinations.add(new Object[]{o1, o2, o3, o4, o5});
                        }
                    }
                }
            }
        }
        return combinations;
    }

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        Configuration configuration = super.createDefaultConfig(netty).setJMXManagementEnabled(true);
        configuration.setJournalRetentionDirectory(this.getTestDir() + "/historyJournal");
        switch (this.journalType) {
            case "NIO": {
                configuration.setJournalType(JournalType.NIO);
                break;
            }
            case "MAPPED": {
                configuration.setJournalType(JournalType.MAPPED);
                break;
            }
            case "AIO": {
                configuration.setJournalType(JournalType.ASYNCIO);
            }
        }
        return configuration;
    }

    @Override
    protected boolean usePersistence() {
        return true;
    }

    @TestTemplate
    public void testRecover() throws Exception {
        int i;
        this.createQueue(true, "TestQueue");
        Queue serverQueue = this.server.locateQueue("TestQueue");
        if (this.paging) {
            serverQueue.getPagingStore().startPaging();
        }
        ConnectionFactory factory = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        Connection connection = factory.createConnection();
        this.addConnection(connection);
        Session session = connection.createSession(this.useTX, this.useTX ? 0 : 1);
        jakarta.jms.Queue queue = session.createQueue("TestQueue");
        MessageProducer producer = session.createProducer((Destination)queue);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.large) {
            i = 0;
            while (stringBuffer.length() < 112640) {
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append("hello");
        }
        String messageBody = stringBuffer.toString();
        int maxMessage = this.large ? 10 : 1000;
        for (i = 0; i < maxMessage; ++i) {
            producer.send((Message)session.createTextMessage(i + messageBody));
        }
        if (this.useTX) {
            session.commit();
        }
        this.server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(60000);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        connection.start();
        for (int i2 = 0; i2 < maxMessage; ++i2) {
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            if (this.protocol.equals("OPENWIRE")) continue;
            Assertions.assertEquals((Object)(i2 + messageBody), (Object)message.getText());
        }
        if (this.useTX) {
            session.commit();
        }
        connection.close();
        Wait.assertFalse(() -> ((PagingStore)serverQueue.getPagingStore()).isPaging());
        this.server.stop();
        File newJournalLocation = new File(this.server.getConfiguration().getJournalLocation().getParentFile(), "recovered");
        RecoverMessages.recover((ActionContext)new ActionContext(), (Configuration)this.server.getConfiguration(), (String)this.server.getConfiguration().getJournalRetentionDirectory(), (File)newJournalLocation, (File)this.server.getConfiguration().getLargeMessagesLocation(), (boolean)false);
        if (this.large) {
            File[] largeMessageFiles = this.server.getConfiguration().getLargeMessagesLocation().listFiles();
            Assertions.assertEquals((int)maxMessage, (int)largeMessageFiles.length);
            for (File f : largeMessageFiles) {
                Assertions.assertTrue((f.length() > 0L ? 1 : 0) != 0, (String)("File length was " + f.length()));
            }
        }
        this.server.getConfiguration().setJournalDirectory(newJournalLocation.getAbsolutePath());
        this.server.start();
        factory = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        connection = factory.createConnection();
        this.addConnection(connection);
        session = connection.createSession(this.useTX, this.useTX ? 0 : 1);
        connection.start();
        consumer = session.createConsumer((Destination)queue);
        for (int i3 = 0; i3 < maxMessage; ++i3) {
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            if (this.protocol.equals("OPENWIRE")) continue;
            Assertions.assertEquals((Object)(i3 + messageBody), (Object)message.getText());
        }
        Assertions.assertNull((Object)consumer.receiveNoWait());
        if (this.useTX) {
            session.commit();
        }
        connection.close();
    }
}

