/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerRoundRobinTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");

    @Test
    public void testConsumersRoundRobinCorrectly() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(cf.createSession(false, true, true));
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientConsumer[] consumers = new ClientConsumer[5];
        session.start();
        consumers[0] = session.createConsumer(this.queueA);
        consumers[1] = session.createConsumer(this.queueA);
        consumers[2] = session.createConsumer(this.queueA);
        consumers[3] = session.createConsumer(this.queueA);
        consumers[4] = session.createConsumer(this.queueA);
        ClientProducer cp = session.createProducer(this.addressA);
        int numMessage = 10;
        for (int i = 0; i < numMessage; ++i) {
            ClientMessage cm = session.createMessage(false);
            cm.getBodyBuffer().writeInt(i);
            cp.send((Message)cm);
        }
        int currMessage = 0;
        for (int i = 0; i < numMessage / 5; ++i) {
            logger.debug("i is {}", (Object)i);
            for (int j = 0; j < 5; ++j) {
                logger.debug("j is {}", (Object)j);
                ClientMessage cm = consumers[j].receive(5000L);
                Assertions.assertNotNull((Object)cm);
                Assertions.assertEquals((int)currMessage++, (int)cm.getBodyBuffer().readInt());
                cm.acknowledge();
            }
        }
    }
}

