/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureDeadlockTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ActiveMQServer server;
    private ActiveMQConnectionFactory cf1;
    private ActiveMQConnectionFactory cf2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        this.server.start();
        this.cf1 = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        this.cf2 = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
    }

    @Test
    public void testDeadlock() throws Exception {
        for (int i = 0; i < 100; ++i) {
            Connection conn1 = this.cf1.createConnection();
            Session sess1 = conn1.createSession(false, 1);
            RemotingConnection rc1 = ((ClientSessionInternal)((ActiveMQSession)sess1).getCoreSession()).getConnection();
            Connection conn2 = this.cf2.createConnection();
            Session sess2 = conn2.createSession(false, 1);
            RemotingConnection rc2 = ((ClientSessionInternal)((ActiveMQSession)sess2).getCoreSession()).getConnection();
            ExceptionListener listener1 = exception -> {
                try {
                    conn2.close();
                }
                catch (Exception e) {
                    logger.error("Failed to close connection2", (Throwable)e);
                }
            };
            conn1.setExceptionListener(listener1);
            conn2.setExceptionListener(listener1);
            Failer f1 = new Failer(rc1);
            Failer f2 = new Failer(rc2);
            f1.start();
            f2.start();
            f1.join();
            f2.join();
            conn1.close();
            conn2.close();
        }
    }

    @Test
    public void testUsingDeadConnection() throws Exception {
        for (int i = 0; i < 100; ++i) {
            Connection conn1 = this.cf1.createConnection();
            Session sess1 = conn1.createSession(false, 1);
            RemotingConnection rc1 = ((ClientSessionInternal)((ActiveMQSession)sess1).getCoreSession()).getConnection();
            rc1.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException("blah")));
            try {
                conn1.createSession(false, 1);
                Assertions.fail((String)"should throw exception");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            conn1.close();
        }
    }

    private class Failer
    extends Thread {
        RemotingConnection conn;

        Failer(RemotingConnection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            this.conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException("blah")));
        }
    }
}

