/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionImpl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQSessionContext;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.XidCodecSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InvalidCoreClientTest
extends ActiveMQTestBase {
    private final Map<String, AddressSettings> addressSettings = new HashMap<String, AddressSettings>();
    private final SimpleString atestq = SimpleString.of((String)"BasicXaTestq");
    private ActiveMQServer messagingService;
    private ClientSession clientSession;
    private ClientSessionFactory sessionFactory;
    private Configuration configuration;
    private ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.addressSettings.clear();
        this.configuration = this.createDefaultNettyConfig();
        this.messagingService = this.createServer(true, this.configuration, -1, -1L, this.addressSettings);
        this.messagingService.start();
        this.locator = this.createInVMNonHALocator();
        this.sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.sessionFactory.createSession(true, false, false));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.atestq));
    }

    @Test
    public void testInvalidBufferXIDInvalidSize() throws Exception {
        this.internalTestInvalidXID(false);
    }

    @Test
    public void testInvalidBufferXIDNegative() throws Exception {
        this.internalTestInvalidXID(true);
    }

    private void internalTestInvalidXID(boolean useNegative) throws Exception {
        ClientSession clientSession2 = this.sessionFactory.createSession(false, true, true);
        ClientProducer clientProducer = clientSession2.createProducer(this.atestq);
        ClientMessage m1 = this.createTextMessage(clientSession2, "m1");
        clientProducer.send((Message)m1);
        XidImpl xid = this.newXID();
        this.clientSession.start((Xid)xid, 0);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(this.atestq);
        ClientMessage message = clientConsumer.receive(5000L);
        message.acknowledge();
        this.clientSession.end((Xid)xid, 0x4000000);
        Channel channel = ((ActiveMQSessionContext)((ClientSessionImpl)this.clientSession).getSessionContext()).getSessionChannel();
        final AtomicInteger connFailure = new AtomicInteger(0);
        this.clientSession.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                connFailure.incrementAndGet();
            }
        });
        SessionXAPrepareMessage packet = new SessionXAPrepareMessage((Xid)xid, (Xid)xid, useNegative){
            final /* synthetic */ Xid val$xid;
            final /* synthetic */ boolean val$useNegative;
            {
                this.val$xid = xid;
                this.val$useNegative = bl;
                super(arg0);
            }

            public void encodeRest(ActiveMQBuffer buffer) {
                ActiveMQBuffer bufferTmp = ActiveMQBuffers.dynamicBuffer((int)255);
                XidCodecSupport.encodeXid((Xid)this.val$xid, (ActiveMQBuffer)bufferTmp);
                if (this.val$useNegative) {
                    bufferTmp.setByte(4, (byte)15);
                } else {
                    bufferTmp.setByte(4, (byte)-1);
                }
                byte[] bytes = new byte[bufferTmp.readableBytes()];
                bufferTmp.readBytes(bytes);
                buffer.writeBytes(bytes);
            }
        };
        try {
            channel.sendBlocking((Packet)packet, (byte)55);
            Assertions.fail((String)"Failure expected");
        }
        catch (Exception exception) {
        }
        Wait.assertEquals((int)1, connFailure::get);
    }
}

