/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JmsNettyNioStressTest
extends ActiveMQTestBase {
    @Test
    public void testStressSendNetty() throws Exception {
        this.doTestStressSend(true);
    }

    public void doTestStressSend(boolean netty) throws Exception {
        int i;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("port", 61616);
        params.put("host", "localhost");
        params.put("useNio", true);
        params.put("nioRemotingThreads", 1);
        params.put("batchDelay", 50);
        TransportConfiguration transportConfig = new TransportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY, params);
        ConfigurationImpl config = this.createBasicConfig().setJMXManagementEnabled(false).clearAcceptorConfigurations().addAcceptorConfiguration(transportConfig);
        ActiveMQServer server = this.createServer(true, (Configuration)config);
        server.getAddressSettingsRepository().clear();
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(0xA00000).setMaxSizeBytes(-1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoDeleteAddresses(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(false));
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        server.getConfiguration().setThreadPoolMaxSize(2);
        server.start();
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        connectionParams.put("port", 61616);
        connectionParams.put("host", "localhost");
        connectionParams.put("useNio", true);
        connectionParams.put("batchDelay", 50);
        connectionParams.put("nioRemotingThreads", 6);
        TransportConfiguration transpConf = new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams);
        ServerLocator locator = this.createNonHALocator(netty);
        int numberOfMessages = 100;
        int numProducers = 5;
        int numConsumerProducers = 5;
        int numConsumers = 5;
        AtomicInteger totalCount = new AtomicInteger(0);
        int totalExpectedCount = 1500;
        ClientSessionFactory sf = locator.createSessionFactory(transpConf);
        ClientSession session = sf.createTransactedSession();
        session.createAddress(SimpleString.of((String)"queue"), RoutingType.ANYCAST, false);
        session.createAddress(SimpleString.of((String)"queue2"), RoutingType.ANYCAST, false);
        Assertions.assertTrue((boolean)session.addressQuery(SimpleString.of((String)"queue")).isExists());
        Assertions.assertTrue((boolean)session.addressQuery(SimpleString.of((String)"queue2")).isExists());
        session.createQueue(QueueConfiguration.of((String)"queue").setRoutingType(RoutingType.ANYCAST));
        session.createQueue(QueueConfiguration.of((String)"queue2").setRoutingType(RoutingType.ANYCAST));
        Assertions.assertTrue((boolean)session.addressQuery(SimpleString.of((String)"queue")).isExists());
        Assertions.assertTrue((boolean)session.addressQuery(SimpleString.of((String)"queue2")).isExists());
        session.commit();
        sf.close();
        session.close();
        locator.close();
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transpConf});
        Connection connectionProducer = cf.createConnection();
        connectionProducer.start();
        Connection connectionConsumerProducer = cf.createConnection();
        connectionConsumerProducer.start();
        Connection connectionConsumer = cf.createConnection();
        connectionConsumer.start();
        session.close();
        for (i = 0; i < 5; ++i) {
            new Thread(() -> {
                Session session1 = null;
                try {
                    session1 = connectionProducer.createSession(true, 0);
                    MessageProducer messageProducer = session1.createProducer((Destination)ActiveMQDestination.createQueue((String)"queue"));
                    messageProducer.setDeliveryMode(1);
                    for (int i1 = 0; i1 < 100; ++i1) {
                        BytesMessage message = session1.createBytesMessage();
                        message.writeBytes(new byte[3000]);
                        message.setStringProperty("Service", "LoadShedService");
                        message.setStringProperty("Action", "testAction");
                        messageProducer.send((Message)message);
                        session1.commit();
                        totalCount.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (session1 != null) {
                        try {
                            session1.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        for (i = 0; i < 5; ++i) {
            new Thread(() -> {
                Session session13 = null;
                try {
                    session13 = connectionConsumerProducer.createSession(true, 0);
                    MessageConsumer consumer = session13.createConsumer((Destination)ActiveMQDestination.createQueue((String)"queue"));
                    MessageProducer messageProducer = session13.createProducer((Destination)ActiveMQDestination.createQueue((String)"queue2"));
                    messageProducer.setDeliveryMode(1);
                    for (int i13 = 0; i13 < 100; ++i13) {
                        BytesMessage message = (BytesMessage)consumer.receive(5000L);
                        if (message == null) {
                            return;
                        }
                        message = session13.createBytesMessage();
                        message.writeBytes(new byte[3000]);
                        message.setStringProperty("Service", "LoadShedService");
                        message.setStringProperty("Action", "testAction");
                        messageProducer.send((Message)message);
                        session13.commit();
                        totalCount.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (session13 != null) {
                        try {
                            session13.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        for (i = 0; i < 5; ++i) {
            new Thread(() -> {
                Session session12 = null;
                try {
                    session12 = connectionConsumer.createSession(true, 0);
                    MessageConsumer consumer = session12.createConsumer((Destination)ActiveMQDestination.createQueue((String)"queue2"));
                    for (int i12 = 0; i12 < 100; ++i12) {
                        BytesMessage message = (BytesMessage)consumer.receive(5000L);
                        if (message == null) {
                            return;
                        }
                        session12.commit();
                        totalCount.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (session12 != null) {
                        try {
                            session12.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        Wait.waitFor(() -> totalExpectedCount == totalCount.get(), (long)60000L, (long)100L);
        Assertions.assertEquals((int)totalExpectedCount, (int)totalCount.get(), (String)"Possible deadlock");
        connectionProducer.close();
        connectionConsumerProducer.close();
        connectionConsumer.close();
        server.stop();
    }
}

