/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SessionCreateAndDeleteQueueTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString address = SimpleString.of((String)"address");
    private final SimpleString queueName = SimpleString.of((String)"queue");
    private ServerLocator locator;

    @Test
    public void testDurableFalse() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assertions.assertFalse((boolean)q.isDurable());
        session.close();
    }

    @Test
    public void testDurableTrue() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setAddress(this.address));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assertions.assertTrue((boolean)q.isDurable());
        session.close();
    }

    @Test
    public void testTemporaryFalse() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assertions.assertFalse((boolean)q.isTemporary());
        session.close();
    }

    @Test
    public void testTemporaryTrue() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assertions.assertTrue((boolean)q.isTemporary());
        session.close();
    }

    @Test
    public void testcreateWithFilter() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        SimpleString filterString = SimpleString.of((String)"x=y");
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setAddress(this.address).setFilterString(filterString).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assertions.assertEquals((Object)q.getFilter().getFilterString(), (Object)filterString);
        session.close();
    }

    @Test
    public void testAddressSettingUSed() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)new AddressSettings().setDefaultLastValueQueue(true));
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setAddress(this.address).setFilterString("x=y").setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Assertions.assertTrue((boolean)(binding.getBindable() instanceof LastValueQueue));
        session.close();
    }

    @Test
    public void testDeleteQueue() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Assertions.assertNotNull((Object)binding);
        session.deleteQueue(this.queueName);
        binding = this.server.getPostOffice().getBinding(this.queueName);
        Assertions.assertNull((Object)binding);
        session.close();
    }

    @Test
    public void testDeleteQueueNotExist() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        try {
            session.deleteQueue(this.queueName);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }
}

