/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TopicClusteredOffTest
extends ClusterTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    private void start() throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
    }

    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testTopicRedistributionOff() throws Exception {
        this.internalTest(false);
    }

    @Test
    public void testTopicRedistributionOn() throws Exception {
        this.internalTest(true);
    }

    private void internalTest(boolean redisitribute) throws Exception {
        TextMessage message;
        int i;
        MessageConsumer consumer;
        Session session;
        if (redisitribute) {
            this.setupCluster(MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION);
        } else {
            this.setupCluster(MessageLoadBalancingType.OFF);
        }
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.dist", "queue0", null, false);
        this.createQueue(1, "queues.dist", "queue1", null, false);
        this.waitForBindings(0, "queues.dist", 1, 0, true);
        this.waitForBindings(0, "queues.dist", 1, 0, false);
        this.waitForBindings(1, "queues.dist", 1, 0, true);
        this.waitForBindings(1, "queues.dist", 1, 0, false);
        ConnectionFactory factory0 = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616");
        ConnectionFactory factory1 = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61617");
        try (Connection connection = factory0.createConnection();){
            session = connection.createSession(true, 0);
            Topic topic = session.createTopic("queues.dist");
            MessageProducer producer = session.createProducer((Destination)topic);
            for (int i2 = 0; i2 < 10; ++i2) {
                producer.send((Message)session.createTextMessage("message" + i2));
            }
            session.commit();
            connection.start();
            MessageConsumer consumer2 = session.createConsumer((Destination)session.createTopic("queues.dist::queue0"));
            for (int i3 = 0; i3 < 10; ++i3) {
                TextMessage message2 = (TextMessage)consumer2.receive(5000L);
                Assertions.assertNotNull((Object)message2);
                Assertions.assertEquals((Object)("message" + i3), (Object)message2.getText());
            }
            session.rollback();
        }
        connection = factory1.createConnection();
        try {
            session = connection.createSession(true, 0);
            connection.start();
            consumer = session.createConsumer((Destination)session.createTopic("queues.dist::queue1"));
            for (i = 0; i < 10; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("message" + i), (Object)message.getText());
            }
            session.rollback();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        this.createQueue(1, "queues.dist", "queue0", null, false);
        this.waitForBindings(0, "queues.dist", 1, 0, true);
        this.waitForBindings(0, "queues.dist", 2, 0, false);
        this.waitForBindings(1, "queues.dist", 2, 0, true);
        this.waitForBindings(1, "queues.dist", 1, 0, false);
        connection = factory1.createConnection();
        try {
            session = connection.createSession(false, 1);
            connection.start();
            consumer = session.createConsumer((Destination)session.createTopic("queues.dist::queue0"));
            if (redisitribute) {
                for (i = 0; i < 10; ++i) {
                    message = (TextMessage)consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)("message" + i), (Object)message.getText());
                }
            } else {
                TextMessage message3 = (TextMessage)consumer.receive(100L);
                Assertions.assertNull((Object)message3, (String)"Messages are being redistributed");
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void setRedistributionDelay(long delay) {
        AddressSettings as = new AddressSettings().setRedistributionDelay(delay);
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
        this.clearServer(0, 1);
    }
}

