/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.tests.integration.cluster.failover.StaticClusterWithBackupFailoverTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientConnectorFailoverTest
extends StaticClusterWithBackupFailoverTest {
    private static final String TEST_PARAM = "TEST";

    @Override
    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testConsumerAfterFailover() throws Exception {
        this.setupCluster();
        this.startServers(this.getPrimaryServerIDs());
        this.startServers(this.getBackupServerIDs());
        for (int i : this.getPrimaryServerIDs()) {
            ClientConnectorFailoverTest.waitForTopology(this.servers[i], 3, 3);
        }
        for (int i : this.getBackupServerIDs()) {
            this.waitForFailoverTopology(i, 0, 1, 2);
        }
        for (int i : this.getPrimaryServerIDs()) {
            this.setupSessionFactory(i, i + 3, this.isNetty(), false);
            this.createQueue(i, "queues.testaddress", "queue0", null, true);
        }
        ArrayList<TransportConfiguration> transportConfigList = new ArrayList<TransportConfiguration>();
        for (int i : this.getServerIDs()) {
            Map<String, Object> params = ClientConnectorFailoverTest.generateParams(i, this.isNetty());
            TransportConfiguration serverToTC = ClientConnectorFailoverTest.createTransportConfiguration("node" + i, this.isNetty(), false, params);
            serverToTC.getExtraParams().put(TEST_PARAM, TEST_PARAM);
            transportConfigList.add(serverToTC);
        }
        TransportConfiguration[] transportConfigs = transportConfigList.toArray(new TransportConfiguration[transportConfigList.size()]);
        try (ServerLocatorImpl serverLocator = new ServerLocatorImpl(true, transportConfigs);){
            serverLocator.setReconnectAttempts(-1);
            try (ClientSessionFactory sessionFactory = serverLocator.createSessionFactory();
                 ClientSession clientSession = sessionFactory.createSession();){
                clientSession.start();
                TransportConfiguration backupConnector = (TransportConfiguration)((ClientSessionFactoryImpl)sessionFactory).getBackupConnector();
                Assertions.assertNotEquals((Object)backupConnector.getName(), (Object)sessionFactory.getConnectorConfiguration().getName());
                int serverIdBeforeCrash = Integer.parseInt(sessionFactory.getConnectorConfiguration().getName().substring(4));
                try (ClientProducer clientProducer = clientSession.createProducer("queues.testaddress");){
                    clientProducer.send((org.apache.activemq.artemis.api.core.Message)clientSession.createMessage(true));
                }
                ClientConnectorFailoverTest.crashAndWaitForFailure(this.getServer(serverIdBeforeCrash), clientSession);
                Assertions.assertEquals((Object)backupConnector.getName(), (Object)sessionFactory.getConnectorConfiguration().getName());
                Assertions.assertEquals((Object)TEST_PARAM, sessionFactory.getConnectorConfiguration().getExtraParams().get(TEST_PARAM));
                int serverIdAfterCrash = Integer.parseInt(sessionFactory.getConnectorConfiguration().getName().substring(4));
                Assertions.assertNotEquals((int)serverIdBeforeCrash, (int)serverIdAfterCrash);
                try (ClientConsumer clientConsumer = clientSession.createConsumer("queue0");){
                    Assertions.assertNotNull((Object)clientConsumer.receive(3000L));
                }
                QueueControl testQueueControlAfterCrash = (QueueControl)this.getServer(serverIdAfterCrash).getManagementService().getResource("queue.queue0");
                Wait.waitFor(() -> testQueueControlAfterCrash.getMessageCount() == 0L, (long)3000L);
                clientSession.stop();
            }
        }
    }

    @Test
    public void testConsumerAfterFailoverWithRedistribution() throws Exception {
        this.setupCluster();
        AddressSettings testAddressSettings = new AddressSettings().setRedistributionDelay(0L);
        for (int i : this.getServerIDs()) {
            this.getServer(i).getAddressSettingsRepository().addMatch("queues.testaddress", (Object)testAddressSettings);
        }
        this.startServers(this.getPrimaryServerIDs());
        this.startServers(this.getBackupServerIDs());
        for (int i : this.getPrimaryServerIDs()) {
            ClientConnectorFailoverTest.waitForTopology(this.servers[i], 3, 3);
        }
        for (int i : this.getBackupServerIDs()) {
            this.waitForFailoverTopology(i, 0, 1, 2);
        }
        for (int i : this.getPrimaryServerIDs()) {
            this.setupSessionFactory(i, i + 3, this.isNetty(), false);
            this.createQueue(i, "queues.testaddress", "queue0", null, true);
        }
        ArrayList<TransportConfiguration> transportConfigList = new ArrayList<TransportConfiguration>();
        for (int i : this.getPrimaryServerIDs()) {
            Map<String, Object> params = ClientConnectorFailoverTest.generateParams(i, this.isNetty());
            TransportConfiguration serverToTC = ClientConnectorFailoverTest.createTransportConfiguration("node" + i, this.isNetty(), false, params);
            serverToTC.getExtraParams().put(TEST_PARAM, TEST_PARAM);
            transportConfigList.add(serverToTC);
        }
        TransportConfiguration[] transportConfigs = transportConfigList.toArray(new TransportConfiguration[transportConfigList.size()]);
        try (ServerLocatorImpl serverLocator = new ServerLocatorImpl(false, transportConfigs);){
            serverLocator.setFailoverAttempts(3);
            serverLocator.setReconnectAttempts(0);
            serverLocator.setUseTopologyForLoadBalancing(false);
            try (ClientSessionFactory sessionFactory = serverLocator.createSessionFactory();
                 ClientSession clientSession = sessionFactory.createSession();){
                clientSession.start();
                int serverIdBeforeCrash = Integer.parseInt(sessionFactory.getConnectorConfiguration().getName().substring(4));
                QueueControl testQueueControlBeforeCrash = (QueueControl)this.getServer(serverIdBeforeCrash).getManagementService().getResource("queue.queue0");
                Assertions.assertEquals((long)0L, (long)testQueueControlBeforeCrash.getMessageCount());
                try (ClientProducer clientProducer = clientSession.createProducer("queues.testaddress");){
                    clientProducer.send((org.apache.activemq.artemis.api.core.Message)clientSession.createMessage(true));
                    clientProducer.send((org.apache.activemq.artemis.api.core.Message)clientSession.createMessage(true));
                }
                Assertions.assertEquals((long)2L, (long)testQueueControlBeforeCrash.getMessageCount());
                try (ClientConsumer clientConsumer = clientSession.createConsumer("queue0");){
                    ClientMessage messageBeforeCrash = clientConsumer.receive(3000L);
                    Assertions.assertNotNull((Object)messageBeforeCrash);
                    messageBeforeCrash.acknowledge();
                    clientSession.commit();
                    Assertions.assertEquals((long)1L, (long)testQueueControlBeforeCrash.getMessageCount());
                    ClientConnectorFailoverTest.crashAndWaitForFailure(this.getServer(serverIdBeforeCrash), clientSession);
                    Assertions.assertEquals((Object)TEST_PARAM, sessionFactory.getConnectorConfiguration().getExtraParams().get(TEST_PARAM));
                    int serverIdAfterCrash = Integer.parseInt(sessionFactory.getConnectorConfiguration().getName().substring(4));
                    Assertions.assertNotEquals((int)serverIdBeforeCrash, (int)serverIdAfterCrash);
                    Assertions.assertTrue((boolean)this.isPrimaryServerID(serverIdAfterCrash));
                    QueueControl testQueueControlAfterCrash = (QueueControl)this.getServer(serverIdAfterCrash).getManagementService().getResource("queue.queue0");
                    Wait.waitFor(() -> testQueueControlAfterCrash.getMessageCount() == 1L, (long)3000L);
                    Assertions.assertNotNull((Object)clientConsumer.receive());
                }
                clientSession.stop();
            }
        }
    }

    @Test
    public void testAutoCreatedQueueAfterFailoverWithoutHA() throws Exception {
        this.setupCluster();
        this.startServers(this.getPrimaryServerIDs());
        for (int i : this.getPrimaryServerIDs()) {
            ClientConnectorFailoverTest.waitForTopology(this.servers[i], 3, 0);
        }
        for (int i : this.getPrimaryServerIDs()) {
            this.setupSessionFactory(i, i + 3, this.isNetty(), false);
        }
        ArrayList<TransportConfiguration> transportConfigList = new ArrayList<TransportConfiguration>();
        for (int i : this.getPrimaryServerIDs()) {
            Map<String, Object> params = ClientConnectorFailoverTest.generateParams(i, this.isNetty());
            TransportConfiguration serverToTC = ClientConnectorFailoverTest.createTransportConfiguration("node" + i, this.isNetty(), false, params);
            serverToTC.getExtraParams().put(TEST_PARAM, TEST_PARAM);
            transportConfigList.add(serverToTC);
        }
        TransportConfiguration[] transportConfigs = transportConfigList.toArray(new TransportConfiguration[transportConfigList.size()]);
        try (ServerLocatorImpl serverLocator = new ServerLocatorImpl(false, transportConfigs);){
            serverLocator.setFailoverAttempts(3);
            serverLocator.setReconnectAttempts(0);
            serverLocator.setUseTopologyForLoadBalancing(false);
            try (ClientSessionFactory sessionFactory = serverLocator.createSessionFactory();
                 ClientSession clientSession = sessionFactory.createSession();){
                clientSession.start();
                TransportConfiguration backupConnector = (TransportConfiguration)((ClientSessionFactoryImpl)sessionFactory).getBackupConnector();
                Assertions.assertNull((Object)backupConnector);
                int serverIdBeforeCrash = Integer.parseInt(sessionFactory.getConnectorConfiguration().getName().substring(4));
                this.createQueue(serverIdBeforeCrash, "queues.testaddress", "queue0", null, false);
                QueueControl testQueueControlBeforeCrash = (QueueControl)this.getServer(serverIdBeforeCrash).getManagementService().getResource("queue.queue0");
                Assertions.assertEquals((long)0L, (long)testQueueControlBeforeCrash.getMessageCount());
                for (int i : this.getPrimaryServerIDs()) {
                    if (i == serverIdBeforeCrash) continue;
                    Assertions.assertNull((Object)this.getServer(i).getManagementService().getResource("queue.queue0"));
                }
                try (ClientConsumer clientConsumer = clientSession.createConsumer("queue0");){
                    try (ClientProducer clientProducer = clientSession.createProducer("queues.testaddress");){
                        clientProducer.send((org.apache.activemq.artemis.api.core.Message)clientSession.createMessage(true));
                    }
                    Wait.waitFor(() -> testQueueControlBeforeCrash.getMessageCount() == 1L, (long)3000L);
                    Assertions.assertNotNull((Object)clientConsumer.receive(3000L));
                    ClientConnectorFailoverTest.crashAndWaitForFailure(this.getServer(serverIdBeforeCrash), clientSession);
                    Assertions.assertEquals((Object)TEST_PARAM, sessionFactory.getConnectorConfiguration().getExtraParams().get(TEST_PARAM));
                    int serverIdAfterCrash = Integer.parseInt(sessionFactory.getConnectorConfiguration().getName().substring(4));
                    Assertions.assertNotEquals((int)serverIdBeforeCrash, (int)serverIdAfterCrash);
                    boolean serverIdAfterCrashFound = false;
                    for (int i : this.getPrimaryServerIDs()) {
                        if (i != serverIdAfterCrash) continue;
                        serverIdAfterCrashFound = true;
                    }
                    Assertions.assertTrue((boolean)serverIdAfterCrashFound);
                    QueueControl testQueueControlAfterCrash = (QueueControl)this.getServer(serverIdAfterCrash).getManagementService().getResource("queue.queue0");
                    Assertions.assertNotNull((Object)testQueueControlAfterCrash);
                    Assertions.assertEquals((long)0L, (long)testQueueControlAfterCrash.getMessageCount());
                    try (ClientProducer clientProducer = clientSession.createProducer("queues.testaddress");){
                        clientProducer.send((org.apache.activemq.artemis.api.core.Message)clientSession.createMessage(true));
                        Wait.waitFor(() -> testQueueControlAfterCrash.getMessageCount() == 1L, (long)3000L);
                        Assertions.assertEquals((long)1L, (long)testQueueControlAfterCrash.getMessageCount());
                        Assertions.assertNotNull((Object)clientConsumer.receive(3000L));
                    }
                    clientSession.stop();
                }
            }
        }
    }

    @Test
    public void testJMSConsumerAfterFailover() throws Exception {
        this.setupCluster();
        this.startServers(this.getPrimaryServerIDs());
        this.startServers(this.getBackupServerIDs());
        for (int i : this.getPrimaryServerIDs()) {
            ClientConnectorFailoverTest.waitForTopology(this.servers[i], 3, 3);
        }
        for (int i : this.getBackupServerIDs()) {
            this.waitForFailoverTopology(i, 0, 1, 2);
        }
        StringBuilder connectionURL = new StringBuilder();
        connectionURL.append("(");
        for (int i : this.getServerIDs()) {
            connectionURL.append("tcp://localhost:");
            connectionURL.append(61616 + i);
            connectionURL.append("?name=node");
            connectionURL.append(i);
            connectionURL.append("&");
            connectionURL.append(TEST_PARAM);
            connectionURL.append("=");
            connectionURL.append(TEST_PARAM);
            connectionURL.append(",");
        }
        connectionURL.replace(connectionURL.length() - 1, connectionURL.length(), ")");
        connectionURL.append("?ha=true&reconnectAttempts=-1");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectionURL.toString());
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
            try (Session session = connection.createSession();){
                ClientSessionFactory sessionFactory = ((ActiveMQConnection)connection).getSessionFactory();
                TransportConfiguration backupConnector = (TransportConfiguration)((ClientSessionFactoryImpl)sessionFactory).getBackupConnector();
                Assertions.assertNotEquals((Object)backupConnector.getName(), (Object)sessionFactory.getConnectorConfiguration().getName());
                int serverIdBeforeCrash = Integer.parseInt(sessionFactory.getConnectorConfiguration().getName().substring(4));
                Queue testQueue = session.createQueue("queue0");
                try (MessageProducer producer = session.createProducer((Destination)testQueue);){
                    producer.send((Message)session.createTextMessage(TEST_PARAM));
                }
                ClientSession clientSession = ((ActiveMQSession)session).getCoreSession();
                ClientConnectorFailoverTest.crashAndWaitForFailure(this.getServer(serverIdBeforeCrash), clientSession);
                Assertions.assertEquals((Object)backupConnector.getName(), (Object)sessionFactory.getConnectorConfiguration().getName());
                Assertions.assertEquals((Object)TEST_PARAM, sessionFactory.getConnectorConfiguration().getExtraParams().get(TEST_PARAM));
                int serverIdAfterCrash = Integer.parseInt(sessionFactory.getConnectorConfiguration().getName().substring(4));
                Assertions.assertNotEquals((int)serverIdBeforeCrash, (int)serverIdAfterCrash);
                try (MessageConsumer messageConsumer = session.createConsumer((Destination)testQueue);){
                    Assertions.assertNotNull((Object)messageConsumer.receive(3000L));
                }
                QueueControl testQueueControlAfterCrash = (QueueControl)this.getServer(serverIdAfterCrash).getManagementService().getResource("queue.queue0");
                Wait.waitFor(() -> testQueueControlAfterCrash.getMessageCount() == 0L, (long)3000L);
            }
            connection.stop();
        }
    }
}

