/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.impl.ReplicationBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class GroupingFailoverTestBase
extends ClusterTestBase {
    @Test
    public void testGroupingLocalHandlerFails() throws Exception {
        this.setupBackupServer(2, 0, this.isFileStorage(), this.haType(), this.isNetty());
        this.setupPrimaryServer(0, this.isFileStorage(), this.haType(), this.isNetty(), false);
        this.setupPrimaryServer(1, this.isFileStorage(), this.haType(), this.isNetty(), false);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 2);
        switch (this.haType()) {
            case SharedNothingReplication: {
                ((ReplicatedPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
                ((ReplicatedPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
                ((ReplicaPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
                break;
            }
            case PluggableQuorumReplication: {
                ((ReplicationPrimaryPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
                ((ReplicationPrimaryPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
                ((ReplicationBackupPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
            }
        }
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        GroupingFailoverTestBase.waitForTopology(this.servers[1], 2, 1);
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 0);
        if (!this.isSharedStore()) {
            this.waitForBackupTopologyAnnouncement(this.sfs[0]);
        }
        Thread.sleep(1000L);
        this.closeSessionFactory(0);
        this.servers[0].fail(true);
        this.waitForServerRestart(2);
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 2);
    }

    public void waitForBackupTopologyAnnouncement(ClientSessionFactory sf) throws Exception {
        long start = System.currentTimeMillis();
        ServerLocator locator = sf.getServerLocator();
        do {
            Collection members = locator.getTopology().getMembers();
            for (TopologyMemberImpl member : members) {
                if (member.getBackup() == null) continue;
                return;
            }
            Thread.sleep(10L);
        } while (System.currentTimeMillis() - start < 30000L);
        throw new IllegalStateException("Timed out waiting for backup announce");
    }

    @Test
    public void testGroupingLocalHandlerFailsMultipleGroups() throws Exception {
        this.setupBackupServer(2, 0, this.isFileStorage(), this.haType(), this.isNetty());
        this.setupPrimaryServer(0, this.isFileStorage(), this.haType(), this.isNetty(), false);
        this.setupPrimaryServer(1, this.isFileStorage(), this.haType(), this.isNetty(), false);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 2);
        switch (this.haType()) {
            case SharedNothingReplication: {
                ((ReplicatedPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
                ((ReplicatedPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
                ((ReplicaPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
                break;
            }
            case PluggableQuorumReplication: {
                ((ReplicationPrimaryPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
                ((ReplicationPrimaryPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
                ((ReplicationBackupPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
            }
        }
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        GroupingFailoverTestBase.waitForTopology(this.servers[1], 2);
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id4"));
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id5"));
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id6"));
        this.verifyReceiveAllWithGroupIDRoundRobin(0, 30, 0, 1);
        switch (this.haType()) {
            case SharedNothingReplication: {
                SharedNothingBackupActivation backupActivation = (SharedNothingBackupActivation)this.servers[2].getActivation();
                Assertions.assertTrue((boolean)backupActivation.waitForBackupSync(10L, TimeUnit.SECONDS));
                break;
            }
            case PluggableQuorumReplication: {
                ReplicationBackupActivation backupActivation = (ReplicationBackupActivation)this.servers[2].getActivation();
                Wait.assertTrue(() -> ((ReplicationBackupActivation)backupActivation).isReplicaSync(), (long)TimeUnit.SECONDS.toMillis(10L));
            }
        }
        this.closeSessionFactory(0);
        this.servers[0].fail(true);
        this.waitForServerRestart(2);
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id4"));
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id5"));
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id6"));
        this.verifyReceiveAllWithGroupIDRoundRobin(2, 30, 1, 2);
    }

    public boolean isNetty() {
        return true;
    }
}

