/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedDistributionTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final SimpleString ADDRESS = SimpleString.of((String)"test.SomeAddress");
    private ClientSession sessionOne;
    private ClientSession sessionThree;
    private ClientConsumer consThree;
    private ClientProducer producer;

    @Test
    public void testRedistribution() throws Exception {
        int received;
        ClientMessage msg;
        int i;
        this.commonTestCode();
        for (i = 0; i < 50; ++i) {
            msg = this.consThree.receive(15000L);
            Assertions.assertNotNull((Object)msg);
            received = msg.getIntProperty("key");
            Assertions.assertEquals((int)i, (int)received);
            msg.acknowledge();
        }
        this.sessionThree.commit();
        Thread.sleep(500L);
        this.fail(this.sessionThree);
        for (i = 50; i < 100; ++i) {
            msg = this.consThree.receive(15000L);
            Assertions.assertNotNull((Object)msg);
            received = (Integer)msg.getObjectProperty(SimpleString.of((String)"key"));
            Assertions.assertEquals((int)i, (int)received);
            msg.acknowledge();
        }
        Assertions.assertNull((Object)this.consThree.receiveImmediate());
        this.sessionThree.commit();
        this.sessionOne.start();
        ClientConsumer consOne = this.sessionOne.createConsumer(ADDRESS);
        Assertions.assertNull((Object)consOne.receiveImmediate());
    }

    @Test
    public void testSimpleRedistribution() throws Exception {
        this.commonTestCode();
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.consThree.receive(15000L);
            Assertions.assertNotNull((Object)msg);
            logger.trace("i msg = {}", (Object)i, (Object)msg);
            int received = msg.getIntProperty("key");
            if (i != received) {
                logger.warn("{}!={}", (Object)i, (Object)received);
            }
            msg.acknowledge();
        }
        this.sessionThree.commit();
        this.sessionOne.start();
        ClientConsumer consOne = this.sessionOne.createConsumer(ADDRESS);
        Assertions.assertNull((Object)consOne.receiveImmediate());
    }

    private void commonTestCode() throws Exception {
        this.waitForBindings(3, "test.SomeAddress", 1, 1, true);
        this.waitForBindings(1, "test.SomeAddress", 1, 1, false);
        this.producer = this.sessionOne.createProducer(ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.sessionOne.createMessage(true);
            msg.putIntProperty(SimpleString.of((String)"key"), i);
            this.producer.send((Message)msg);
        }
        this.sessionOne.commit();
    }

    private void fail(ClientSession session) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        session.addFailureListener((SessionFailureListener)new CountDownSessionFailureListener(latch, session));
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        boolean ok = latch.await(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)ok);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupPrimaryServer(1, true, this.haType(), true, false);
        this.setupPrimaryServer(3, true, this.haType(), true, false);
        this.setupBackupServer(2, 3, true, this.haType(), true);
        String address = ADDRESS.toString();
        this.setupClusterConnectionWithBackups("test", address, MessageLoadBalancingType.ON_DEMAND, 1, true, 1, new int[]{3});
        this.setupClusterConnectionWithBackups("test", address, MessageLoadBalancingType.ON_DEMAND, 1, true, 3, new int[]{2, 1});
        this.setupClusterConnectionWithBackups("test", address, MessageLoadBalancingType.ON_DEMAND, 1, true, 2, new int[]{3});
        AddressSettings as = new AddressSettings().setRedistributionDelay(0L);
        for (int i : new int[]{1, 2, 3}) {
            this.getServer(i).getAddressSettingsRepository().addMatch("test.*", (Object)as);
            this.getServer(i).start();
        }
        this.setupSessionFactory(1, -1, true, true);
        this.setupSessionFactory(3, 2, true, true);
        this.sessionOne = this.sfs[1].createSession(true, true);
        this.sessionThree = this.sfs[3].createSession(false, false);
        this.sessionOne.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        this.sessionThree.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        this.consThree = this.sessionThree.createConsumer(ADDRESS);
        this.sessionThree.start();
    }

    @Override
    protected ClusterTestBase.HAType haType() {
        return ClusterTestBase.HAType.SharedNothingReplication;
    }
}

