/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpoint;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SimpleJNDIClientTest
extends ActiveMQTestBase {
    private final String groupAddress = SimpleJNDIClientTest.getUDPDiscoveryAddress();
    private final int groupPort = SimpleJNDIClientTest.getUDPDiscoveryPort();
    private ActiveMQServer liveService;
    private TransportConfiguration liveTC;
    private List<ActiveMQConnectionFactory> factories = new LinkedList<ActiveMQConnectionFactory>();

    private void addCF(ConnectionFactory factory) {
        if (factory instanceof ActiveMQConnectionFactory) {
            this.factories.add((ActiveMQConnectionFactory)factory);
        }
    }

    @AfterEach
    public void closeCFs() {
        this.factories.forEach(cf -> cf.close());
    }

    @Test
    public void testMultipleConnectionFactories() throws NamingException, JMSException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.VmConnectionFactory", "vm://0");
        props.put("connectionFactory.TCPConnectionFactory", "tcp://localhost:61616");
        props.put("connectionFactory.UDPConnectionFactory", "udp://" + SimpleJNDIClientTest.getUDPDiscoveryAddress() + ":" + SimpleJNDIClientTest.getUDPDiscoveryPort());
        props.put("connectionFactory.JGroupsConnectionFactory", "jgroups://mychannelid?file=test-jgroups-file_ping.xml");
        InitialContext ctx = new InitialContext(props);
        ctx.lookup("VmConnectionFactory");
        ctx.lookup("TCPConnectionFactory");
        ctx.lookup("UDPConnectionFactory");
        ctx.lookup("JGroupsConnectionFactory");
        ctx.close();
    }

    @Test
    public void testVMCF0() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        connectionFactory.createConnection().close();
        ctx.close();
    }

    @Test
    public void testEmptyConnectionFactoryString() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0");
        props.put("java.naming.provider.url", "");
        InitialContext ctx = new InitialContext(props);
        ctx.close();
    }

    @Test
    public void testVMCF1() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://1");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        connectionFactory.createConnection().close();
    }

    @Test
    public void testXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=XA_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assertions.assertEquals((int)JMSFactoryType.XA_CF.intValue(), (int)connectionFactory.getFactoryType());
    }

    @Test
    public void testQueueCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=QUEUE_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assertions.assertEquals((int)JMSFactoryType.QUEUE_CF.intValue(), (int)connectionFactory.getFactoryType());
    }

    @Test
    public void testQueueXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=QUEUE_XA_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assertions.assertEquals((int)JMSFactoryType.QUEUE_XA_CF.intValue(), (int)connectionFactory.getFactoryType());
    }

    @Test
    public void testTopicCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=TOPIC_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assertions.assertEquals((int)JMSFactoryType.TOPIC_CF.intValue(), (int)connectionFactory.getFactoryType());
    }

    @Test
    public void testTopicXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "vm://0?type=TOPIC_XA_CF");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assertions.assertEquals((int)JMSFactoryType.TOPIC_XA_CF.intValue(), (int)connectionFactory.getFactoryType());
    }

    @Test
    public void testRemoteCFWithTCP() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("myConnectionFactory");
        connectionFactory.createConnection().close();
    }

    @Test
    public void testRemoteCFWithTCPandHA() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616?ha=true");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assertions.assertTrue((boolean)cf.isHA());
    }

    @Test
    public void testRemoteCFWithJGroups() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "jgroups://mychannelid?file=test-jgroups-file_ping.xml");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        connectionFactory.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory().createBroadcastEndpoint().close(false);
    }

    @Test
    public void testRemoteCFWithJgroupsWithTransportConfigFile() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", ActiveMQInitialContextFactory.class.getCanonicalName());
        props.put("connectionFactory.myConnectionFactory", "jgroups://testChannelName?file=test-jgroups-file_ping.xml&refreshTimeout=5000&discoveryInitialWaitTimeout=6000");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        DiscoveryGroupConfiguration discoveryGroupConfiguration = cf.getDiscoveryGroupConfiguration();
        Assertions.assertEquals((long)5000L, (long)discoveryGroupConfiguration.getRefreshTimeout());
        Assertions.assertEquals((long)6000L, (long)discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout());
        BroadcastEndpoint broadcastEndpoint = cf.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory().createBroadcastEndpoint();
        Assertions.assertTrue((boolean)(broadcastEndpoint instanceof JGroupsFileBroadcastEndpoint));
        broadcastEndpoint.close(false);
    }

    @Test
    public void testRemoteCFWithUDP() throws NamingException, JMSException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "udp://" + SimpleJNDIClientTest.getUDPDiscoveryAddress() + ":" + SimpleJNDIClientTest.getUDPDiscoveryPort());
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("myConnectionFactory");
        this.addCF(connectionFactory);
        connectionFactory.createConnection().close();
        ctx.close();
    }

    @Test
    public void testRemoteCFWithUDPWithTransportConfig() throws NamingException, JMSException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("java.naming.factory.initial", ActiveMQInitialContextFactory.class.getCanonicalName());
        props.put("connectionFactory.myConnectionFactory", "udp://" + SimpleJNDIClientTest.getUDPDiscoveryAddress() + ":" + SimpleJNDIClientTest.getUDPDiscoveryPort() + "?localAddress=Server1&localPort=1198&refreshTimeout=5000&discoveryInitialWaitTimeout=6000");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        this.addCF((ConnectionFactory)cf);
        DiscoveryGroupConfiguration discoveryGroupConfiguration = cf.getDiscoveryGroupConfiguration();
        Assertions.assertEquals((long)5000L, (long)discoveryGroupConfiguration.getRefreshTimeout());
        Assertions.assertEquals((long)6000L, (long)discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout());
        UDPBroadcastEndpointFactory udpBroadcastEndpointFactory = (UDPBroadcastEndpointFactory)discoveryGroupConfiguration.getBroadcastEndpointFactory();
        Assertions.assertNotEquals((Object)"Server1", (Object)udpBroadcastEndpointFactory.getLocalBindAddress());
        Assertions.assertNotEquals((int)1198, (int)udpBroadcastEndpointFactory.getLocalBindPort());
        Assertions.assertEquals((Object)SimpleJNDIClientTest.getUDPDiscoveryAddress(), (Object)udpBroadcastEndpointFactory.getGroupAddress());
        Assertions.assertEquals((int)SimpleJNDIClientTest.getUDPDiscoveryPort(), (int)udpBroadcastEndpointFactory.getGroupPort());
        ctx.close();
    }

    @Test
    public void testRemoteCFWithMultipleHosts() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616/httpEnabled=true&foo=bar,tcp://127.0.0.2:61617?httpEnabled=false?clientID=myClientID");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("myConnectionFactory");
        connectionFactory.createConnection().close();
        ctx.close();
    }

    @Test
    public void testRemoteCFWithTransportConfig() throws NamingException, JMSException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616?sslEnabled=mySSLEnabledPropValue&httpEnabled=myHTTPEnabledPropValue&httpClientIdleTime=myHTTPClientIdlePropValue&httpClientIdleScanPeriod=myHTTPClientIdleScanPeriodValue&httpRequiresSessionId=myHTTPRequiresSessionIDValue&httpUpgradeEnabled=myHTTPUpgradeEnabledPropValue&httpUpgradeEndpoint=myHTTPUpgradeEndpointPropValue&useServlet=myUseServletPropValue&servletPath=myServletPathValue&useNio=myUseNIOPropValue&useNioGlobalWorkerPool=myUseNIOGlobalWorkerPoolPropValue&localAddress=myLocalAddressPropValue&localPort=myLocalPortPropValue&keyStoreProvider=myKeystoreProviderPropValue&keyStoreType=myKeystoreTypePropValue&keyStorePath=myKeystorePathPropValue&keyStorePassword=myKeystorePasswordPropValue&trustStoreProvider=myTruststoreProviderPropValue&trustStoreType=myTruststoreTypePropValue&trustStorePath=myTruststorePathPropValue&trustStorePassword=myTruststorePasswordPropValue&enabledCipherSuites=myEnabledCipherSuitesPropValue&enabledProtocols=myEnabledProtocolsPropValue&tcpNoDelay=myTCPNoDelayPropValue&tcpSendBufferSize=myTCPSendbufferSizePropValue&tcpReceiveBufferSize=myTCPReceivebufferSizePropValue&nioRemotingThreads=myNIORemotingThreadsPropValue&batchDelay=myBatchDelay&" + ActiveMQDefaultConfiguration.getPropMaskPassword() + "=myPropMaskPassword&" + ActiveMQDefaultConfiguration.getPropPasswordCodec() + "=myPropPasswordCodec&connect-timeout-millis=myNettyConnectTimeout&");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Map parametersFromJNDI = cf.getServerLocator().getStaticTransportConfigurations()[0].getParams();
        Assertions.assertEquals(parametersFromJNDI.get("sslEnabled"), (Object)"mySSLEnabledPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("httpEnabled"), (Object)"myHTTPEnabledPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("httpClientIdleTime"), (Object)"myHTTPClientIdlePropValue");
        Assertions.assertEquals(parametersFromJNDI.get("httpClientIdleScanPeriod"), (Object)"myHTTPClientIdleScanPeriodValue");
        Assertions.assertEquals(parametersFromJNDI.get("httpRequiresSessionId"), (Object)"myHTTPRequiresSessionIDValue");
        Assertions.assertEquals(parametersFromJNDI.get("httpUpgradeEnabled"), (Object)"myHTTPUpgradeEnabledPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("httpUpgradeEndpoint"), (Object)"myHTTPUpgradeEndpointPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("useServlet"), (Object)"myUseServletPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("servletPath"), (Object)"myServletPathValue");
        Assertions.assertEquals(parametersFromJNDI.get("useNio"), (Object)"myUseNIOPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("useNioGlobalWorkerPool"), (Object)"myUseNIOGlobalWorkerPoolPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("localAddress"), (Object)"myLocalAddressPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("localPort"), (Object)"myLocalPortPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("keyStoreProvider"), (Object)"myKeystoreProviderPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("keyStoreType"), (Object)"myKeystoreTypePropValue");
        Assertions.assertEquals(parametersFromJNDI.get("keyStorePath"), (Object)"myKeystorePathPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("keyStorePassword"), (Object)"myKeystorePasswordPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("trustStoreProvider"), (Object)"myTruststoreProviderPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("trustStoreType"), (Object)"myTruststoreTypePropValue");
        Assertions.assertEquals(parametersFromJNDI.get("trustStorePath"), (Object)"myTruststorePathPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("trustStorePassword"), (Object)"myTruststorePasswordPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("enabledCipherSuites"), (Object)"myEnabledCipherSuitesPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("enabledProtocols"), (Object)"myEnabledProtocolsPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("tcpNoDelay"), (Object)"myTCPNoDelayPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("tcpSendBufferSize"), (Object)"myTCPSendbufferSizePropValue");
        Assertions.assertEquals(parametersFromJNDI.get("tcpReceiveBufferSize"), (Object)"myTCPReceivebufferSizePropValue");
        Assertions.assertEquals(parametersFromJNDI.get("nioRemotingThreads"), (Object)"myNIORemotingThreadsPropValue");
        Assertions.assertEquals(parametersFromJNDI.get("batchDelay"), (Object)"myBatchDelay");
        Assertions.assertEquals(parametersFromJNDI.get(ActiveMQDefaultConfiguration.getPropMaskPassword()), (Object)"myPropMaskPassword");
        Assertions.assertEquals(parametersFromJNDI.get(ActiveMQDefaultConfiguration.getPropPasswordCodec()), (Object)"myPropPasswordCodec");
        Assertions.assertEquals(parametersFromJNDI.get("connect-timeout-millis"), (Object)"myNettyConnectTimeout");
        ctx.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startServer();
    }

    private void startServer() throws Exception {
        this.liveTC = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        connectors.put(this.liveTC.getName(), this.liveTC);
        ArrayList<String> connectorNames = new ArrayList<String>();
        connectorNames.add(this.liveTC.getName());
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("serverId", 1);
        ConfigurationImpl primaryConf = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY)).addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY, params)).addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY)).setConnectorConfigurations(connectors).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).setSecurityEnabled(true);
        long broadcastPeriod = 250L;
        String bcGroupName = "bc1";
        int localBindPort = 5432;
        BroadcastGroupConfiguration bcConfig1 = new BroadcastGroupConfiguration().setName("bc1").setBroadcastPeriod(250L).setConnectorInfos(connectorNames).setEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort).setLocalBindPort(5432));
        ArrayList<BroadcastGroupConfiguration> bcConfigs1 = new ArrayList<BroadcastGroupConfiguration>();
        bcConfigs1.add(bcConfig1);
        primaryConf.setBroadcastGroupConfigurations(bcConfigs1);
        this.liveService = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConf, (boolean)false));
        ((ActiveMQJAASSecurityManager)this.liveService.getSecurityManager()).getConfiguration().addUser("guest", "guest");
        ((ActiveMQJAASSecurityManager)this.liveService.getSecurityManager()).getConfiguration().setDefaultUser("guest");
        this.liveService.start();
    }

    @Test
    public void testQueue() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("queue.myQueue", "myQueue");
        props.put("queue.queues/myQueue", "myQueue");
        InitialContext ctx = new InitialContext(props);
        Destination destination = (Destination)ctx.lookup("myQueue");
        Assertions.assertTrue((boolean)(destination instanceof Queue));
        destination = (Destination)ctx.lookup("queues/myQueue");
        Assertions.assertTrue((boolean)(destination instanceof Queue));
    }

    @Test
    public void testQueueFQQN() throws Exception {
        String QUEUE = "myQueue";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("queue.myQueue", "myAddress::myQueue");
        InitialContext ctx = new InitialContext(props);
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Destination destination = (Destination)ctx.lookup("myQueue");
        Assertions.assertTrue((boolean)(destination instanceof Queue));
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession();
            MessageProducer producer = session.createProducer(destination);
            producer.send(session.createMessage());
            Wait.assertTrue(() -> this.liveService.locateQueue("myQueue").getMessageCount() == 1L, (long)2000L, (long)100L);
            MessageConsumer consumer = session.createConsumer(destination);
            connection.start();
            Assertions.assertNotNull((Object)consumer.receiveNoWait());
        }
    }

    @Test
    public void testDynamicQueue() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        InitialContext ctx = new InitialContext(props);
        Destination destination = (Destination)ctx.lookup("dynamicQueues/myQueue");
        Assertions.assertTrue((boolean)(destination instanceof Queue));
    }

    @Test
    public void testDynamicQueueFQQN() throws Exception {
        String QUEUE = "myQueue";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        InitialContext ctx = new InitialContext(props);
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Destination destination = (Destination)ctx.lookup("dynamicQueues/myAddress::myQueue");
        Assertions.assertTrue((boolean)(destination instanceof Queue));
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession();
            MessageProducer producer = session.createProducer(destination);
            producer.send(session.createMessage());
            Wait.assertTrue(() -> this.liveService.locateQueue("myQueue").getMessageCount() == 1L, (long)2000L, (long)100L);
            MessageConsumer consumer = session.createConsumer(destination);
            connection.start();
            Assertions.assertNotNull((Object)consumer.receiveNoWait());
        }
    }

    @Test
    public void testTopic() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("topic.myTopic", "myTopic");
        props.put("topic.topics/myTopic", "myTopic");
        InitialContext ctx = new InitialContext(props);
        Destination destination = (Destination)ctx.lookup("myTopic");
        Assertions.assertTrue((boolean)(destination instanceof Topic));
        destination = (Destination)ctx.lookup("topics/myTopic");
        Assertions.assertTrue((boolean)(destination instanceof Topic));
    }

    @Test
    public void testTopicFQQN() throws Exception {
        String SUBSCRIPTION = "mySubsription";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("topic.myTopic", "myTopic::mySubsription");
        InitialContext ctx = new InitialContext(props);
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Destination destination = (Destination)ctx.lookup("myTopic");
        Assertions.assertTrue((boolean)(destination instanceof Topic));
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        MessageProducer producer = session.createProducer(destination);
        producer.send(session.createMessage());
        Wait.assertTrue(() -> this.liveService.locateQueue("mySubsription").getMessageCount() == 1L, (long)2000L, (long)100L);
        MessageConsumer consumer = session.createConsumer(destination);
        connection.start();
        Assertions.assertNotNull((Object)consumer.receiveNoWait());
    }

    @Test
    public void testDynamicTopic() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        InitialContext ctx = new InitialContext(props);
        Destination destination = (Destination)ctx.lookup("dynamicTopics/myTopic");
        Assertions.assertTrue((boolean)(destination instanceof Topic));
    }

    @Test
    public void testDynamicTopicFQQN() throws Exception {
        String SUBSCRIPTION = "mySubsription";
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("topic.myTopic", "myTopic::mySubsription");
        InitialContext ctx = new InitialContext(props);
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Destination destination = (Destination)ctx.lookup("dynamicTopics/myTopic::mySubsription");
        Assertions.assertTrue((boolean)(destination instanceof Topic));
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        MessageProducer producer = session.createProducer(destination);
        producer.send(session.createMessage());
        Wait.assertTrue(() -> this.liveService.locateQueue("mySubsription").getMessageCount() == 1L, (long)2000L, (long)100L);
        MessageConsumer consumer = session.createConsumer(destination);
        connection.start();
        Assertions.assertNotNull((Object)consumer.receiveNoWait());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteCFWithTCPUserPassword() throws Exception {
        ((ActiveMQJAASSecurityManager)this.liveService.getSecurityManager()).getConfiguration().addUser("myUser", "myPassword");
        ((ActiveMQJAASSecurityManager)this.liveService.getSecurityManager()).getConfiguration().addRole("myUser", "consumeCreateRole");
        Role consumeCreateRole = new Role("consumeCreateRole", false, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> consumerCreateRoles = new HashSet<Role>();
        consumerCreateRoles.add(consumeCreateRole);
        this.liveService.getSecurityRepository().addMatch("test.queue", consumerCreateRoles);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.myConnectionFactory", "tcp://127.0.0.1:61616?user=myUser&password=myPassword");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup("myConnectionFactory");
        Assertions.assertEquals((Object)"myUser", (Object)connectionFactory.getUser(), (String)"ensure user is set");
        Assertions.assertEquals((Object)"myPassword", (Object)connectionFactory.getPassword(), (String)"ensure password is set");
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test.queue");
        try {
            try {
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("test Msg"));
                Assertions.fail((String)"Sending message should throw a JMSSecurityException");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        }
        finally {
            connection.close();
        }
    }

    public void testContext(Context ctx, String jndiName, JMSFactoryType expectedFactoryType) {
        try {
            ActiveMQConnectionFactory connectionFactory = (ActiveMQConnectionFactory)ctx.lookup(jndiName);
            if (expectedFactoryType == null) {
                Assertions.fail((String)"expected no factory, should have thrown NamingException");
            } else {
                Assertions.assertEquals((int)expectedFactoryType.intValue(), (int)connectionFactory.getFactoryType());
            }
        }
        catch (NamingException namingException) {
            Assertions.assertNull((Object)expectedFactoryType, (String)"NamingException should only occur when no ExpectedFactoryType, but one existed");
        }
    }

    @Test
    public void testProviderUrlDefault() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", JMSFactoryType.CF);
        this.testContext(ctx, "QueueConnectionFactory", JMSFactoryType.QUEUE_CF);
        this.testContext(ctx, "TopicConnectionFactory", JMSFactoryType.TOPIC_CF);
        this.testContext(ctx, "XAConnectionFactory", JMSFactoryType.XA_CF);
        this.testContext(ctx, "XAQueueConnectionFactory", JMSFactoryType.QUEUE_XA_CF);
        this.testContext(ctx, "XATopicConnectionFactory", JMSFactoryType.TOPIC_XA_CF);
    }

    @Test
    public void testProviderUrlCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", JMSFactoryType.CF);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=XA_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", JMSFactoryType.XA_CF);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlQueueCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=QUEUE_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", JMSFactoryType.QUEUE_CF);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlQueueXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=QUEUE_XA_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", JMSFactoryType.QUEUE_XA_CF);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlTopicCF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=TOPIC_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", JMSFactoryType.TOPIC_CF);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", null);
    }

    @Test
    public void testProviderUrlTopicXACF() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0?type=TOPIC_XA_CF");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", null);
        this.testContext(ctx, "QueueConnectionFactory", null);
        this.testContext(ctx, "TopicConnectionFactory", null);
        this.testContext(ctx, "XAConnectionFactory", null);
        this.testContext(ctx, "XAQueueConnectionFactory", null);
        this.testContext(ctx, "XATopicConnectionFactory", JMSFactoryType.TOPIC_XA_CF);
    }

    @Test
    public void testProviderUrlDefaultAndCustom() throws NamingException, JMSException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("java.naming.provider.url", "vm://0");
        props.put("connectionFactory.myConnectionFactory", "vm://0");
        InitialContext ctx = new InitialContext(props);
        this.testContext(ctx, "ConnectionFactory", JMSFactoryType.CF);
        this.testContext(ctx, "QueueConnectionFactory", JMSFactoryType.QUEUE_CF);
        this.testContext(ctx, "TopicConnectionFactory", JMSFactoryType.TOPIC_CF);
        this.testContext(ctx, "XAConnectionFactory", JMSFactoryType.XA_CF);
        this.testContext(ctx, "XAQueueConnectionFactory", JMSFactoryType.QUEUE_XA_CF);
        this.testContext(ctx, "XATopicConnectionFactory", JMSFactoryType.TOPIC_XA_CF);
        this.testContext(ctx, "myConnectionFactory", JMSFactoryType.CF);
    }

    @Test
    public void test1xNaming() throws NamingException, JMSException {
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0?enable1xPrefixes=true");
        props.put("connectionFactory.ConnectionFactory2", "vm://0");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        Assertions.assertTrue((boolean)((ActiveMQDestination)session.createQueue("testQueue")).getSimpleAddress().startsWith(PacketImpl.OLD_QUEUE_PREFIX));
        Assertions.assertTrue((boolean)((ActiveMQDestination)session.createTemporaryQueue()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX));
        Assertions.assertTrue((boolean)((ActiveMQDestination)session.createTopic("testTopic")).getSimpleAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX));
        Assertions.assertTrue((boolean)((ActiveMQDestination)session.createTemporaryTopic()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX));
        Assertions.assertFalse((boolean)session.createQueue("testQueue").getQueueName().startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString()));
        Assertions.assertFalse((boolean)session.createTemporaryQueue().getQueueName().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString()));
        Assertions.assertFalse((boolean)session.createTopic("testTopic").getTopicName().startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString()));
        Assertions.assertFalse((boolean)session.createTemporaryTopic().getTopicName().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString()));
        connection.close();
        connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory2");
        ((ActiveMQConnectionFactory)connectionFactory).setEnable1xPrefixes(true);
        connection = connectionFactory.createConnection();
        session = connection.createSession();
        Assertions.assertTrue((boolean)((ActiveMQDestination)session.createQueue("testQueue")).getSimpleAddress().startsWith(PacketImpl.OLD_QUEUE_PREFIX));
        Assertions.assertTrue((boolean)((ActiveMQDestination)session.createTemporaryQueue()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX));
        Assertions.assertTrue((boolean)((ActiveMQDestination)session.createTopic("testTopic")).getSimpleAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX));
        Assertions.assertTrue((boolean)((ActiveMQDestination)session.createTemporaryTopic()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX));
        Assertions.assertFalse((boolean)session.createQueue("testQueue").getQueueName().startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString()));
        Assertions.assertFalse((boolean)session.createTemporaryQueue().getQueueName().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString()));
        Assertions.assertFalse((boolean)session.createTopic("testTopic").getTopicName().startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString()));
        Assertions.assertFalse((boolean)session.createTemporaryTopic().getTopicName().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString()));
        connection.close();
    }

    @Test
    public void test1xNamingNegative() throws NamingException, JMSException {
        this.liveService.getSecurityStore().setSecurityEnabled(false);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        Assertions.assertFalse((boolean)((ActiveMQDestination)session.createQueue("testQueue")).getSimpleAddress().startsWith(PacketImpl.OLD_QUEUE_PREFIX));
        Assertions.assertFalse((boolean)((ActiveMQDestination)session.createTemporaryQueue()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX));
        Assertions.assertFalse((boolean)((ActiveMQDestination)session.createTopic("testTopic")).getSimpleAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX));
        Assertions.assertFalse((boolean)((ActiveMQDestination)session.createTemporaryTopic()).getSimpleAddress().startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX));
        connection.close();
    }

    @Test
    public void testUseTopologyForLoadBalancing() throws Exception {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        props.put("connectionFactory.ConnectionFactory", "vm://0?useTopologyForLoadBalancing=false");
        InitialContext ctx = new InitialContext(props);
        ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Assertions.assertFalse((boolean)((ActiveMQConnectionFactory)connectionFactory).getServerLocator().getUseTopologyForLoadBalancing());
    }
}

