/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageProducerTest
extends JMSTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.conn = this.cf.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoDefaultDestination() throws JMSException {
        try (Session session = this.conn.createSession();){
            MessageProducer producer = session.createProducer(null);
            Message m = session.createMessage();
            try {
                producer.send(m);
                Assertions.fail((String)"must not be reached");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasDefaultDestination() throws Exception {
        try (Session session = this.conn.createSession();){
            Queue queue = this.createQueue(this.name);
            Queue queue2 = this.createQueue(this.name + "2");
            MessageProducer producer = session.createProducer((Destination)queue);
            Message m = session.createMessage();
            try {
                producer.send((Destination)queue2, m);
                Assertions.fail((String)"must not be reached");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                producer.send((Destination)queue, m);
                Assertions.fail((String)"tck7 requires an UnsupportedOperationException even if the destination is the same as the default one");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

