/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class MoveMessageDuplicateIDTest
extends JMSTestBase {
    @Parameter(index=0)
    public String protocol = "AMQP";

    @Parameters(name="protocol={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"AMQP"}, {"CORE"}, {"OPENWIRE"});
    }

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        return super.createDefaultConfig(netty).setMessageExpiryScanPeriod(50L);
    }

    @TestTemplate
    public void testTwoQueuesSingleDLQ() throws Exception {
        TextMessage textMessage;
        int i;
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"JUNKYARD")).setExpiryAddress(SimpleString.of((String)"JUNKYARD")).setMaxDeliveryAttempts(1));
        this.createQueue("JUNKYARD");
        Queue junkQueue = this.server.locateQueue("JUNKYARD");
        Assertions.assertNotNull((Object)junkQueue);
        jakarta.jms.Queue queue1 = this.createQueue("q1");
        jakarta.jms.Queue queue2 = this.createQueue("q2");
        ConnectionFactory factory = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        Connection conn = factory.createConnection();
        Session sess = conn.createSession(true, 0);
        MessageProducer prod1 = sess.createProducer((Destination)queue1);
        MessageProducer prod2 = sess.createProducer((Destination)queue2);
        for (int i2 = 0; i2 < 100; ++i2) {
            TextMessage txt = sess.createTextMessage("txt");
            txt.setStringProperty("_AMQ_DUPL_ID", "" + i2);
            prod1.send((Message)txt);
            prod2.send((Message)txt);
        }
        sess.commit();
        conn.start();
        MessageConsumer consumer = sess.createConsumer((Destination)queue1);
        for (i = 0; i < 100; ++i) {
            textMessage = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)textMessage);
        }
        sess.rollback();
        Assertions.assertNull((Object)consumer.receiveNoWait());
        consumer.close();
        Wait.assertEquals((Long)100L, () -> ((Queue)junkQueue).getMessageCount(), (long)2000L, (long)10L);
        consumer = sess.createConsumer((Destination)queue2);
        for (i = 0; i < 100; ++i) {
            textMessage = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)textMessage);
        }
        sess.rollback();
        Assertions.assertNull((Object)consumer.receiveNoWait());
        consumer.close();
        conn.close();
        Wait.assertEquals((Long)200L, () -> ((Queue)junkQueue).getMessageCount(), (long)2000L, (long)10L);
    }

    @TestTemplate
    public void testMultiplSubscriptionSingleExpire() throws Exception {
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"DLQ")).setExpiryAddress(SimpleString.of((String)"DLQ")));
        this.createQueue("DLQ");
        Queue dlqServerQueue = this.server.locateQueue("DLQ");
        Assertions.assertNotNull((Object)dlqServerQueue);
        Topic topic = this.createTopic("test-topic");
        AddressControl control = ManagementControlHelper.createAddressControl(SimpleString.of((String)topic.getTopicName()), this.mbeanServer);
        ConnectionFactory cf = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        Connection conn = cf.createConnection();
        conn.setClientID("client1");
        Session sess2 = conn.createSession(true, 0);
        sess2.createDurableSubscriber(topic, "client-sub1");
        sess2.createDurableSubscriber(topic, "client-sub2");
        conn.close();
        conn = cf.createConnection();
        Session sess = conn.createSession(true, 0);
        MessageProducer prod = sess.createProducer((Destination)topic);
        prod.setTimeToLive(1L);
        for (int i = 0; i < 100; ++i) {
            TextMessage txt = sess.createTextMessage("txt");
            txt.setStringProperty("_AMQ_DUPL_ID", "" + i);
            prod.send((Message)txt);
        }
        sess.commit();
        conn.close();
        Wait.assertEquals((Long)0L, () -> ((AddressControl)control).getMessageCount(), (long)2000L, (long)10L);
        Wait.assertEquals((Long)200L, () -> ((Queue)dlqServerQueue).getMessageCount(), (long)2000L, (long)10L);
    }

    @TestTemplate
    public void testTwoQueuesSingleExpire() throws Exception {
        TextMessage txt;
        int i;
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"JUNKYARD")).setExpiryAddress(SimpleString.of((String)"JUNKYARD")));
        this.createQueue("JUNKYARD");
        Queue junkQueue = this.server.locateQueue("JUNKYARD");
        Assertions.assertNotNull((Object)junkQueue);
        jakarta.jms.Queue queue1 = this.createQueue("q1");
        jakarta.jms.Queue queue2 = this.createQueue("q2");
        ConnectionFactory cf = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        Connection conn = cf.createConnection();
        Session sess = conn.createSession(true, 0);
        MessageProducer prod1 = sess.createProducer((Destination)queue1);
        MessageProducer prod2 = sess.createProducer((Destination)queue2);
        prod1.setTimeToLive(1L);
        prod2.setTimeToLive(1L);
        for (i = 0; i < 100; ++i) {
            txt = sess.createTextMessage("txt");
            txt.setStringProperty("_AMQ_DUPL_ID", "" + i);
            prod1.send((Message)txt);
        }
        sess.commit();
        Wait.assertEquals((Long)100L, () -> ((Queue)junkQueue).getMessageCount(), (long)2000L, (long)10L);
        for (i = 0; i < 100; ++i) {
            txt = sess.createTextMessage("txt");
            txt.setStringProperty("_AMQ_DUPL_ID", "" + i);
            prod2.send((Message)txt);
        }
        sess.commit();
        conn.close();
        Wait.assertEquals((Long)200L, () -> ((Queue)junkQueue).getMessageCount(), (long)2000L, (long)10L);
    }
}

