/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueRequestor;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewQueueRequestorTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueRequestor() throws Exception {
        QueueConnection conn1 = null;
        QueueConnection conn2 = null;
        try {
            Queue queue1 = this.createQueue(true, "myQueue");
            conn1 = (QueueConnection)this.cf.createConnection();
            QueueSession sess1 = conn1.createQueueSession(false, 1);
            QueueRequestor requestor = new QueueRequestor(sess1, queue1);
            conn1.start();
            conn2 = (QueueConnection)this.cf.createConnection();
            QueueSession sess2 = conn2.createQueueSession(false, 1);
            TestMessageListener listener = new TestMessageListener(sess2);
            QueueReceiver receiver = sess2.createReceiver(queue1);
            receiver.setMessageListener((MessageListener)listener);
            conn2.start();
            Message m1 = sess1.createMessage();
            TextMessage m2 = (TextMessage)requestor.request(m1);
            Assertions.assertNotNull((Object)m2);
            Assertions.assertEquals((Object)"This is the response", (Object)m2.getText());
            requestor.close();
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    class TestMessageListener
    implements MessageListener {
        private final QueueSession sess;
        private final QueueSender sender;

        TestMessageListener(QueueSession sess) throws JMSException {
            this.sess = sess;
            this.sender = sess.createSender(null);
        }

        public void onMessage(Message m) {
            try {
                Destination queue = m.getJMSReplyTo();
                TextMessage m2 = this.sess.createTextMessage("This is the response");
                this.sender.send(queue, (Message)m2);
            }
            catch (JMSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

