/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReceiveNoWaitTest
extends JMSTestBase {
    private Queue queue;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.queue = this.createQueue("TestQueue");
    }

    @Test
    public void testReceiveNoWait() throws Exception {
        Assertions.assertNotNull((Object)this.queue);
        for (int i = 0; i < 10; ++i) {
            Connection connection = this.cf.createConnection();
            Session session = connection.createSession(false, 2);
            MessageProducer producer = session.createProducer((Destination)this.queue);
            producer.setDeliveryMode(2);
            for (int j = 0; j < 100; ++j) {
                String text = "Message" + j;
                TextMessage message = session.createTextMessage();
                message.setText(text);
                producer.send((Message)message);
            }
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)this.queue);
            for (int j = 0; j < 100; ++j) {
                TextMessage m = (TextMessage)consumer.receiveNoWait();
                if (m == null) {
                    throw new IllegalStateException("msg null");
                }
                Assertions.assertEquals((Object)("Message" + j), (Object)m.getText());
                m.acknowledge();
            }
            connection.close();
        }
    }
}

