/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleThreadsOpeningTest
extends JMSClusteredTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testRepetitions() throws Exception {
        int ITERATIONS = 50;
        for (int i = 0; i < 50; ++i) {
            logger.info("#test {}", (Object)i);
            this.internalMultipleOpen(200, 1);
            this.tearDown();
            this.setUp();
        }
    }

    @Test
    public void testMultipleOpen() throws Exception {
        this.internalMultipleOpen(20, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalMultipleOpen(int numberOfThreads, final int numberOfOpens) throws Exception {
        this.cf1 = ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), this.generateInVMParams(1))});
        final CountDownLatch flagAlignSemaphore = new CountDownLatch(numberOfThreads);
        final CountDownLatch flagStartRace = new CountDownLatch(1);
        class ThreadOpen
        extends Thread {
            int errors;

            ThreadOpen(int i) {
                super("MultipleThreadsOpeningTest/ThreadOpen::" + i);
                this.errors = 0;
            }

            @Override
            public void run() {
                try {
                    flagAlignSemaphore.countDown();
                    flagStartRace.await();
                    for (int i = 0; i < numberOfOpens; ++i) {
                        if (i > 0 && i % 100 == 0) {
                            logger.debug("connections created on Thread {} {}", (Object)Thread.currentThread(), (Object)i);
                        }
                        Connection conn = MultipleThreadsOpeningTest.this.cf1.createConnection();
                        Session sess = conn.createSession(true, 1);
                        sess.close();
                        conn.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.errors;
                }
            }
        }
        ThreadOpen[] threads = new ThreadOpen[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new ThreadOpen(i);
            threads[i].start();
        }
        flagAlignSemaphore.await();
        flagStartRace.countDown();
        try {
            for (ThreadOpen t : threads) {
                t.join(60000L);
                Assertions.assertFalse((boolean)t.isAlive());
                Assertions.assertEquals((int)0, (int)t.errors, (String)"There are Errors on the test thread");
            }
        }
        finally {
            for (ThreadOpen t : threads) {
                if (t.isAlive()) {
                    t.interrupt();
                }
                t.join(1000L);
            }
        }
    }
}

