/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.connection;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CloseDestroyedConnectionTest
extends JMSTestBase {
    private ActiveMQConnectionFactory cf;
    private ActiveMQSession session1;
    private Connection conn2;
    private ActiveMQSession session2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        this.cf.setBlockOnDurableSend(true);
        this.cf.setPreAcknowledge(true);
    }

    @Test
    public void testClosingTemporaryTopicDeletesQueue() throws JMSException, ActiveMQException {
        this.conn = this.cf.createConnection();
        Assertions.assertEquals((int)1, (int)this.server.getRemotingService().getConnections().size());
        this.session1 = (ActiveMQSession)this.conn.createSession(false, 1);
        ActiveMQTemporaryTopic topic = (ActiveMQTemporaryTopic)this.session1.createTemporaryTopic();
        String address = topic.getAddress();
        this.session1.close();
        this.conn.close();
        this.conn2 = this.cf.createConnection();
        this.session2 = (ActiveMQSession)this.conn2.createSession(false, 1);
        ClientSession cs = this.session2.getCoreSession();
        try {
            cs.createConsumer(address);
            Assertions.fail((String)"the address from the TemporaryTopic still exists!");
        }
        catch (ActiveMQException e) {
            Assertions.assertEquals((Object)ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST, (Object)e.getType(), (String)"expecting 'queue does not exist'");
        }
    }

    @Test
    public void testCloseDestroyedConnection() throws Exception {
        int cons;
        long connectionTTL = 500L;
        this.cf.setClientFailureCheckPeriod(connectionTTL / 2L);
        this.cf.setConnectionTTL(connectionTTL);
        this.conn = this.cf.createConnection();
        Assertions.assertEquals((int)1, (int)this.server.getRemotingService().getConnections().size());
        Session sess = this.conn.createSession(false, 1);
        Thread.sleep(500L);
        String queueName = "myqueue";
        Queue queue = ActiveMQJMSClient.createQueue((String)queueName);
        super.createQueue(queueName);
        sess.createConsumer((Destination)queue);
        sess.createProducer((Destination)queue);
        sess.createBrowser(queue);
        ClientSessionInternal sessi = (ClientSessionInternal)((ActiveMQSession)sess).getCoreSession();
        RemotingConnection rc = sessi.getConnection();
        rc.fail((ActiveMQException)new ActiveMQInternalErrorException());
        this.conn.close();
        long start = System.currentTimeMillis();
        while ((cons = this.server.getRemotingService().getConnections().size()) != 0) {
            long now = System.currentTimeMillis();
            if (now - start > 10000L) {
                throw new Exception("Timed out waiting for connections to close");
            }
            Thread.sleep(50L);
        }
    }
}

