/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.connection;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectionFactorySerializationTest
extends JMSTestBase {
    protected static ActiveMQConnectionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testConnectionFactoryUDP() throws Exception {
        this.createDiscoveryFactoryUDP();
        cf = (ActiveMQConnectionFactory)this.namingContext.lookup("/MyConnectionFactory");
        byte[] x = ConnectionFactorySerializationTest.serialize(cf);
        ActiveMQConnectionFactory y = ConnectionFactorySerializationTest.deserialize(x, ActiveMQConnectionFactory.class);
        ConnectionFactorySerializationTest.checkEquals(cf, y);
        DiscoveryGroupConfiguration dgc = y.getDiscoveryGroupConfiguration();
        Assertions.assertEquals((Object)dgc.getName(), (Object)"dg1");
        Assertions.assertEquals((long)dgc.getDiscoveryInitialWaitTimeout(), (long)5000L);
        Assertions.assertEquals((long)dgc.getRefreshTimeout(), (long)5000L);
        Assertions.assertTrue((boolean)(dgc.getBroadcastEndpointFactory() instanceof UDPBroadcastEndpointFactory));
        UDPBroadcastEndpointFactory befc = (UDPBroadcastEndpointFactory)dgc.getBroadcastEndpointFactory();
        Assertions.assertEquals((int)Integer.parseInt(System.getProperty("org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory.localBindPort", "-1")), (int)befc.getLocalBindPort());
        Assertions.assertEquals((Object)System.getProperty("org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory.localBindAddress"), (Object)befc.getLocalBindAddress());
        Assertions.assertEquals((int)ConnectionFactorySerializationTest.getUDPDiscoveryPort(), (int)befc.getGroupPort());
        Assertions.assertEquals((Object)ConnectionFactorySerializationTest.getUDPDiscoveryAddress(), (Object)befc.getGroupAddress());
    }

    @Test
    public void testConnectionFactoryJgroupsFile() throws Exception {
        this.createDiscoveryFactoryJGroupsFile();
        cf = (ActiveMQConnectionFactory)this.namingContext.lookup("/MyConnectionFactory");
        byte[] x = ConnectionFactorySerializationTest.serialize(cf);
        ActiveMQConnectionFactory y = ConnectionFactorySerializationTest.deserialize(x, ActiveMQConnectionFactory.class);
        ConnectionFactorySerializationTest.checkEquals(cf, y);
        DiscoveryGroupConfiguration dgc = y.getDiscoveryGroupConfiguration();
        Assertions.assertEquals((Object)dgc.getName(), (Object)"dg1");
        Assertions.assertEquals((long)dgc.getDiscoveryInitialWaitTimeout(), (long)5000L);
        Assertions.assertEquals((long)dgc.getRefreshTimeout(), (long)5000L);
        Assertions.assertTrue((boolean)(dgc.getBroadcastEndpointFactory() instanceof JGroupsFileBroadcastEndpointFactory));
        JGroupsFileBroadcastEndpointFactory befc = (JGroupsFileBroadcastEndpointFactory)dgc.getBroadcastEndpointFactory();
        Assertions.assertEquals((Object)"myChannel", (Object)befc.getChannelName());
        Assertions.assertEquals((Object)"/META-INF/myfile.xml", (Object)befc.getFile());
    }

    @Test
    public void testConnectionFactoryStatic1() throws Exception {
        this.createStaticFactory(true);
        cf = (ActiveMQConnectionFactory)this.namingContext.lookup("/MyConnectionFactory");
        byte[] x = ConnectionFactorySerializationTest.serialize(cf);
        ActiveMQConnectionFactory y = ConnectionFactorySerializationTest.deserialize(x, ActiveMQConnectionFactory.class);
        ConnectionFactorySerializationTest.checkEquals(cf, y);
        Assertions.assertEquals((Object)cf.isHA(), (Object)y.isHA());
        TransportConfiguration[] staticConnectors = y.getStaticConnectors();
        Assertions.assertEquals((int)staticConnectors.length, (int)2);
        TransportConfiguration tc0 = cf.getStaticConnectors()[0];
        TransportConfiguration y0 = y.getStaticConnectors()[0];
        Map ctParams = tc0.getParams();
        Map y0Params = y0.getParams();
        Assertions.assertEquals((int)ctParams.size(), (int)y0Params.size());
        for (String key : y0Params.keySet()) {
            Assertions.assertEquals(ctParams.get(key), y0Params.get(key));
        }
    }

    @Test
    public void testConnectionFactoryEncodeDecode() throws Exception {
        int byteRead;
        this.jmsServer.getActiveMQServer().getConfiguration().addConnectorConfiguration("foo", "tcp://localhost:1234");
        ArrayList<String> connectorNames = new ArrayList<String>();
        connectorNames.add("foo");
        ConnectionFactoryConfiguration cfc1 = new ConnectionFactoryConfigurationImpl().setName("MyConnectionFactory").setConnectorNames(connectorNames).setUseTopologyForLoadBalancing(false).setEnableSharedClientID(true);
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)1024);
        cfc1.encode(buffer);
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(bytes);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        buffer = ActiveMQBuffers.dynamicBuffer((int)1024);
        while ((byteRead = inputStream.read()) >= 0) {
            buffer.writeByte((byte)byteRead);
        }
        ConnectionFactoryConfigurationImpl cfc2 = new ConnectionFactoryConfigurationImpl();
        cfc2.decode(buffer);
        Assertions.assertEquals((Object)cfc1.getUseTopologyForLoadBalancing(), (Object)cfc2.getUseTopologyForLoadBalancing());
        Assertions.assertEquals((Object)cfc1.isEnableSharedClientID(), (Object)cfc2.isEnableSharedClientID());
    }

    private void createDiscoveryFactoryUDP() throws Exception {
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.add("MyConnectionFactory");
        String groupAddress = ConnectionFactorySerializationTest.getUDPDiscoveryAddress();
        int port = ConnectionFactorySerializationTest.getUDPDiscoveryPort();
        String localBindAddress = ConnectionFactorySerializationTest.getLocalHost().getHostAddress();
        UDPBroadcastEndpointFactory config = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(port).setLocalBindAddress(localBindAddress).setLocalBindPort(8580);
        DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName("dg1").setRefreshTimeout(5000L).setDiscoveryInitialWaitTimeout(5000L).setBroadcastEndpointFactory((BroadcastEndpointFactory)config);
        this.jmsServer.getActiveMQServer().getConfiguration().getDiscoveryGroupConfigurations().put(dcConfig.getName(), dcConfig);
        this.jmsServer.createConnectionFactory("MyConnectionFactory", false, JMSFactoryType.CF, dcConfig.getName(), new String[]{"/MyConnectionFactory"});
    }

    private void createDiscoveryFactoryJGroupsFile() throws Exception {
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.add("MyConnectionFactory");
        JGroupsFileBroadcastEndpointFactory config = new JGroupsFileBroadcastEndpointFactory().setChannelName("myChannel").setFile("/META-INF/myfile.xml");
        DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName("dg1").setRefreshTimeout(5000L).setDiscoveryInitialWaitTimeout(5000L).setBroadcastEndpointFactory((BroadcastEndpointFactory)config);
        this.jmsServer.getActiveMQServer().getConfiguration().getDiscoveryGroupConfigurations().put(dcConfig.getName(), dcConfig);
        this.jmsServer.createConnectionFactory("MyConnectionFactory", false, JMSFactoryType.CF, dcConfig.getName(), new String[]{"/MyConnectionFactory"});
    }

    private void createStaticFactory(boolean b) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        Set allowableConnectorKeys = TransportConstants.ALLOWABLE_CONNECTOR_KEYS;
        for (String allowableConnectorKey : allowableConnectorKeys) {
            String value = RandomUtil.randomString();
            params.put(allowableConnectorKey, value);
        }
        params.put("host", "localhost0");
        params.put("port", "1234");
        TransportConfiguration main = new TransportConfiguration(NETTY_CONNECTOR_FACTORY, params);
        this.jmsServer.getActiveMQServer().getConfiguration().getConnectorConfigurations().put(main.getName(), main);
        HashMap<String, String> params2 = new HashMap<String, String>();
        for (String allowableConnectorKey : allowableConnectorKeys) {
            String value = RandomUtil.randomString();
            params2.put(allowableConnectorKey, value);
        }
        params2.put("host", "localhost1");
        params2.put("port", "5678");
        TransportConfiguration main2 = new TransportConfiguration(NETTY_CONNECTOR_FACTORY, params2);
        this.jmsServer.getActiveMQServer().getConfiguration().getConnectorConfigurations().put(main2.getName(), main2);
        ArrayList<String> connectorNames = new ArrayList<String>();
        connectorNames.add(main.getName());
        connectorNames.add(main2.getName());
        ConnectionFactoryConfiguration configuration = new ConnectionFactoryConfigurationImpl().setName("MyConnectionFactory").setHA(b).setConnectorNames(connectorNames).setClientID("clientID").setClientFailureCheckPeriod(-1L).setConnectionTTL(-2L).setFactoryType(JMSFactoryType.CF).setCallTimeout(-3L).setCallFailoverTimeout(-4L).setCacheLargeMessagesClient(b).setMinLargeMessageSize(-5).setConsumerWindowSize(-6).setConsumerMaxRate(-7).setConfirmationWindowSize(-8).setProducerWindowSize(-9).setProducerMaxRate(-10).setBlockOnAcknowledge(b).setBlockOnDurableSend(b).setBlockOnNonDurableSend(b).setAutoGroup(b).setPreAcknowledge(b).setLoadBalancingPolicyClassName("foobar").setTransactionBatchSize(-11).setDupsOKBatchSize(-12).setUseGlobalPools(b).setScheduledThreadPoolMaxSize(-13).setThreadPoolMaxSize(-14).setRetryInterval(-15L).setRetryIntervalMultiplier(-16.0).setMaxRetryInterval(-17L).setReconnectAttempts(-18).setGroupID("groupID").setInitialMessagePacketSize(1499);
        this.jmsServer.createConnectionFactory(false, configuration, new String[]{"/MyConnectionFactory"});
    }

    private void populate(StringBuilder sb, BeanUtilsBean bean, ActiveMQConnectionFactory factory) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = bean.getPropertyUtils().getPropertyDescriptors((Object)factory)) {
            if (descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null) continue;
            if (descriptor.getPropertyType() == String.class) {
                String value = RandomUtil.randomString();
                bean.setProperty((Object)factory, descriptor.getName(), (Object)value);
                sb.append("&").append(descriptor.getName()).append("=").append(value);
                continue;
            }
            if (descriptor.getPropertyType() == Integer.TYPE) {
                int value = RandomUtil.randomPositiveInt();
                bean.setProperty((Object)factory, descriptor.getName(), (Object)value);
                sb.append("&").append(descriptor.getName()).append("=").append(value);
                continue;
            }
            if (descriptor.getPropertyType() == Long.TYPE) {
                long value = RandomUtil.randomPositiveLong();
                bean.setProperty((Object)factory, descriptor.getName(), (Object)value);
                sb.append("&").append(descriptor.getName()).append("=").append(value);
                continue;
            }
            if (descriptor.getPropertyType() != Double.TYPE) continue;
            double value = RandomUtil.randomDouble();
            bean.setProperty((Object)factory, descriptor.getName(), (Object)value);
            sb.append("&").append(descriptor.getName()).append("=").append(value);
        }
    }

    private static void checkEquals(Object factory, Object factory2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor[] descriptors;
        BeanUtilsBean bean = new BeanUtilsBean();
        for (PropertyDescriptor descriptor : descriptors = bean.getPropertyUtils().getPropertyDescriptors(factory)) {
            if (descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null) continue;
            Assertions.assertEquals((Object)bean.getProperty(factory, descriptor.getName()), (Object)bean.getProperty(factory2, descriptor.getName()), (String)(descriptor.getName() + " incorrect"));
        }
    }

    private static <T extends Serializable> byte[] serialize(T obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        return baos.toByteArray();
    }

    private static <T extends Serializable> T deserialize(byte[] b, Class<T> cl) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        return (T)((Serializable)cl.cast(o));
    }

    protected static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            addr = InetAddress.getByName(null);
        }
        return addr;
    }
}

