/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class JMSCorrelationIDTest
extends MultiprotocolJMSClientTestSupport {
    private void testCorrelationIDAsBytesSendReceive(Connection producerConnection, Connection consumerConnection) throws Throwable {
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        byte[] bytes = new byte[16];
        for (int i = 0; i <= 15; ++i) {
            bytes[i] = (byte)i;
        }
        MessageProducer producer = session.createProducer((Destination)queue);
        Message message = session.createMessage();
        message.setJMSCorrelationIDAsBytes(bytes);
        producer.send(message);
        producer.close();
        Session sessionConsumer = consumerConnection.createSession(false, 1);
        Queue consumerQueue = sessionConsumer.createQueue(this.getQueueName());
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)consumerQueue);
        Message m = consumer.receive(5000L);
        Assertions.assertNotNull((Object)m, (String)"Could not receive message on consumer");
        Assertions.assertArrayEquals((byte[])bytes, (byte[])m.getJMSCorrelationIDAsBytes());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsBytesSendReceiveFromAMQPToAMQP() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsBytesSendReceiveFromAMQPToCore() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsBytesSendReceiveFromAMQPToOpenWire() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsBytesSendReceiveFromCoreToCore() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createCoreConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsBytesSendReceiveFromCoreToAMQP() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createCoreConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsBytesSendReceiveFromCoreToOpenWire() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createCoreConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsBytesSendReceiveFromOpenWireToOpenWire() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createOpenWireConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=60L)
    @Disabled
    public void testCorrelationIDAsBytesSendReceiveFromOpenWireToAMQP() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createOpenWireConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=60L)
    @Disabled
    public void testCorrelationIDAsBytesSendReceiveFromOpenWireToCore() throws Throwable {
        this.testCorrelationIDAsBytesSendReceive(this.createOpenWireConnection(), this.createCoreConnection());
    }

    private void testCorrelationIDAsStringSendReceive(Connection producerConnection, Connection consumerConnection) throws Throwable {
        String correlationId = RandomUtil.randomString();
        Session session = producerConnection.createSession(false, 1);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        Message message = session.createMessage();
        message.setJMSCorrelationID(correlationId);
        producer.send(message);
        producer.close();
        Session sessionConsumer = consumerConnection.createSession(false, 1);
        Queue consumerQueue = sessionConsumer.createQueue(this.getQueueName());
        MessageConsumer consumer = sessionConsumer.createConsumer((Destination)consumerQueue);
        Message m = consumer.receive(5000L);
        Assertions.assertNotNull((Object)m, (String)"Could not receive message on consumer");
        Assertions.assertEquals((Object)correlationId, (Object)m.getJMSCorrelationID());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromAMQPToAMQP() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromAMQPToCore() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromAMQPToOpenWire() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromCoreToCore() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createCoreConnection(), this.createCoreConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromCoreToAMQP() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createCoreConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromCoreToOpenWire() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createCoreConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromOpenWireToOpenWire() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createOpenWireConnection(), this.createOpenWireConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromOpenWireToAMQP() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createOpenWireConnection(), this.createConnection());
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationIDAsStringSendReceiveFromOpenWireToCore() throws Throwable {
        this.testCorrelationIDAsStringSendReceive(this.createOpenWireConnection(), this.createCoreConnection());
    }
}

