/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSNonDestructiveTest
extends MultiprotocolJMSClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String NON_DESTRUCTIVE_QUEUE_NAME = "NON_DESTRUCTIVE_QUEUE";
    private static final String NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME = "NON_DESTRUCTIVE_EXPIRY_QUEUE";
    private static final String NON_DESTRUCTIVE_LVQ_QUEUE_NAME = "NON_DESTRUCTIVE_LVQ_QUEUE";
    private static final String NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME = "NON_DESTRUCTIVE_LVQ_TOMBSTONE_QUEUE";
    protected final boolean persistenceEnabled;
    protected final long scanPeriod;

    public JMSNonDestructiveTest(boolean persistenceEnabled, long scanPeriod) {
        this.persistenceEnabled = persistenceEnabled;
        this.scanPeriod = scanPeriod;
    }

    @Parameters(name="persistenceEnabled={0}, scanPeriod={1}")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{false, 100}, {true, 100}, {true, -1}};
        return Arrays.asList(params);
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setPersistenceEnabled(this.persistenceEnabled);
        server.getConfiguration().setMessageExpiryScanPeriod(this.scanPeriod);
        server.getAddressSettingsRepository().addMatch(NON_DESTRUCTIVE_QUEUE_NAME, (Object)new AddressSettings().setDefaultNonDestructive(true));
        server.getAddressSettingsRepository().addMatch(NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME, (Object)new AddressSettings().setDefaultNonDestructive(true).setExpiryDelay(Long.valueOf(100L)));
        server.getAddressSettingsRepository().addMatch(NON_DESTRUCTIVE_LVQ_QUEUE_NAME, (Object)new AddressSettings().setDefaultLastValueQueue(true).setDefaultNonDestructive(true));
        server.getAddressSettingsRepository().addMatch(NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, (Object)new AddressSettings().setDefaultLastValueQueue(true).setDefaultNonDestructive(true));
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        super.createAddressAndQueues(server);
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)NON_DESTRUCTIVE_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)NON_DESTRUCTIVE_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)NON_DESTRUCTIVE_LVQ_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)NON_DESTRUCTIVE_LVQ_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testNonDestructiveAMQPProducerAMQPConsumer() throws Exception {
        this.testNonDestructive(this.AMQPConnection, this.AMQPConnection);
    }

    @TestTemplate
    public void testNonDestructiveCoreProducerCoreConsumer() throws Exception {
        this.testNonDestructive(this.CoreConnection, this.CoreConnection);
    }

    @TestTemplate
    public void testNonDestructiveCoreProducerAMQPConsumer() throws Exception {
        this.testNonDestructive(this.CoreConnection, this.AMQPConnection);
    }

    @TestTemplate
    public void testNonDestructiveAMQPProducerCoreConsumer() throws Exception {
        this.testNonDestructive(this.AMQPConnection, this.CoreConnection);
    }

    @TestTemplate
    public void testNonDestructiveLVQWithConsumerFirstCore() throws Exception {
        this.testNonDestructiveLVQWithConsumerFirst(this.CoreConnection);
    }

    @TestTemplate
    public void testNonDestructiveLVQWithConsumerFirstAMQP() throws Exception {
        this.testNonDestructiveLVQWithConsumerFirst(this.AMQPConnection);
    }

    public void testNonDestructive(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testNonDestructiveSingle(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveDualConsumer(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveExpiry(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveMulitpleMessages(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveMulitpleMessagesDualConsumer(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveLVQ(producerConnectionSupplier, consumerConnectionSupplier);
        this.testNonDestructiveLVQTombstone(producerConnectionSupplier, consumerConnectionSupplier);
    }

    public void testNonDestructiveSingle(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)NON_DESTRUCTIVE_QUEUE_NAME));
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        Assertions.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount(), (String)"Message count after clearing queue via queue control should be 0");
    }

    public void testNonDestructiveDualConsumer(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)NON_DESTRUCTIVE_QUEUE_NAME));
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receiveDualConsumer(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receiveDualConsumer(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME);
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        Assertions.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount(), (String)"Message count after clearing queue via queue control should be 0");
    }

    public void testNonDestructiveExpiry(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME));
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME);
        Wait.assertEquals((long)1L, () -> ((Queue)queueBinding.getQueue()).getMessageCount());
        Wait.waitFor(() -> queueBinding.getQueue().getMessageCount() == 0L, (long)200L);
        this.receiveNull(consumerConnectionSupplier, NON_DESTRUCTIVE_EXPIRY_QUEUE_NAME);
        Assertions.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_EXPIRY_QUEUE");
        control.removeAllMessages();
        Assertions.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount(), (String)"Message count after clearing queue via queue control should be 0");
    }

    public void testNonDestructiveMulitpleMessages(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 0);
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 1);
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 2);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)NON_DESTRUCTIVE_QUEUE_NAME));
        Assertions.assertEquals((long)3L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 3);
        this.receive(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 3);
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        Assertions.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount(), (String)"Message count after clearing queue via queue control should be 0");
    }

    public void testNonDestructiveMulitpleMessagesDualConsumer(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 0);
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 1);
        this.sendMessage(producerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 2);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)NON_DESTRUCTIVE_QUEUE_NAME));
        Assertions.assertEquals((long)3L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receiveDualConsumer(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 3);
        this.receiveDualConsumer(consumerConnectionSupplier, NON_DESTRUCTIVE_QUEUE_NAME, 3);
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        Assertions.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount(), (String)"Message count after clearing queue via queue control should be 0");
    }

    public void testNonDestructiveLVQ(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.sendLVQ(producerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)NON_DESTRUCTIVE_LVQ_QUEUE_NAME));
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        Thread.sleep(10L);
        this.receiveLVQ(consumerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receiveLVQ(consumerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.sendLVQ(producerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        Thread.sleep(10L);
        this.receiveLVQ(consumerConnectionSupplier, NON_DESTRUCTIVE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_LVQ_QUEUE");
        control.removeAllMessages();
        Assertions.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount(), (String)"Message count after clearing queue via queue control should be 0");
    }

    public void testNonDestructiveLVQWithConsumerFirst(MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        Session session;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        CountDownLatch consumerSetup = new CountDownLatch(1);
        CountDownLatch consumerComplete = new CountDownLatch(1);
        executor.submit(() -> {
            try (Connection connection = connectionSupplier.createConnection();
                 Session session = connection.createSession(false, 1);
                 MessageConsumer messageConsumer = session.createConsumer((Destination)session.createQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME));){
                connection.start();
                consumerSetup.countDown();
                BytesMessage messageReceived = (BytesMessage)messageConsumer.receive(5000L);
                Assertions.assertNotNull((Object)messageReceived);
                consumerComplete.countDown();
            }
            catch (Exception e) {
                Assertions.fail((String)e.getMessage());
            }
            consumerComplete.countDown();
        });
        consumerSetup.await(5L, TimeUnit.SECONDS);
        try (Connection connection = connectionSupplier.createConnection();){
            session = connection.createSession(false, 1);
            try {
                MessageProducer producer = session.createProducer((Destination)session.createQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME));
                BytesMessage message = session.createBytesMessage();
                message.writeUTF("mills " + System.currentTimeMillis());
                message.setStringProperty("_AMQ_LVQ_NAME", "STOCK_NAME");
                producer.send((Message)message);
                consumerComplete.await(5L, TimeUnit.SECONDS);
                message = session.createBytesMessage();
                message.writeUTF("mills " + System.currentTimeMillis());
                message.setStringProperty("_AMQ_LVQ_NAME", "STOCK_NAME");
                producer.send((Message)message);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        connection = connectionSupplier.createConnection();
        try {
            session = connection.createSession(false, 1);
            try (MessageConsumer messageConsumer = session.createConsumer((Destination)session.createQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME));){
                connection.start();
                BytesMessage messageReceived = (BytesMessage)messageConsumer.receive(5000L);
                Assertions.assertNotNull((Object)messageReceived);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        executor.shutdownNow();
    }

    public void testNonDestructiveLVQTombstone(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        int tombstoneTimeToLive = 500;
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME));
        LastValueQueue lastValueQueue = (LastValueQueue)queueBinding.getQueue();
        this.sendLVQ(producerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        Assertions.assertEquals((long)1L, (long)lastValueQueue.getMessageCount(), (String)"Ensure Message count");
        Thread.sleep(10L);
        this.receiveLVQ(consumerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        this.sendLVQTombstone(producerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), tombstoneTimeToLive);
        Assertions.assertEquals((long)1L, (long)lastValueQueue.getMessageCount(), (String)"Ensure Message count");
        Thread.sleep(10L);
        this.receiveLVQTombstone(consumerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        this.receiveLVQTombstone(consumerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME, org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString());
        Assertions.assertEquals((int)1, (int)lastValueQueue.getLastValueKeys().size(), (String)"Ensure Message count");
        Thread.sleep(tombstoneTimeToLive * 3);
        this.receiveLVQAssertEmpty(consumerConnectionSupplier, NON_DESTRUCTIVE_TOMBSTONE_LVQ_QUEUE_NAME);
        Assertions.assertEquals((long)0L, (long)lastValueQueue.getMessageCount(), (String)"Ensure Message count");
        Assertions.assertEquals((int)0, (int)lastValueQueue.getLastValueKeys().size(), (String)"Ensure Message count");
    }

    @TestTemplate
    public void testMessageCount() throws Exception {
        this.sendMessage(this.CoreConnection, NON_DESTRUCTIVE_QUEUE_NAME);
        QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)NON_DESTRUCTIVE_QUEUE_NAME));
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receive(this.CoreConnection, NON_DESTRUCTIVE_QUEUE_NAME);
        Assertions.assertEquals((long)1L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.sendMessage(this.CoreConnection, NON_DESTRUCTIVE_QUEUE_NAME);
        Assertions.assertEquals((long)2L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        this.receive(this.CoreConnection, NON_DESTRUCTIVE_QUEUE_NAME);
        Assertions.assertEquals((long)2L, (long)queueBinding.getQueue().getMessageCount(), (String)"Ensure Message count");
        QueueControl control = (QueueControl)this.server.getManagementService().getResource("queue.NON_DESTRUCTIVE_QUEUE");
        control.removeAllMessages();
        Assertions.assertEquals((long)0L, (long)queueBinding.getQueue().getMessageCount(), (String)"Message count after clearing queue via queue control should be 0");
    }

    private void receive(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, int i) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            jakarta.jms.Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            for (int j = 0; j < i; ++j) {
                TextMessage msg = (TextMessage)consumer.receive(200L);
                Assertions.assertNotNull((Object)msg);
                Assertions.assertEquals((Object)Integer.toString(j), (Object)msg.getText());
            }
            TextMessage msg = (TextMessage)consumer.receiveNoWait();
            Assertions.assertNull((Object)msg);
            consumer.close();
        }
    }

    private void receive(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            jakarta.jms.Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            TextMessage msg = (TextMessage)consumer.receive(2000L);
            Assertions.assertNotNull((Object)msg);
            consumer.close();
        }
    }

    private void receiveNull(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            jakarta.jms.Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            TextMessage msg = (TextMessage)consumer.receiveNoWait();
            Assertions.assertNull((Object)msg);
            consumer.close();
        }
    }

    private void receiveDualConsumer(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();
             Connection consumerConnection2 = consumerConnectionSupplier.createConnection();){
            MessageConsumer consumer = this.createConsumer(consumerConnection, queueName);
            MessageConsumer consumer2 = this.createConsumer(consumerConnection2, queueName);
            TextMessage msg = (TextMessage)consumer.receive(2000L);
            TextMessage msg2 = (TextMessage)consumer2.receive(2000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertNotNull((Object)msg2);
            consumer.close();
            consumer2.close();
        }
    }

    private void receiveDualConsumer(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, int i) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();
             Connection consumerConnection2 = consumerConnectionSupplier.createConnection();){
            MessageConsumer consumer = this.createConsumer(consumerConnection, queueName);
            MessageConsumer consumer2 = this.createConsumer(consumerConnection2, queueName);
            for (int j = 0; j < i; ++j) {
                TextMessage msg = (TextMessage)consumer.receive(200L);
                TextMessage msg2 = (TextMessage)consumer2.receive(200L);
                Assertions.assertNotNull((Object)msg);
                Assertions.assertNotNull((Object)msg2);
                Assertions.assertEquals((Object)Integer.toString(j), (Object)msg.getText());
                Assertions.assertEquals((Object)Integer.toString(j), (Object)msg2.getText());
            }
            TextMessage msg = (TextMessage)consumer.receiveNoWait();
            Assertions.assertNull((Object)msg);
            TextMessage msg2 = (TextMessage)consumer2.receiveNoWait();
            Assertions.assertNull((Object)msg2);
            consumer.close();
            consumer2.close();
        }
    }

    private MessageConsumer createConsumer(Connection connection, String queueName) throws JMSException {
        connection.start();
        Session consumerSession = connection.createSession(false, 1);
        jakarta.jms.Queue consumerQueue = consumerSession.createQueue(queueName);
        return consumerSession.createConsumer((Destination)consumerQueue);
    }

    private void sendMessage(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName) throws JMSException {
        this.sendMessage(producerConnectionSupplier, queueName, 0);
    }

    private void sendMessage(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, int i) throws JMSException {
        try (Connection connection = producerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));){
            TextMessage message1 = session.createTextMessage();
            message1.setText(Integer.toString(i));
            producer.send((Message)message1);
        }
    }

    private void receiveLVQ(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection connection = consumerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queueName));){
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"KEY", (Object)msg.getStringProperty(lastValueKey));
            Assertions.assertEquals((Object)"how are you", (Object)msg.getText());
        }
    }

    private void sendLVQ(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection connection = producerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));){
            TextMessage message1 = session.createTextMessage();
            message1.setStringProperty(lastValueKey, "KEY");
            message1.setText("hello");
            producer.send((Message)message1);
            TextMessage message2 = session.createTextMessage();
            message2.setStringProperty(lastValueKey, "KEY");
            message2.setText("how are you");
            producer.send((Message)message2);
        }
    }

    private void receiveLVQTombstone(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String lastValueKey) throws JMSException {
        try (Connection connection = consumerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queueName));){
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"KEY", (Object)msg.getStringProperty(lastValueKey));
            Assertions.assertEquals((Object)"tombstone", (Object)msg.getText());
        }
    }

    private void receiveLVQAssertEmpty(MultiprotocolJMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName) throws JMSException {
        try (Connection connection = consumerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(queueName));){
            TextMessage msg = (TextMessage)consumer.receiveNoWait();
            Assertions.assertNull((Object)msg);
        }
    }

    private void sendLVQTombstone(MultiprotocolJMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, String lastValueKey, int tombstoneTimeToLive) throws JMSException {
        try (Connection connection = producerConnectionSupplier.createConnection();
             Session session = connection.createSession();
             MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));){
            TextMessage message1 = session.createTextMessage();
            message1.setStringProperty(lastValueKey, "KEY");
            message1.setText("tombstone");
            producer.send((Message)message1, 2, 4, (long)tombstoneTimeToLive);
        }
    }

    @TestTemplate
    public void testMultipleLastValuesCore() throws Exception {
        this.testMultipleLastValues(this.CoreConnection);
    }

    @TestTemplate
    public void testMultipleLastValuesAMQP() throws Exception {
        this.testMultipleLastValues(this.AMQPConnection);
    }

    private void testMultipleLastValues(MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        int GROUP_COUNT = 5;
        int MESSAGE_COUNT_PER_GROUP = 25;
        int PRODUCER_COUNT = 5;
        HashMap results = new HashMap();
        for (int i = 0; i < 5; ++i) {
            results.put((CallSite)((Object)("" + i)), new ArrayList());
        }
        HashMap<String, Integer> dups = new HashMap<String, Integer>();
        ArrayList<Producer> producers = new ArrayList<Producer>();
        int receivedTally = 0;
        try (Connection connection = connectionSupplier.createConnection();){
            Object tm;
            Session session = connection.createSession(false, 2);
            jakarta.jms.Queue queue = session.createQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            for (int i = 0; i < 5; ++i) {
                producers.add(new Producer(connectionSupplier, 25, 5, i));
            }
            for (Producer producer : producers) {
                new Thread(producer).start();
            }
            while ((tm = (TextMessage)consumer.receive(500L)) != null) {
                ++receivedTally;
                ((List)results.get(tm.getStringProperty("lastval"))).add(tm.getText());
                tm.acknowledge();
            }
            for (Producer producer : producers) {
                Assertions.assertFalse((boolean)producer.failed, (String)"Producer failed!");
            }
        }
        for (Map.Entry entry : results.entrySet()) {
            StringBuilder values = new StringBuilder();
            for (String s : (List)entry.getValue()) {
                int occurrences = Collections.frequency((Collection)entry.getValue(), s);
                if (occurrences > 1 && !dups.containsValue(Integer.parseInt(s))) {
                    dups.put(s, occurrences);
                }
                values.append(s);
                values.append(",");
            }
            logger.info("Messages received with lastval={} ({})", entry.getKey(), (Object)values);
        }
        if (dups.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry stringIntegerEntry : dups.entrySet()) {
                sb.append((String)stringIntegerEntry.getKey() + "(" + stringIntegerEntry.getValue() + "),");
            }
            Assertions.fail((String)("Duplicate messages received " + sb));
        }
        Assertions.assertEquals((int)625, (int)receivedTally, (String)"Got all messages produced");
        Wait.assertEquals((Long)5L, () -> this.server.locateQueue(NON_DESTRUCTIVE_LVQ_QUEUE_NAME).getMessageCount(), (long)2000L, (long)100L, (boolean)false);
    }

    private class Producer
    implements Runnable {
        private final MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier;
        private final int messageCount;
        private final int groupCount;
        private final int offset;
        public boolean failed = false;

        Producer(MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier, int messageCount, int groupCount, int offset) {
            this.connectionSupplier = connectionSupplier;
            this.messageCount = messageCount;
            this.groupCount = groupCount;
            this.offset = offset;
        }

        @Override
        public void run() {
            try (Connection connection = this.connectionSupplier.createConnection();){
                Session session = connection.createSession(false, 2);
                jakarta.jms.Queue queue = session.createQueue(JMSNonDestructiveTest.NON_DESTRUCTIVE_LVQ_QUEUE_NAME);
                MessageProducer producer = session.createProducer((Destination)queue);
                int startingPoint = this.offset * (this.messageCount * this.groupCount);
                int messagesToSend = this.messageCount * this.groupCount;
                for (int i = startingPoint; i < messagesToSend + startingPoint; ++i) {
                    String lastval = "" + i % this.groupCount;
                    TextMessage message = session.createTextMessage();
                    message.setText("" + i);
                    message.setStringProperty("data", "" + i);
                    message.setStringProperty("lastval", lastval);
                    message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), lastval);
                    producer.send((Message)message);
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
                this.failed = true;
                return;
            }
        }
    }
}

