/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.AcceptorControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.tests.integration.SimpleNotificationService;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AcceptorControlTest
extends ManagementTestBase {
    public boolean usingCore() {
        return false;
    }

    @Test
    public void testAttributes() throws Exception {
        TransportConfiguration acceptorConfig = new TransportConfiguration(InVMAcceptorFactory.class.getName(), new HashMap(), RandomUtil.randomString());
        acceptorConfig.getParams().put("keyStorePassword", "password");
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(acceptorConfig);
        ActiveMQServer service = this.createServer(false, (Configuration)config);
        service.setMBeanServer(this.mbeanServer);
        service.start();
        AcceptorControl acceptorControl = this.createManagementControl(acceptorConfig.getName());
        Assertions.assertEquals((Object)acceptorConfig.getName(), (Object)acceptorControl.getName());
        Assertions.assertEquals((Object)acceptorConfig.getFactoryClassName(), (Object)acceptorControl.getFactoryClassName());
        Assertions.assertNotEquals(acceptorConfig.getParams().get("keyStorePassword"), acceptorControl.getParameters().get("keyStorePassword"));
        Assertions.assertEquals((Object)"****", acceptorControl.getParameters().get("keyStorePassword"));
    }

    @Test
    public void testStartStop() throws Exception {
        TransportConfiguration acceptorConfig = new TransportConfiguration(InVMAcceptorFactory.class.getName(), new HashMap(), RandomUtil.randomString());
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(acceptorConfig);
        ActiveMQServer service = this.createServer(false, (Configuration)config);
        service.setMBeanServer(this.mbeanServer);
        service.start();
        AcceptorControl acceptorControl = this.createManagementControl(acceptorConfig.getName());
        Assertions.assertTrue((boolean)acceptorControl.isStarted());
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        Assertions.assertNotNull((Object)session);
        session.close();
        acceptorControl.stop();
        Assertions.assertFalse((boolean)acceptorControl.isStarted());
        try {
            sf.createSession(false, true, true);
            Assertions.fail((String)"acceptor must not accept connections when stopped accepting");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        acceptorControl.start();
        Assertions.assertTrue((boolean)acceptorControl.isStarted());
        locator = this.createInVMNonHALocator();
        sf = this.createSessionFactory(locator);
        session = sf.createSession(false, true, true);
        Assertions.assertNotNull((Object)session);
        session.close();
        acceptorControl.stop();
        Assertions.assertFalse((boolean)acceptorControl.isStarted());
        try {
            sf.createSession(false, true, true);
            Assertions.fail((String)"acceptor must not accept connections when stopped accepting");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
    }

    @Test
    public void testNotifications() throws Exception {
        TransportConfiguration acceptorConfig = new TransportConfiguration(InVMAcceptorFactory.class.getName(), new HashMap(), RandomUtil.randomString());
        TransportConfiguration acceptorConfig2 = new TransportConfiguration(NettyAcceptorFactory.class.getName(), new HashMap(), RandomUtil.randomString());
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(acceptorConfig).addAcceptorConfiguration(acceptorConfig2);
        ActiveMQServer service = this.createServer(false, (Configuration)config);
        service.setMBeanServer(this.mbeanServer);
        service.start();
        AcceptorControl acceptorControl = this.createManagementControl(acceptorConfig2.getName());
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        service.getManagementService().addNotificationListener((NotificationListener)notifListener);
        Assertions.assertEquals((int)0, (int)notifListener.getNotifications().size());
        acceptorControl.stop();
        Assertions.assertEquals((int)(this.usingCore() ? 7 : 1), (int)notifListener.getNotifications().size());
        int i = this.findNotification(notifListener, CoreNotificationType.ACCEPTOR_STOPPED);
        Notification notif = notifListener.getNotifications().get(i);
        Assertions.assertEquals((Object)CoreNotificationType.ACCEPTOR_STOPPED, (Object)notif.getType());
        Assertions.assertEquals((Object)NettyAcceptorFactory.class.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"factory")).toString());
        acceptorControl.start();
        i = this.findNotification(notifListener, CoreNotificationType.ACCEPTOR_STARTED);
        notif = notifListener.getNotifications().get(i);
        Assertions.assertEquals((Object)CoreNotificationType.ACCEPTOR_STARTED, (Object)notif.getType());
        Assertions.assertEquals((Object)NettyAcceptorFactory.class.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"factory")).toString());
    }

    private int findNotification(SimpleNotificationService.Listener notifListener, CoreNotificationType type) {
        int i = 0;
        for (i = 0; i < notifListener.getNotifications().size() && !notifListener.getNotifications().get(i).getType().equals(type); ++i) {
        }
        Assertions.assertTrue((i < notifListener.getNotifications().size() ? (byte)1 : 0) != 0);
        return i;
    }

    protected AcceptorControl createManagementControl(String name) throws Exception {
        return ManagementControlHelper.createAcceptorControl(name, this.mbeanServer);
    }
}

