/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.ArrayList;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.JGroupsFileBroadcastGroupControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JGroupsFileBroadcastGroupControlTest
extends ManagementTestBase {
    private ActiveMQServer server;
    BroadcastGroupConfiguration broadcastGroupConfig;
    JGroupsFileBroadcastGroupControl broadcastGroupControl;

    @Test
    public void testAttributes() throws Exception {
        JGroupsFileBroadcastEndpointFactory udpCfg = (JGroupsFileBroadcastEndpointFactory)this.broadcastGroupConfig.getEndpointFactory();
        Assertions.assertEquals((Object)this.broadcastGroupConfig.getName(), (Object)this.broadcastGroupControl.getName());
        Assertions.assertEquals((Object)udpCfg.getChannelName(), (Object)this.broadcastGroupControl.getChannelName());
        Assertions.assertEquals((Object)udpCfg.getFile(), (Object)this.broadcastGroupControl.getFile());
        Assertions.assertEquals((long)this.broadcastGroupConfig.getBroadcastPeriod(), (long)this.broadcastGroupControl.getBroadcastPeriod());
        Object[] connectorPairs = this.broadcastGroupControl.getConnectorPairs();
        Assertions.assertEquals((int)1, (int)connectorPairs.length);
        String connectorPairData = (String)connectorPairs[0];
        Assertions.assertEquals(this.broadcastGroupConfig.getConnectorInfos().get(0), (Object)connectorPairData);
        String jsonString = this.broadcastGroupControl.getConnectorPairsAsJSON();
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)1, (int)array.size());
        Assertions.assertEquals(this.broadcastGroupConfig.getConnectorInfos().get(0), (Object)array.getString(0));
        Assertions.assertTrue((boolean)this.broadcastGroupControl.isStarted());
    }

    protected JGroupsFileBroadcastGroupControl createManagementControl(String name) throws Exception {
        return ManagementControlHelper.createJgroupsFileBroadcastGroupControl(name, this.mbeanServer);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        TransportConfiguration connectorConfiguration = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        ArrayList<String> connectorInfos = new ArrayList<String>();
        connectorInfos.add(connectorConfiguration.getName());
        this.broadcastGroupConfig = new BroadcastGroupConfiguration().setName(RandomUtil.randomString()).setBroadcastPeriod((long)RandomUtil.randomPositiveInt()).setConnectorInfos(connectorInfos).setEndpointFactory((BroadcastEndpointFactory)new JGroupsFileBroadcastEndpointFactory().setChannelName("myChannel").setFile("test-jgroups-file_ping.xml"));
        Configuration config = this.createDefaultInVMConfig().setJMXManagementEnabled(true).addConnectorConfiguration(connectorConfiguration.getName(), connectorConfiguration).addBroadcastGroupConfiguration(this.broadcastGroupConfig);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)this.mbeanServer, (boolean)false));
        this.server.start();
        this.broadcastGroupControl = this.createManagementControl(this.broadcastGroupConfig.getName());
    }
}

