/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTInterceptorPropertiesTest
extends MQTTTestSupport {
    private static final String ADDRESS = "address";
    private static final String MESSAGE_TEXT = "messageText";
    private static final String RETAINED = "retained";
    private final AtomicReference<Throwable> interceptorError = new AtomicReference<Object>(null);

    private boolean checkMessageProperties(MqttMessage message, Map<String, Object> expectedProperties) {
        try {
            Assertions.assertNotNull((Object)message);
            Assertions.assertNotNull((Object)this.server.getNodeID());
            MqttFixedHeader header = message.fixedHeader();
            Assertions.assertNotNull((Object)header.messageType());
            Assertions.assertEquals((int)0, (int)header.qosLevel().value());
            Assertions.assertEquals((Object)expectedProperties.get(RETAINED), (Object)header.isRetain());
        }
        catch (Throwable t) {
            this.interceptorError.compareAndSet(null, t);
        }
        return true;
    }

    @Test
    @Timeout(value=60L)
    public void testCheckInterceptedMQTTMessageProperties() throws Exception {
        String addressQueue = this.name;
        String msgText = "Test intercepted message";
        boolean retained = true;
        ConcurrentHashMap<String, Object> expectedProperties = new ConcurrentHashMap<String, Object>();
        expectedProperties.put(ADDRESS, addressQueue);
        expectedProperties.put(MESSAGE_TEXT, "Test intercepted message");
        expectedProperties.put(RETAINED, true);
        CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                return this.checkMessageProperties((MqttMessage)packet, (Map<String, Object>)expectedProperties);
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                return this.checkMessageProperties((MqttMessage)packet, (Map<String, Object>)expectedProperties);
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        publishProvider.publish(addressQueue, "Test intercepted message".getBytes(), 0, true);
        MQTTClientProvider subscribeProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscribeProvider);
        subscribeProvider.subscribe(addressQueue, 0);
        Thread thread = new Thread(() -> {
            try {
                byte[] payload = subscribeProvider.receive(10000);
                Assertions.assertNotNull((Object)payload, (String)"Should get a message");
                latch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.start();
        latch.await(10L, TimeUnit.SECONDS);
        subscribeProvider.disconnect();
        publishProvider.disconnect();
        Assertions.assertNull((Object)this.interceptorError.get());
    }
}

