/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.remoting.impl.AbstractAcceptor;
import org.apache.activemq.artemis.core.remoting.server.impl.RemotingServiceImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MqttClusterRemoteSubscribeTest
extends ClusterTestBase {
    @Override
    protected boolean isResolveProtocols() {
        return true;
    }

    public boolean isNetty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useSameClientIdAndAnycastSubscribeRemoteQueue() throws Exception {
        Object[] topics;
        String ANYCAST_TOPIC = "anycast/test/1/some/la";
        String subClientId = "subClientId";
        String pubClientId = "pubClientId";
        this.setupServers("anycast/test/1/some/la");
        this.startServers(0, 1);
        BlockingConnection subConnection1 = null;
        BlockingConnection subConnection2 = null;
        BlockingConnection pubConnection = null;
        try {
            Thread.sleep(1000L);
            topics = new Topic[]{new Topic("anycast/test/1/some/la", QoS.AT_MOST_ONCE)};
            subConnection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "subClientId");
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[0]).getStateManager().getConnectedClients()::size);
            subConnection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "subClientId");
            pubConnection = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "pubClientId");
            Assertions.assertTrue((boolean)this.waitConnectionClosed(subConnection1));
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[1]).getStateManager().getConnectedClients()::size);
            subConnection1 = null;
            subConnection2.subscribe(topics);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            pubConnection.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message1.ack();
            Message message2 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message2.ack();
            Message message3 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message3.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            subConnection2.unsubscribe(new String[]{"anycast/test/1/some/la"});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, false);
            pubConnection.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message11);
            Message message21 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message21);
            Message message31 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message31);
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"anycast/test/1/some/la"};
            if (subConnection1 != null && subConnection1.isConnected()) {
                subConnection1.unsubscribe(topics2);
                subConnection1.disconnect();
            }
            if (subConnection2 != null && subConnection2.isConnected()) {
                subConnection2.unsubscribe(topics2);
                subConnection2.disconnect();
            }
            if (pubConnection != null && pubConnection.isConnected()) {
                pubConnection.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"anycast/test/1/some/la"};
        if (subConnection1 != null && subConnection1.isConnected()) {
            subConnection1.unsubscribe((String[])topics);
            subConnection1.disconnect();
        }
        if (subConnection2 != null && subConnection2.isConnected()) {
            subConnection2.unsubscribe((String[])topics);
            subConnection2.disconnect();
        }
        if (pubConnection != null && pubConnection.isConnected()) {
            pubConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useDiffClientIdAndAnycastSubscribeRemoteQueue() throws Exception {
        Object[] topics;
        String ANYCAST_TOPIC = "anycast/test/1/some/la";
        String clientId1 = "clientId1";
        String clientId2 = "clientId2";
        this.setupServers("anycast/test/1/some/la");
        this.startServers(0, 1);
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        try {
            Thread.sleep(1000L);
            topics = new Topic[]{new Topic("anycast/test/1/some/la", QoS.AT_MOST_ONCE)};
            connection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "clientId1");
            connection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "clientId2");
            connection1.subscribe(topics);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            connection2.subscribe(topics);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            connection1.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = connection1.receive(5L, TimeUnit.SECONDS);
            message1.ack();
            Message message2 = connection2.receive(5L, TimeUnit.SECONDS);
            message2.ack();
            Message message3 = connection1.receive(5L, TimeUnit.SECONDS);
            message3.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            connection2.unsubscribe(new String[]{"anycast/test/1/some/la"});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            connection1.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = connection1.receive(5L, TimeUnit.SECONDS);
            message11.ack();
            Message message21 = connection1.receive(5L, TimeUnit.SECONDS);
            message21.ack();
            Message message31 = connection1.receive(5L, TimeUnit.SECONDS);
            message31.ack();
            String message11String = new String(message11.getPayload());
            String message21String = new String(message21.getPayload());
            String message31String = new String(message31.getPayload());
            Assertions.assertTrue((payload1.equals(message11String) || payload1.equals(message21String) || payload1.equals(message31String) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload2.equals(message11String) || payload2.equals(message21String) || payload2.equals(message31String) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload3.equals(message11String) || payload3.equals(message21String) || payload3.equals(message31String) ? (byte)1 : 0) != 0);
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"anycast/test/1/some/la"};
            if (connection1 != null && connection1.isConnected()) {
                connection1.unsubscribe(topics2);
                connection1.disconnect();
            }
            if (connection2 != null && connection2.isConnected()) {
                connection2.unsubscribe(topics2);
                connection2.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"anycast/test/1/some/la"};
        if (connection1 != null && connection1.isConnected()) {
            connection1.unsubscribe((String[])topics);
            connection1.disconnect();
        }
        if (connection2 != null && connection2.isConnected()) {
            connection2.unsubscribe((String[])topics);
            connection2.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useSameClientIdAndMulticastSubscribeRemoteQueue() throws Exception {
        Object[] topics;
        String MULTICAST_TOPIC = "multicast/test/1/some/la";
        String ANYCAST_TOPIC = "anycast/test/1/some/la";
        String subClientId = "subClientId";
        String pubClientId = "pubClientId";
        this.setupServers("anycast/test/1/some/la");
        this.startServers(0, 1);
        BlockingConnection subConnection1 = null;
        BlockingConnection subConnection2 = null;
        BlockingConnection pubConnection = null;
        try {
            Thread.sleep(1000L);
            topics = new Topic[]{new Topic("multicast/test/1/some/la", QoS.AT_MOST_ONCE)};
            subConnection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "subClientId");
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[0]).getStateManager().getConnectedClients()::size);
            subConnection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "subClientId");
            pubConnection = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "pubClientId");
            Assertions.assertTrue((boolean)this.waitConnectionClosed(subConnection1));
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[1]).getStateManager().getConnectedClients()::size);
            subConnection1 = null;
            subConnection2.subscribe(topics);
            this.waitForBindings(0, "multicast/test/1/some/la", 0, 0, true);
            this.waitForBindings(1, "multicast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "multicast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "multicast/test/1/some/la", 0, 0, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            pubConnection.publish("multicast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("multicast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("multicast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message1.ack();
            Message message2 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message2.ack();
            Message message3 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message3.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            subConnection2.unsubscribe(new String[]{"multicast/test/1/some/la"});
            this.waitForBindings(0, "multicast/test/1/some/la", 0, 0, true);
            this.waitForBindings(1, "multicast/test/1/some/la", 0, 0, true);
            this.waitForBindings(0, "multicast/test/1/some/la", 0, 0, false);
            this.waitForBindings(1, "multicast/test/1/some/la", 0, 0, false);
            pubConnection.publish("multicast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("multicast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("multicast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message11);
            Message message21 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message21);
            Message message31 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message31);
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"multicast/test/1/some/la"};
            if (subConnection1 != null && subConnection1.isConnected()) {
                subConnection1.unsubscribe(topics2);
                subConnection1.disconnect();
            }
            if (subConnection2 != null && subConnection2.isConnected()) {
                subConnection2.unsubscribe(topics2);
                subConnection2.disconnect();
            }
            if (pubConnection != null && pubConnection.isConnected()) {
                pubConnection.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"multicast/test/1/some/la"};
        if (subConnection1 != null && subConnection1.isConnected()) {
            subConnection1.unsubscribe((String[])topics);
            subConnection1.disconnect();
        }
        if (subConnection2 != null && subConnection2.isConnected()) {
            subConnection2.unsubscribe((String[])topics);
            subConnection2.disconnect();
        }
        if (pubConnection != null && pubConnection.isConnected()) {
            pubConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useDiffClientIdAndMulticastSubscribeRemoteQueue() throws Exception {
        Object[] topics;
        String MULTICAST_TOPIC = "multicast/test/1/some/la";
        String ANYCAST_TOPIC = "anycast/test/1/some/la";
        String clientId1 = "clientId1";
        String clientId2 = "clientId2";
        this.setupServers("anycast/test/1/some/la");
        this.startServers(0, 1);
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        try {
            Thread.sleep(1000L);
            topics = new Topic[]{new Topic("multicast/test/1/some/la", QoS.AT_MOST_ONCE)};
            connection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "clientId1");
            connection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "clientId2");
            connection1.subscribe(topics);
            this.waitForBindings(0, "multicast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "multicast/test/1/some/la", 0, 0, true);
            this.waitForBindings(0, "multicast/test/1/some/la", 0, 0, false);
            this.waitForBindings(1, "multicast/test/1/some/la", 1, 1, false);
            connection2.subscribe(topics);
            this.waitForBindings(0, "multicast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "multicast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "multicast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "multicast/test/1/some/la", 1, 1, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            connection1.publish("multicast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("multicast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("multicast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = connection1.receive(5L, TimeUnit.SECONDS);
            message11.ack();
            Message message12 = connection1.receive(5L, TimeUnit.SECONDS);
            message12.ack();
            Message message13 = connection1.receive(5L, TimeUnit.SECONDS);
            message13.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message11.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message12.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message13.getPayload()));
            Message message21 = connection2.receive(5L, TimeUnit.SECONDS);
            message21.ack();
            Message message22 = connection2.receive(5L, TimeUnit.SECONDS);
            message22.ack();
            Message message23 = connection2.receive(5L, TimeUnit.SECONDS);
            message23.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message21.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message22.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message23.getPayload()));
            connection2.unsubscribe(new String[]{"multicast/test/1/some/la"});
            this.waitForBindings(0, "multicast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "multicast/test/1/some/la", 0, 0, true);
            this.waitForBindings(0, "multicast/test/1/some/la", 0, 0, false);
            this.waitForBindings(1, "multicast/test/1/some/la", 1, 1, false);
            connection1.publish("multicast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("multicast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("multicast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message31 = connection1.receive(5L, TimeUnit.SECONDS);
            message31.ack();
            Message message32 = connection1.receive(5L, TimeUnit.SECONDS);
            message32.ack();
            Message message33 = connection1.receive(5L, TimeUnit.SECONDS);
            message33.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message31.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message32.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message33.getPayload()));
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"multicast/test/1/some/la"};
            if (connection1 != null && connection1.isConnected()) {
                connection1.unsubscribe(topics2);
                connection1.disconnect();
            }
            if (connection2 != null && connection2.isConnected()) {
                connection2.unsubscribe(topics2);
                connection2.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"multicast/test/1/some/la"};
        if (connection1 != null && connection1.isConnected()) {
            connection1.unsubscribe((String[])topics);
            connection1.disconnect();
        }
        if (connection2 != null && connection2.isConnected()) {
            connection2.unsubscribe((String[])topics);
            connection2.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useSameClientIdAndAnycastSubscribeRemoteQueueWildCard() throws Exception {
        Object[] topics;
        String ANYCAST_TOPIC = "anycast/test/+/some/#";
        String subClientId = "subClientId";
        String pubClientId = "pubClientId";
        this.setupServers("anycast/test/+/some/#");
        this.startServers(0, 1);
        BlockingConnection subConnection1 = null;
        BlockingConnection subConnection2 = null;
        BlockingConnection pubConnection = null;
        try {
            Thread.sleep(1000L);
            topics = new Topic[]{new Topic("anycast/test/+/some/#", QoS.AT_MOST_ONCE)};
            subConnection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "subClientId");
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[0]).getStateManager().getConnectedClients()::size);
            subConnection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "subClientId");
            pubConnection = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "pubClientId");
            Assertions.assertTrue((boolean)this.waitConnectionClosed(subConnection1));
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[1]).getStateManager().getConnectedClients()::size);
            subConnection1 = null;
            subConnection2.subscribe(topics);
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 0, true);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 1, true);
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 1, false);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 0, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            pubConnection.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            subConnection2.unsubscribe(new String[]{"anycast/test/+/some/#"});
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 0, true);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 0, true);
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 0, false);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 0, false);
            pubConnection.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"anycast/test/+/some/#"};
            if (subConnection1 != null && subConnection1.isConnected()) {
                subConnection1.unsubscribe(topics2);
                subConnection1.disconnect();
            }
            if (subConnection2 != null && subConnection2.isConnected()) {
                subConnection2.unsubscribe(topics2);
                subConnection2.disconnect();
            }
            if (pubConnection != null && pubConnection.isConnected()) {
                pubConnection.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"anycast/test/+/some/#"};
        if (subConnection1 != null && subConnection1.isConnected()) {
            subConnection1.unsubscribe((String[])topics);
            subConnection1.disconnect();
        }
        if (subConnection2 != null && subConnection2.isConnected()) {
            subConnection2.unsubscribe((String[])topics);
            subConnection2.disconnect();
        }
        if (pubConnection != null && pubConnection.isConnected()) {
            pubConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useDiffClientIdAndAnycastSubscribeRemoteQueueWildCard() throws Exception {
        Object[] topics;
        String ANYCAST_TOPIC = "anycast/test/+/some/#";
        String clientId1 = "clientId1";
        String clientId2 = "clientId2";
        this.setupServers("anycast/test/+/some/#");
        this.startServers(0, 1);
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        try {
            Thread.sleep(1000L);
            topics = new Topic[]{new Topic("anycast/test/+/some/#", QoS.AT_MOST_ONCE)};
            connection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "clientId1");
            connection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "clientId2");
            connection1.subscribe(topics);
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 1, true);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 0, true);
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 0, false);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 1, false);
            connection2.subscribe(topics);
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 1, true);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 1, true);
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 1, false);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 1, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            connection1.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            connection2.unsubscribe(new String[]{"anycast/test/+/some/#"});
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 1, true);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 0, true);
            this.waitForBindings(0, "anycast/test/+/some/#", 1, 0, false);
            this.waitForBindings(1, "anycast/test/+/some/#", 1, 1, false);
            connection1.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"anycast/test/+/some/#"};
            if (connection1 != null && connection1.isConnected()) {
                connection1.unsubscribe(topics2);
                connection1.disconnect();
            }
            if (connection2 != null && connection2.isConnected()) {
                connection2.unsubscribe(topics2);
                connection2.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"anycast/test/+/some/#"};
        if (connection1 != null && connection1.isConnected()) {
            connection1.unsubscribe((String[])topics);
            connection1.disconnect();
        }
        if (connection2 != null && connection2.isConnected()) {
            connection2.unsubscribe((String[])topics);
            connection2.disconnect();
        }
    }

    MQTTProtocolManager locateMQTTPM(ActiveMQServer server) {
        RemotingServiceImpl impl = (RemotingServiceImpl)server.getRemotingService();
        for (Acceptor acceptor : impl.getAcceptors().values()) {
            AbstractAcceptor abstractAcceptor = (AbstractAcceptor)acceptor;
            for (ProtocolManager manager : abstractAcceptor.getProtocolMap().values()) {
                if (!(manager instanceof MQTTProtocolManager)) continue;
                return (MQTTProtocolManager)manager;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useSameClientIdAndMulticastSubscribeRemoteQueueWildCard() throws Exception {
        Object[] topics;
        String MULTICAST_TOPIC = "multicast/test/+/some/#";
        String ANYCAST_TOPIC = "anycast/test/+/some/#";
        String subClientId = "subClientId";
        String pubClientId = "pubClientId";
        this.setupServers("anycast/test/+/some/#");
        this.startServers(0, 1);
        BlockingConnection subConnection1 = null;
        BlockingConnection subConnection2 = null;
        BlockingConnection pubConnection = null;
        try {
            Thread.sleep(1000L);
            topics = new Topic[]{new Topic("multicast/test/+/some/#", QoS.AT_MOST_ONCE)};
            subConnection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "subClientId");
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[0]).getStateManager().getConnectedClients()::size);
            subConnection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "subClientId");
            pubConnection = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "pubClientId");
            Assertions.assertTrue((boolean)this.waitConnectionClosed(subConnection1));
            subConnection2.subscribe(topics);
            this.waitForBindings(0, "multicast/test/+/some/#", 0, 0, true);
            this.waitForBindings(1, "multicast/test/+/some/#", 1, 1, true);
            this.waitForBindings(0, "multicast/test/+/some/#", 1, 1, false);
            this.waitForBindings(1, "multicast/test/+/some/#", 0, 0, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            pubConnection.publish("multicast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("multicast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("multicast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message1.ack();
            Message message2 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message2.ack();
            Message message3 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message3.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            subConnection2.unsubscribe(new String[]{"multicast/test/+/some/#"});
            this.waitForBindings(0, "multicast/test/+/some/#", 0, 0, true);
            this.waitForBindings(1, "multicast/test/+/some/#", 0, 0, true);
            this.waitForBindings(0, "multicast/test/+/some/#", 0, 0, false);
            this.waitForBindings(1, "multicast/test/+/some/#", 0, 0, false);
            pubConnection.publish("multicast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("multicast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("multicast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message11);
            Message message21 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message21);
            Message message31 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message31);
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"multicast/test/+/some/#"};
            if (subConnection1 != null && subConnection1.isConnected()) {
                subConnection1.unsubscribe(topics2);
                subConnection1.disconnect();
            }
            if (subConnection2 != null && subConnection2.isConnected()) {
                subConnection2.unsubscribe(topics2);
                subConnection2.disconnect();
            }
            if (pubConnection != null && pubConnection.isConnected()) {
                pubConnection.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"multicast/test/+/some/#"};
        if (subConnection1 != null && subConnection1.isConnected()) {
            subConnection1.unsubscribe((String[])topics);
            subConnection1.disconnect();
        }
        if (subConnection2 != null && subConnection2.isConnected()) {
            subConnection2.unsubscribe((String[])topics);
            subConnection2.disconnect();
        }
        if (pubConnection != null && pubConnection.isConnected()) {
            pubConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useDiffClientIdAndMulticastSubscribeRemoteQueueWildCard() throws Exception {
        Object[] topics;
        String MULTICAST_TOPIC = "multicast/test/+/some/#";
        String ANYCAST_TOPIC = "anycast/test/+/some/#";
        String clientId1 = "clientId1";
        String clientId2 = "clientId2";
        this.setupServers("anycast/test/+/some/#");
        this.startServers(0, 1);
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        try {
            Thread.sleep(1000L);
            topics = new Topic[]{new Topic("multicast/test/+/some/#", QoS.AT_MOST_ONCE)};
            connection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "clientId1");
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[0]).getStateManager().getConnectedClients()::size);
            connection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "clientId2");
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[1]).getStateManager().getConnectedClients()::size);
            connection1.subscribe(topics);
            this.waitForBindings(0, "multicast/test/+/some/#", 1, 1, true);
            this.waitForBindings(1, "multicast/test/+/some/#", 0, 0, true);
            this.waitForBindings(0, "multicast/test/+/some/#", 0, 0, false);
            this.waitForBindings(1, "multicast/test/+/some/#", 1, 1, false);
            connection2.subscribe(topics);
            this.waitForBindings(0, "multicast/test/+/some/#", 1, 1, true);
            this.waitForBindings(1, "multicast/test/+/some/#", 1, 1, true);
            this.waitForBindings(0, "multicast/test/+/some/#", 1, 1, false);
            this.waitForBindings(1, "multicast/test/+/some/#", 1, 1, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            connection1.publish("multicast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("multicast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("multicast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = connection1.receive(5L, TimeUnit.SECONDS);
            message11.ack();
            Message message12 = connection1.receive(5L, TimeUnit.SECONDS);
            message12.ack();
            Message message13 = connection1.receive(5L, TimeUnit.SECONDS);
            message13.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message11.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message12.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message13.getPayload()));
            Message message21 = connection2.receive(5L, TimeUnit.SECONDS);
            message21.ack();
            Message message22 = connection2.receive(5L, TimeUnit.SECONDS);
            message22.ack();
            Message message23 = connection2.receive(5L, TimeUnit.SECONDS);
            message23.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message21.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message22.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message23.getPayload()));
            connection2.unsubscribe(new String[]{"multicast/test/+/some/#"});
            this.waitForBindings(0, "multicast/test/+/some/#", 1, 1, true);
            this.waitForBindings(1, "multicast/test/+/some/#", 0, 0, true);
            this.waitForBindings(0, "multicast/test/+/some/#", 0, 0, false);
            this.waitForBindings(1, "multicast/test/+/some/#", 1, 1, false);
            connection1.publish("multicast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("multicast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("multicast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message31 = connection1.receive(5L, TimeUnit.SECONDS);
            message31.ack();
            Message message32 = connection1.receive(5L, TimeUnit.SECONDS);
            message32.ack();
            Message message33 = connection1.receive(5L, TimeUnit.SECONDS);
            message33.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message31.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message32.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message33.getPayload()));
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"multicast/test/+/some/#"};
            if (connection1 != null && connection1.isConnected()) {
                connection1.unsubscribe(topics2);
                connection1.disconnect();
            }
            if (connection2 != null && connection2.isConnected()) {
                connection2.unsubscribe(topics2);
                connection2.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"multicast/test/+/some/#"};
        if (connection1 != null && connection1.isConnected()) {
            connection1.unsubscribe((String[])topics);
            connection1.disconnect();
        }
        if (connection2 != null && connection2.isConnected()) {
            connection2.unsubscribe((String[])topics);
            connection2.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useDiffClientIdSubscribeRemoteQueueMultipleSubscriptions() throws Exception {
        String ANYCAST_TOPIC = "anycast/test/1/some/la";
        String TOPIC2 = "sample";
        String clientId1 = "clientId1";
        String clientId2 = "clientId2";
        this.setupServers("anycast/test/1/some/la");
        this.startServers(0, 1);
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        try {
            Thread.sleep(1000L);
            connection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "clientId1");
            connection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "clientId2");
            connection1.subscribe(new Topic[]{new Topic("anycast/test/1/some/la", QoS.AT_MOST_ONCE)});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            connection2.subscribe(new Topic[]{new Topic("anycast/test/1/some/la", QoS.AT_MOST_ONCE), new Topic("sample", QoS.AT_MOST_ONCE)});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            String payload4 = "This is message 4";
            connection1.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("sample", payload4.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = connection1.receive(5L, TimeUnit.SECONDS);
            message1.ack();
            Message message2 = connection2.receive(5L, TimeUnit.SECONDS);
            message2.ack();
            Message message3 = connection1.receive(5L, TimeUnit.SECONDS);
            message3.ack();
            Message message4 = connection2.receive(5L, TimeUnit.SECONDS);
            message4.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            Assertions.assertEquals((Object)payload4, (Object)new String(message4.getPayload()));
            connection2.unsubscribe(new String[]{"anycast/test/1/some/la"});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            connection1.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("sample", payload4.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = connection1.receive(5L, TimeUnit.SECONDS);
            message11.ack();
            Message message21 = connection1.receive(5L, TimeUnit.SECONDS);
            message21.ack();
            Message message31 = connection1.receive(5L, TimeUnit.SECONDS);
            message31.ack();
            Message message41 = connection2.receive(5L, TimeUnit.SECONDS);
            message41.ack();
            String message11String = new String(message31.getPayload());
            String message21String = new String(message21.getPayload());
            String message31String = new String(message11.getPayload());
            Assertions.assertTrue((payload1.equals(message11String) || payload1.equals(message21String) || payload1.equals(message31String) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload2.equals(message11String) || payload2.equals(message21String) || payload2.equals(message31String) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload3.equals(message11String) || payload3.equals(message21String) || payload3.equals(message31String) ? (byte)1 : 0) != 0);
            Assertions.assertEquals((Object)payload4, (Object)new String(message41.getPayload()));
        }
        catch (Throwable throwable) {
            if (connection1 != null && connection1.isConnected()) {
                connection1.unsubscribe(new String[]{"anycast/test/1/some/la"});
                connection1.disconnect();
            }
            if (connection2 != null && connection2.isConnected()) {
                connection2.unsubscribe(new String[]{"anycast/test/1/some/la", "sample"});
                connection2.disconnect();
            }
            throw throwable;
        }
        if (connection1 != null && connection1.isConnected()) {
            connection1.unsubscribe(new String[]{"anycast/test/1/some/la"});
            connection1.disconnect();
        }
        if (connection2 != null && connection2.isConnected()) {
            connection2.unsubscribe(new String[]{"anycast/test/1/some/la", "sample"});
            connection2.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useSameClientIdSubscribeRemoteQueueMultipleSubscriptions() throws Exception {
        String ANYCAST_TOPIC = "anycast/test/1/some/la";
        String TOPIC2 = "sample";
        String subClientId = "subClientId";
        String pubClientId = "pubClientId";
        this.setupServers("anycast/test/1/some/la");
        this.startServers(0, 1);
        BlockingConnection subConnection1 = null;
        BlockingConnection subConnection2 = null;
        BlockingConnection pubConnection = null;
        try {
            Thread.sleep(1000L);
            subConnection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "subClientId");
            Wait.assertEquals((int)1, this.locateMQTTPM(this.servers[0]).getStateManager().getConnectedClients()::size);
            subConnection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "subClientId");
            pubConnection = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "pubClientId");
            Assertions.assertTrue((boolean)this.waitConnectionClosed(subConnection1));
            subConnection2.subscribe(new Topic[]{new Topic("anycast/test/1/some/la", QoS.AT_MOST_ONCE), new Topic("sample", QoS.AT_MOST_ONCE)});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            String payload4 = "This is message 4";
            pubConnection.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("sample", payload4.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message1.ack();
            Message message2 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message2.ack();
            Message message3 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message3.ack();
            Message message4 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message4.ack();
            String messageStr1 = new String(message1.getPayload());
            String messageStr2 = new String(message2.getPayload());
            String messageStr3 = new String(message3.getPayload());
            String messageStr4 = new String(message4.getPayload());
            Assertions.assertTrue((payload1.equals(messageStr1) || payload1.equals(messageStr2) || payload1.equals(messageStr3) || payload1.equals(messageStr4) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload2.equals(messageStr1) || payload2.equals(messageStr2) || payload2.equals(messageStr3) || payload2.equals(messageStr4) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload3.equals(messageStr1) || payload3.equals(messageStr2) || payload3.equals(messageStr3) || payload3.equals(messageStr4) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload4.equals(messageStr1) || payload4.equals(messageStr2) || payload4.equals(messageStr3) || payload4.equals(messageStr4) ? (byte)1 : 0) != 0);
            subConnection2.unsubscribe(new String[]{"anycast/test/1/some/la"});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, false);
            pubConnection.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("sample", payload4.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = subConnection2.receive(5L, TimeUnit.SECONDS);
            message11.ack();
            Assertions.assertEquals((Object)payload4, (Object)new String(message11.getPayload()));
            Message message21 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message21);
            Message message31 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message31);
            Message message41 = subConnection2.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message41);
        }
        catch (Throwable throwable) {
            if (subConnection1 != null && subConnection1.isConnected()) {
                subConnection1.unsubscribe(new String[]{"anycast/test/1/some/la"});
                subConnection1.disconnect();
            }
            if (subConnection2 != null && subConnection2.isConnected()) {
                subConnection2.unsubscribe(new String[]{"anycast/test/1/some/la", "sample"});
                subConnection2.disconnect();
            }
            if (pubConnection != null && pubConnection.isConnected()) {
                pubConnection.disconnect();
            }
            throw throwable;
        }
        if (subConnection1 != null && subConnection1.isConnected()) {
            subConnection1.unsubscribe(new String[]{"anycast/test/1/some/la"});
            subConnection1.disconnect();
        }
        if (subConnection2 != null && subConnection2.isConnected()) {
            subConnection2.unsubscribe(new String[]{"anycast/test/1/some/la", "sample"});
            subConnection2.disconnect();
        }
        if (pubConnection != null && pubConnection.isConnected()) {
            pubConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useSameClientIdSubscribeExistingQueue() throws Exception {
        Object[] topics;
        String ANYCAST_TOPIC = "anycast/test/1/some/la";
        String subClientId = "subClientId";
        String pubClientId = "pubClientId";
        this.setupServers("anycast/test/1/some/la");
        this.startServers(0, 1);
        BlockingConnection subConnection1 = null;
        BlockingConnection subConnection2 = null;
        BlockingConnection subConnection3 = null;
        BlockingConnection pubConnection = null;
        try {
            Thread.sleep(1000L);
            pubConnection = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "pubClientId");
            subConnection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "subClientId");
            Wait.assertEquals((int)2, this.locateMQTTPM(this.servers[0]).getStateManager().getConnectedClients()::size);
            subConnection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "subClientId");
            Assertions.assertTrue((boolean)this.waitConnectionClosed(subConnection1));
            subConnection3 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "subClientId");
            Assertions.assertTrue((boolean)this.waitConnectionClosed(subConnection1));
            topics = new Topic[]{new Topic("anycast/test/1/some/la", QoS.AT_MOST_ONCE)};
            subConnection3.subscribe(topics);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            String payload4 = "This is message 4";
            pubConnection.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload4.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = subConnection3.receive(5L, TimeUnit.SECONDS);
            message1.ack();
            Message message2 = subConnection3.receive(5L, TimeUnit.SECONDS);
            message2.ack();
            Message message3 = subConnection3.receive(5L, TimeUnit.SECONDS);
            message3.ack();
            Message message4 = subConnection3.receive(5L, TimeUnit.SECONDS);
            message4.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            Assertions.assertEquals((Object)payload4, (Object)new String(message4.getPayload()));
            subConnection3.unsubscribe(new String[]{"anycast/test/1/some/la"});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, false);
            pubConnection.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            pubConnection.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = subConnection3.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message11);
            Message message21 = subConnection3.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message21);
            Message message31 = subConnection3.receive(100L, TimeUnit.MILLISECONDS);
            Assertions.assertNull((Object)message31);
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"anycast/test/1/some/la"};
            if (subConnection1 != null && subConnection1.isConnected()) {
                subConnection1.unsubscribe(topics2);
                subConnection1.disconnect();
            }
            if (subConnection2 != null && subConnection2.isConnected()) {
                subConnection2.unsubscribe(topics2);
                subConnection2.disconnect();
            }
            if (subConnection3 != null && subConnection3.isConnected()) {
                subConnection3.unsubscribe(topics2);
                subConnection3.disconnect();
            }
            if (pubConnection != null && pubConnection.isConnected()) {
                pubConnection.unsubscribe(topics2);
                pubConnection.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"anycast/test/1/some/la"};
        if (subConnection1 != null && subConnection1.isConnected()) {
            subConnection1.unsubscribe((String[])topics);
            subConnection1.disconnect();
        }
        if (subConnection2 != null && subConnection2.isConnected()) {
            subConnection2.unsubscribe((String[])topics);
            subConnection2.disconnect();
        }
        if (subConnection3 != null && subConnection3.isConnected()) {
            subConnection3.unsubscribe((String[])topics);
            subConnection3.disconnect();
        }
        if (pubConnection != null && pubConnection.isConnected()) {
            pubConnection.unsubscribe((String[])topics);
            pubConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void useDiffClientIdSubscribeExistingQueue() throws Exception {
        Object[] topics;
        String ANYCAST_TOPIC = "anycast/test/1/some/la";
        String clientId1 = "clientId1";
        String clientId2 = "clientId2";
        String clientId3 = "clientId3";
        this.setupServers("anycast/test/1/some/la");
        this.startServers(0, 1);
        BlockingConnection connection1 = null;
        BlockingConnection connection2 = null;
        BlockingConnection connection3 = null;
        try {
            Thread.sleep(1000L);
            connection1 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61616", "clientId1");
            connection2 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "clientId2");
            connection3 = MqttClusterRemoteSubscribeTest.retrieveMQTTConnection("tcp://localhost:61617", "clientId3");
            topics = new Topic[]{new Topic("anycast/test/1/some/la", QoS.AT_MOST_ONCE)};
            connection1.subscribe(topics);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 0, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 0, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            connection2.subscribe(topics);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            connection3.subscribe(topics);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 2, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 2, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            String payload1 = "This is message 1";
            String payload2 = "This is message 2";
            String payload3 = "This is message 3";
            String payload4 = "This is message 4";
            connection1.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload4.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message1 = connection1.receive(5L, TimeUnit.SECONDS);
            message1.ack();
            Message message2 = connection2.receive(5L, TimeUnit.SECONDS);
            message2.ack();
            Message message3 = connection1.receive(5L, TimeUnit.SECONDS);
            message3.ack();
            Message message4 = connection3.receive(5L, TimeUnit.SECONDS);
            message4.ack();
            Assertions.assertEquals((Object)payload1, (Object)new String(message1.getPayload()));
            Assertions.assertEquals((Object)payload2, (Object)new String(message2.getPayload()));
            Assertions.assertEquals((Object)payload3, (Object)new String(message3.getPayload()));
            Assertions.assertEquals((Object)payload4, (Object)new String(message4.getPayload()));
            connection2.unsubscribe(new String[]{"anycast/test/1/some/la"});
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, true);
            this.waitForBindings(0, "anycast/test/1/some/la", 1, 1, false);
            this.waitForBindings(1, "anycast/test/1/some/la", 1, 1, false);
            connection1.publish("anycast/test/1/some/la", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
            connection1.publish("anycast/test/1/some/la", payload3.getBytes(), QoS.AT_MOST_ONCE, false);
            Message message11 = connection1.receive(5L, TimeUnit.SECONDS);
            message11.ack();
            Message message21 = connection3.receive(5L, TimeUnit.SECONDS);
            message21.ack();
            Message message31 = connection1.receive(5L, TimeUnit.SECONDS);
            message31.ack();
            String message11String = new String(message11.getPayload());
            String message21String = new String(message21.getPayload());
            String message31String = new String(message31.getPayload());
            Assertions.assertTrue((payload1.equals(message11String) || payload1.equals(message21String) || payload1.equals(message31String) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload2.equals(message11String) || payload2.equals(message21String) || payload2.equals(message31String) ? (byte)1 : 0) != 0);
            Assertions.assertTrue((payload3.equals(message11String) || payload3.equals(message21String) || payload3.equals(message31String) ? (byte)1 : 0) != 0);
        }
        catch (Throwable throwable) {
            String[] topics2 = new String[]{"anycast/test/1/some/la"};
            if (connection1 != null && connection1.isConnected()) {
                connection1.unsubscribe(topics2);
                connection1.disconnect();
            }
            if (connection2 != null && connection2.isConnected()) {
                connection2.unsubscribe(topics2);
                connection2.disconnect();
            }
            if (connection3 != null && connection3.isConnected()) {
                connection3.unsubscribe(topics2);
                connection3.disconnect();
            }
            throw throwable;
        }
        topics = new String[]{"anycast/test/1/some/la"};
        if (connection1 != null && connection1.isConnected()) {
            connection1.unsubscribe((String[])topics);
            connection1.disconnect();
        }
        if (connection2 != null && connection2.isConnected()) {
            connection2.unsubscribe((String[])topics);
            connection2.disconnect();
        }
        if (connection3 != null && connection3.isConnected()) {
            connection3.unsubscribe((String[])topics);
            connection3.disconnect();
        }
    }

    private static BlockingConnection retrieveMQTTConnection(String host, String clientId) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setHost(host);
        mqtt.setClientId(clientId);
        mqtt.setConnectAttemptsMax(0L);
        mqtt.setReconnectAttemptsMax(0L);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        return connection;
    }

    private void setupServers(String TOPIC) throws Exception {
        WildcardConfiguration wildcardConfiguration = this.createWildCardConfiguration();
        CoreAddressConfiguration coreAddressConfiguration = this.createAddressConfiguration(TOPIC);
        AddressSettings addressSettings = this.createAddressSettings();
        this.setupServer(0, false, this.isNetty());
        this.servers[0].getConfiguration().setWildCardConfiguration(wildcardConfiguration);
        this.servers[0].getConfiguration().addAddressConfiguration(coreAddressConfiguration);
        this.servers[0].getConfiguration().addAddressSetting("#", addressSettings);
        this.setupServer(1, false, this.isNetty());
        this.servers[1].getConfiguration().setWildCardConfiguration(wildcardConfiguration);
        this.servers[1].getConfiguration().addAddressConfiguration(coreAddressConfiguration);
        this.servers[1].getConfiguration().addAddressSetting("#", addressSettings);
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
    }

    private AddressSettings createAddressSettings() {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setRedistributionDelay(0L);
        addressSettings.setDefaultAddressRoutingType(RoutingType.ANYCAST);
        return addressSettings;
    }

    private CoreAddressConfiguration createAddressConfiguration(String TOPIC) {
        CoreAddressConfiguration coreAddressConfiguration = new CoreAddressConfiguration();
        coreAddressConfiguration.addRoutingType(RoutingType.ANYCAST);
        coreAddressConfiguration.setName(TOPIC);
        coreAddressConfiguration.addQueueConfiguration(QueueConfiguration.of((String)TOPIC).setRoutingType(RoutingType.ANYCAST));
        return coreAddressConfiguration;
    }

    private WildcardConfiguration createWildCardConfiguration() {
        WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
        wildcardConfiguration.setAnyWords('#');
        wildcardConfiguration.setDelimiter('/');
        wildcardConfiguration.setRoutingEnabled(true);
        wildcardConfiguration.setSingleWord('+');
        return wildcardConfiguration;
    }

    private boolean waitConnectionClosed(BlockingConnection connection) throws Exception {
        return Wait.waitFor(() -> !connection.isConnected());
    }
}

