/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class DisconnectTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testDisconnectReasonCode() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.DISCONNECT) {
                System.out.println(packet);
                Assertions.assertEquals((byte)-114, (byte)((MqttReasonCodeAndPropertiesVariableHeader)packet.variableHeader()).reasonCode());
                Assertions.assertNull((Object)((MqttReasonCodeAndPropertiesVariableHeader)packet.variableHeader()).properties().getProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value()));
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient publisher1 = this.createPahoClient("publisher");
        publisher1.connect();
        MqttClient publisher2 = this.createPahoClient("publisher");
        publisher2.connect();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        publisher2.disconnect();
        publisher2.close();
    }

    @Test
    @Timeout(value=60L)
    public void testWillMessageRemovedOnDisconnect() throws Exception {
        String CLIENT_ID = RandomUtil.randomString();
        byte[] WILL = RandomUtil.randomBytes();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().will("/topic/foo", new MqttMessage(WILL)).build();
        client.connect(options);
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID).getWillMessage());
        client.disconnect();
        Assertions.assertNull((Object)this.getSessionStates().get(CLIENT_ID));
        client.close();
    }
}

