/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.eclipse.paho.mqttv5.common.packet.MqttSubAck;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class SubAckTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testSubscribeAck() throws Exception {
        int i;
        int SUBSCRIPTION_COUNT = 30;
        String TOPIC = RandomUtil.randomString();
        SimpleString[] topicNames = new SimpleString[30];
        for (int i2 = 0; i2 < 30; ++i2) {
            topicNames[i2] = SimpleString.of((String)(i2 + "-" + TOPIC));
        }
        MqttAsyncClient consumer = this.createAsyncPahoClient("consumer");
        consumer.connect().waitForCompletion();
        MqttSubscription[] subscriptions = new MqttSubscription[30];
        for (int i3 = 0; i3 < 30; ++i3) {
            subscriptions[i3] = new MqttSubscription(topicNames[i3].toString(), RandomUtil.randomInterval((int)0, (int)3));
        }
        IMqttToken token = consumer.subscribe(subscriptions);
        token.waitForCompletion();
        MqttSubAck response = (MqttSubAck)token.getResponse();
        Assertions.assertEquals((int)subscriptions.length, (int)response.getReturnCodes().length);
        for (i = 0; i < response.getReturnCodes().length; ++i) {
            Assertions.assertEquals((int)subscriptions[i].getQos(), (int)response.getReturnCodes()[i]);
        }
        for (i = 0; i < 30; ++i) {
            Assertions.assertTrue((boolean)this.server.getPostOffice().isAddressBound(topicNames[i]));
        }
        consumer.disconnect();
        consumer.close();
    }
}

