/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class UnsubscribeTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testUnsubscribe() throws Exception {
        int i;
        int i2;
        int SUBSCRIPTION_COUNT = 30;
        String TOPIC = RandomUtil.randomString();
        AtomicInteger unsubAckCount = new AtomicInteger(0);
        SimpleString[] topicNames = new SimpleString[30];
        for (int i3 = 0; i3 < 30; ++i3) {
            topicNames[i3] = SimpleString.of((String)(i3 + "-" + TOPIC));
        }
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.UNSUBACK) {
                unsubAckCount.incrementAndGet();
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        MqttSubscription[] subscriptions = new MqttSubscription[30];
        for (i2 = 0; i2 < 30; ++i2) {
            subscriptions[i2] = new MqttSubscription(topicNames[i2].toString(), 0);
        }
        consumer.subscribe(subscriptions);
        for (i2 = 0; i2 < 30; ++i2) {
            Assertions.assertTrue((boolean)this.server.getPostOffice().isAddressBound(topicNames[i2]));
        }
        String[] unsubTopicNames = new String[15];
        for (i = 0; i < 15; ++i) {
            unsubTopicNames[i] = topicNames[i].toString();
        }
        consumer.unsubscribe(unsubTopicNames);
        for (i = 0; i < 15; ++i) {
            Assertions.assertFalse((boolean)this.server.getPostOffice().isAddressBound(topicNames[i]));
        }
        for (i = 15; i < 30; ++i) {
            Assertions.assertTrue((boolean)this.server.getPostOffice().isAddressBound(topicNames[i]));
        }
        Assertions.assertEquals((int)1, (int)unsubAckCount.get());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testStopAddingMessagesOnUnsubscribe() throws Exception {
        String TOPIC = RandomUtil.randomString();
        MqttClient consumer1 = this.createPahoClient("consumer1");
        consumer1.connect();
        consumer1.subscribe(TOPIC, 0);
        MqttClient consumer2 = this.createPahoClient("consumer2");
        consumer2.connect();
        consumer2.subscribe(TOPIC, 0);
        Queue consumer1SubscriptionQueue = this.getSubscriptionQueue(TOPIC, "consumer1");
        Queue consumer2SubscriptionQueue = this.getSubscriptionQueue(TOPIC, "consumer2");
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, new byte[0], 0, false);
        Wait.assertEquals((Long)1L, () -> consumer1SubscriptionQueue.getMessagesAdded(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> consumer2SubscriptionQueue.getMessagesAdded(), (long)2000L, (long)100L);
        consumer2.unsubscribe(TOPIC);
        producer.publish(TOPIC, new byte[0], 0, false);
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)2L, () -> consumer1SubscriptionQueue.getMessagesAdded(), (long)2000L, (long)100L);
        Wait.assertTrue(() -> this.getSubscriptionQueue(TOPIC, "consumer2") == null);
        consumer1.disconnect();
        consumer1.close();
        consumer2.disconnect();
        consumer2.close();
    }

    @Test
    @Timeout(value=60L)
    public void testUnsubAck() throws Exception {
        String TOPIC = RandomUtil.randomString();
        AtomicBoolean unsubscribed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.UNSUBSCRIBE) {
                unsubscribed.set(true);
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (unsubscribed.get() && packet.fixedHeader().messageType() == MqttMessageType.UNSUBACK) {
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.subscribe(TOPIC, 0);
        consumer.unsubscribe(TOPIC);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testUnsubAckPacketId() throws Exception {
        String TOPIC = RandomUtil.randomString();
        AtomicBoolean unsubscribed = new AtomicBoolean(false);
        AtomicInteger packetId = new AtomicInteger(0);
        CountDownLatch latch = new CountDownLatch(1);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.UNSUBSCRIBE) {
                unsubscribed.set(true);
                packetId.set(((MqttMessageIdAndPropertiesVariableHeader)packet.variableHeader()).messageId());
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (unsubscribed.get() && packet.fixedHeader().messageType() == MqttMessageType.UNSUBACK) {
                Assertions.assertEquals((int)packetId.get(), (int)((MqttMessageIdAndPropertiesVariableHeader)packet.variableHeader()).messageId());
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.subscribe(TOPIC, 0);
        consumer.unsubscribe(TOPIC);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }
}

