/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.ServerSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BasicSecurityTest
extends BasicOpenWireTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.enableSecurity = true;
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionWithCredentials() throws Exception {
        try (Connection newConn = null;){
            newConn = this.factory.createConnection("openwireSender", "SeNdEr");
            newConn.start();
            newConn.close();
            newConn = this.factory.createConnection("openwireReceiver", "ReCeIvEr");
            newConn.start();
            newConn.close();
            newConn = null;
        }
        try {
            newConn = this.factory.createConnection("openwireSender", "WrongPasswD");
            newConn.start();
        }
        catch (JMSSecurityException jMSSecurityException) {
        }
        finally {
            if (newConn != null) {
                newConn.close();
            }
        }
        try {
            newConn = this.factory.createConnection("wronguser", "SeNdEr");
            newConn.start();
        }
        catch (JMSSecurityException jMSSecurityException) {
        }
        finally {
            if (newConn != null) {
                newConn.close();
            }
        }
        try {
            newConn = this.factory.createConnection("wronguser", "wrongpass");
            newConn.start();
        }
        catch (JMSSecurityException jMSSecurityException) {
        }
        finally {
            if (newConn != null) {
                newConn.close();
            }
        }
        try {
            newConn = this.factory.createConnection();
            newConn.start();
        }
        catch (JMSSecurityException jMSSecurityException) {
        }
        finally {
            if (newConn != null) {
                newConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendnReceiveAuthorization() throws Exception {
        Connection sendingConn = null;
        Connection receivingConn = null;
        try {
            MessageConsumer consumer;
            ActiveMQQueue dest = new ActiveMQQueue(this.queueName);
            receivingConn = this.factory.createConnection("openwireReceiver", "ReCeIvEr");
            receivingConn.start();
            sendingConn = this.factory.createConnection("openwireSender", "SeNdEr");
            sendingConn.start();
            Session sendingSession = sendingConn.createSession(false, 1);
            Session receivingSession = receivingConn.createSession(false, 1);
            TextMessage message = sendingSession.createTextMessage("Hello World");
            MessageProducer producer = null;
            try {
                receivingSession.createProducer((Destination)dest);
                Assertions.fail((String)"Should not be able to create a producer when not authorized to send");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
            producer = receivingSession.createProducer(null);
            try {
                producer.send((Destination)dest, (Message)message);
                Assertions.fail((String)"exception expected");
            }
            catch (JMSSecurityException e) {
                producer.close();
            }
            producer = sendingSession.createProducer((Destination)dest);
            producer.send((Message)message);
            try {
                consumer = sendingSession.createConsumer((Destination)dest);
                Assertions.fail((String)"exception expected");
            }
            catch (JMSSecurityException e) {
                e.printStackTrace();
            }
            consumer = receivingSession.createConsumer((Destination)dest);
            TextMessage received = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((Object)"Hello World", (Object)received.getText());
        }
        finally {
            if (sendingConn != null) {
                sendingConn.close();
            }
            if (receivingConn != null) {
                receivingConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendReceiveAuthorizationOnComposite() throws Exception {
        Connection sendingConn = null;
        Connection receivingConn = null;
        String compositeName = this.queueName + "," + this.queueName2;
        try {
            ActiveMQQueue composite = new ActiveMQQueue(compositeName);
            ActiveMQQueue dest1 = new ActiveMQQueue(this.queueName);
            ActiveMQQueue dest2 = new ActiveMQQueue(this.queueName2);
            this.server.createQueue(QueueConfiguration.of((String)compositeName).setAddress(compositeName).setRoutingType(RoutingType.ANYCAST));
            receivingConn = this.factory.createConnection("openwireReceiver", "ReCeIvEr");
            receivingConn.start();
            sendingConn = this.factory.createConnection("openwireSender", "SeNdEr");
            sendingConn.start();
            Session sendingSession = sendingConn.createSession(false, 1);
            Session receivingSession = receivingConn.createSession(false, 1);
            TextMessage message = sendingSession.createTextMessage("Hello World");
            MessageProducer producer = null;
            try {
                receivingSession.createProducer((Destination)composite);
                Assertions.fail((String)"Should get a security exception on create");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
            producer = receivingSession.createProducer(null);
            try {
                producer.send((Destination)composite, (Message)message);
                Assertions.fail((String)"exception expected");
            }
            catch (JMSSecurityException e) {
                producer.close();
            }
            producer = sendingSession.createProducer((Destination)composite);
            producer.send((Message)message);
            try {
                sendingSession.createConsumer((Destination)dest1);
                Assertions.fail((String)"exception expected");
            }
            catch (JMSSecurityException e) {
                e.printStackTrace();
            }
            MessageConsumer consumer1 = receivingSession.createConsumer((Destination)dest1);
            TextMessage received1 = (TextMessage)consumer1.receive(5000L);
            MessageConsumer consumer2 = receivingSession.createConsumer((Destination)dest2);
            TextMessage received2 = (TextMessage)consumer2.receive(5000L);
            Assertions.assertNotNull((Object)received1);
            Assertions.assertEquals((Object)"Hello World", (Object)received1.getText());
            Assertions.assertNotNull((Object)received2);
            Assertions.assertEquals((Object)"Hello World", (Object)received2.getText());
        }
        finally {
            if (sendingConn != null) {
                sendingConn.close();
            }
            if (receivingConn != null) {
                receivingConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTempDestinationAuthorization() throws Exception {
        Connection conn1 = null;
        Connection conn2 = null;
        try {
            conn1 = this.factory.createConnection("openwireGuest", "GuEsT");
            conn1.start();
            conn2 = this.factory.createConnection("openwireDestinationManager", "DeStInAtIoN");
            conn2.start();
            Session session1 = conn1.createSession(false, 1);
            try {
                session1.createTemporaryQueue();
                Assertions.fail((String)"user shouldn't be able to create temp queue");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
            Session session2 = conn2.createSession(false, 1);
            TemporaryQueue q = session2.createTemporaryQueue();
            Assertions.assertNotNull((Object)q);
        }
        finally {
            if (conn1 != null) {
                conn1.close();
            }
            if (conn2 != null) {
                conn2.close();
            }
        }
    }

    @Test
    public void testConnectionConsumer() throws Exception {
        try (Connection conn1 = null;){
            conn1 = this.factory.createConnection("openwireGuest", "GuEsT");
            conn1.start();
            try {
                ActiveMQQueue dest = new ActiveMQQueue(this.queueName);
                conn1.createConnectionConsumer((Destination)dest, null, () -> new ServerSession(){

                    public Session getSession() throws JMSException {
                        return new Session(){

                            public BytesMessage createBytesMessage() throws JMSException {
                                return null;
                            }

                            public MapMessage createMapMessage() throws JMSException {
                                return null;
                            }

                            public Message createMessage() throws JMSException {
                                return null;
                            }

                            public ObjectMessage createObjectMessage() throws JMSException {
                                return null;
                            }

                            public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
                                return null;
                            }

                            public StreamMessage createStreamMessage() throws JMSException {
                                return null;
                            }

                            public TextMessage createTextMessage() throws JMSException {
                                return null;
                            }

                            public TextMessage createTextMessage(String text) throws JMSException {
                                return null;
                            }

                            public boolean getTransacted() throws JMSException {
                                return false;
                            }

                            public int getAcknowledgeMode() throws JMSException {
                                return 0;
                            }

                            public void commit() throws JMSException {
                            }

                            public void rollback() throws JMSException {
                            }

                            public void close() throws JMSException {
                            }

                            public void recover() throws JMSException {
                            }

                            public MessageListener getMessageListener() throws JMSException {
                                return null;
                            }

                            public void setMessageListener(MessageListener listener) throws JMSException {
                            }

                            public void run() {
                            }

                            public MessageProducer createProducer(Destination destination) throws JMSException {
                                return null;
                            }

                            public MessageConsumer createConsumer(Destination destination) throws JMSException {
                                return null;
                            }

                            public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
                                return null;
                            }

                            public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
                                return null;
                            }

                            public Queue createQueue(String queueName) throws JMSException {
                                return null;
                            }

                            public Topic createTopic(String topicName) throws JMSException {
                                return null;
                            }

                            public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
                                return null;
                            }

                            public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
                                return null;
                            }

                            public QueueBrowser createBrowser(Queue queue) throws JMSException {
                                return null;
                            }

                            public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
                                return null;
                            }

                            public TemporaryQueue createTemporaryQueue() throws JMSException {
                                return null;
                            }

                            public TemporaryTopic createTemporaryTopic() throws JMSException {
                                return null;
                            }

                            public void unsubscribe(String name) throws JMSException {
                            }

                            public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
                                return null;
                            }

                            public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
                                return null;
                            }

                            public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
                                return null;
                            }

                            public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
                                return null;
                            }

                            public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
                                return null;
                            }

                            public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
                                return null;
                            }
                        };
                    }

                    public void start() throws JMSException {
                    }
                }, 100);
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }
}

