/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Set;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VirtualTopicToFQQNOpenWireTest
extends OpenWireTestBase {
    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        Set acceptors = serverConfig.getAcceptorConfigurations();
        for (TransportConfiguration tc : acceptors) {
            if (!tc.getName().equals("netty")) continue;
            tc.getExtraParams().put("virtualTopicConsumerWildcards", "Consumer.*.>;2,C.*.>;2;selectorAware=true");
            tc.getExtraParams().put("virtualTopicConsumerLruCacheMax", "10000");
        }
        serverConfig.setJMXManagementEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoVirtualTopicFQQN() throws Exception {
        Connection connection = null;
        SimpleString topic = SimpleString.of((String)"VirtualTopic.Orders");
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateAddresses(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoDeleteQueues(Boolean.valueOf(false));
        try {
            ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
            activeMQConnectionFactory.setWatchTopicAdvisories(false);
            connection = activeMQConnectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(topic.toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)session.createQueue("Consumer.A." + topic.toString()));
            MessageConsumer messageConsumerB = session.createConsumer((Destination)session.createQueue("Consumer.B." + topic.toString()));
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerB.receive(2000L);
            Assertions.assertTrue((messageReceivedA != null && messageReceivedB != null ? (byte)1 : 0) != 0);
            String text = messageReceivedA.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            messageConsumerA.close();
            messageConsumerB.close();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoTopicSubsSameNameAutoVirtualTopicFQQN() throws Exception {
        Connection connection = null;
        SimpleString topic1 = SimpleString.of((String)"VirtualTopic.Orders1");
        SimpleString topic2 = SimpleString.of((String)"VirtualTopic.Orders2");
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateAddresses(Boolean.valueOf(true));
        try {
            ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
            activeMQConnectionFactory.setWatchTopicAdvisories(false);
            connection = activeMQConnectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic destination1 = session.createTopic(topic1.toString());
            Topic destination2 = session.createTopic(topic2.toString());
            MessageConsumer messageConsumer1 = session.createConsumer((Destination)session.createQueue("Consumer.A." + topic1.toString()));
            MessageConsumer messageConsumer2 = session.createConsumer((Destination)session.createQueue("Consumer.A." + topic2.toString()));
            MessageProducer producer = session.createProducer(null);
            TextMessage message = session.createTextMessage("This is a text message to 1");
            producer.send((Destination)destination1, (Message)message);
            message = session.createTextMessage("This is a text message to 2");
            producer.send((Destination)destination2, (Message)message);
            TextMessage messageReceived1 = (TextMessage)messageConsumer1.receive(2000L);
            TextMessage messageReceived2 = (TextMessage)messageConsumer2.receive(2000L);
            Assertions.assertNotNull((Object)messageReceived1);
            Assertions.assertNotNull((Object)messageReceived2);
            String text = messageReceived1.getText();
            Assertions.assertEquals((Object)"This is a text message to 1", (Object)text);
            text = messageReceived2.getText();
            Assertions.assertEquals((Object)"This is a text message to 2", (Object)text);
            messageConsumer1.close();
            messageConsumer2.close();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoVirtualTopicWildcardFQQN() throws Exception {
        Connection connection = null;
        SimpleString topicA = SimpleString.of((String)"VirtualTopic.Orders.A");
        SimpleString topicB = SimpleString.of((String)"VirtualTopic.Orders.B");
        SimpleString topic = SimpleString.of((String)"VirtualTopic.Orders.>");
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateAddresses(Boolean.valueOf(true));
        try {
            ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
            activeMQConnectionFactory.setWatchTopicAdvisories(false);
            connection = activeMQConnectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(topicA.toString() + "," + topicB.toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)session.createQueue("Consumer.A." + topic.toString()));
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerA.receive(2000L);
            Assertions.assertTrue((messageReceivedA != null && messageReceivedB != null ? (byte)1 : 0) != 0);
            String text = messageReceivedA.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            messageConsumerA.close();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoVirtualTopicWildcardStarFQQN() throws Exception {
        Connection connection = null;
        SimpleString topicA = SimpleString.of((String)"VirtualTopic.Orders.A");
        SimpleString topicB = SimpleString.of((String)"VirtualTopic.Orders.B");
        SimpleString topic = SimpleString.of((String)"VirtualTopic.Orders.*");
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateAddresses(Boolean.valueOf(true));
        try {
            ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
            activeMQConnectionFactory.setWatchTopicAdvisories(false);
            connection = activeMQConnectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(topicA.toString() + "," + topicB.toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)session.createQueue("Consumer.A." + topic.toString()));
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerA.receive(2000L);
            Assertions.assertTrue((messageReceivedA != null && messageReceivedB != null ? (byte)1 : 0) != 0);
            String text = messageReceivedA.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            messageConsumerA.close();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectorAwareVT() throws Exception {
        Connection connection = null;
        SimpleString topic = SimpleString.of((String)"SVT.Orders.A");
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("SVT.#")).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("SVT.#")).setAutoCreateAddresses(Boolean.valueOf(true));
        try {
            ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
            activeMQConnectionFactory.setWatchTopicAdvisories(false);
            connection = activeMQConnectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(topic.toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)session.createQueue("C.A." + topic.toString()), "stuff = 'A'");
            MessageConsumer messageConsumerB = session.createConsumer((Destination)session.createQueue("C.B." + topic.toString()), "stuff = 'B'");
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage("This is a text message");
            for (String stuffValue : new String[]{"A", "B", "C"}) {
                message.setStringProperty("stuff", stuffValue);
                producer.send((Message)message);
            }
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerB.receive(2000L);
            Assertions.assertTrue((messageReceivedA != null && messageReceivedB != null ? (byte)1 : 0) != 0);
            String text = messageReceivedA.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            Assertions.assertEquals((Object)"A", (Object)messageReceivedA.getStringProperty("stuff"));
            Assertions.assertEquals((Object)"B", (Object)messageReceivedB.getStringProperty("stuff"));
            QueueControl queueControlA = ManagementControlHelper.createQueueControl(topic, SimpleString.of((String)("C.A." + topic.toString())), RoutingType.MULTICAST, this.mbeanServer);
            Wait.assertEquals((long)0L, () -> queueControlA.countMessages());
            QueueControl queueControlB = ManagementControlHelper.createQueueControl(topic, SimpleString.of((String)("C.B." + topic.toString())), RoutingType.MULTICAST, this.mbeanServer);
            Wait.assertEquals((long)0L, () -> queueControlB.countMessages());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

