/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProducerAutoCreateQueueTest
extends BasicOpenWireTest {
    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        serverConfig.setAddressQueueScanPeriod(100L);
        String match = "#";
        Map asMap = serverConfig.getAddressSettings();
        ((AddressSettings)asMap.get(match)).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProducerBlockWontGetTimeout() throws Exception {
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Queue trash = session.createQueue("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
            Assertions.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.of((String)"trash")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreateSendToTopic() throws Exception {
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Topic trash = session.createTopic("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
        }
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)"trash")) != null);
        Wait.assertEquals((long)0L, () -> ((ActiveMQServer)this.server).getTotalMessageCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreateSendToQueue() throws Exception {
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Queue trash = session.createQueue("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
        }
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)"trash")) != null);
        Wait.assertTrue(() -> this.server.locateQueue(SimpleString.of((String)"trash")) != null);
        Wait.assertEquals((long)1L, () -> ((ActiveMQServer)this.server).getTotalMessageCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDelete() throws Exception {
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Queue trash = session.createQueue("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
            Assertions.assertNotNull((Object)this.server.locateQueue(SimpleString.of((String)"trash")));
            MessageConsumer consumer = session.createConsumer((Destination)trash);
            connection.start();
            Assertions.assertNotNull((Object)consumer.receive(1000L));
        }
        SimpleString queueName = SimpleString.of((String)"trash");
        Wait.assertTrue(() -> this.server.locateQueue(queueName) == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteNegative() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("trash", (Object)new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(false)).setAutoDeleteAddresses(Boolean.valueOf(false)));
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Queue trash = session.createQueue("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
            Assertions.assertNotNull((Object)this.server.locateQueue(SimpleString.of((String)"trash")));
            MessageConsumer consumer = session.createConsumer((Destination)trash);
            connection.start();
            Assertions.assertNotNull((Object)consumer.receive(1000L));
        }
        Wait.assertTrue(() -> this.server.locateQueue(SimpleString.of((String)"trash")) != null);
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)"trash")) != null);
    }

    @Test
    public void testSendFailsWithoutAutoCreate() throws Exception {
        Assertions.assertThrows(JMSException.class, () -> {
            try (Connection connection = null;){
                AddressSettings setting = new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false));
                this.server.getAddressSettingsRepository().addMatch("WRONG.#", (Object)setting);
                connection = this.factory.createConnection("admin", "password");
                Session session = connection.createSession(false, 1);
                ActiveMQDestination destination = ActiveMQDestination.createDestination((String)"WRONG.QUEUE", (byte)1);
                MessageProducer producer = session.createProducer(null);
                producer.send((Destination)destination, (Message)session.createTextMessage("foo"));
            }
        });
    }

    @Test
    public void testTransactedSendFailsWithoutAutoCreate() throws Exception {
        Assertions.assertThrows(JMSException.class, () -> {
            try (Connection connection = null;){
                AddressSettings setting = new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false));
                this.server.getAddressSettingsRepository().addMatch("WRONG.#", (Object)setting);
                connection = this.factory.createConnection("admin", "password");
                Session session = connection.createSession(true, 1);
                ActiveMQDestination destination = ActiveMQDestination.createDestination((String)"WRONG.QUEUE", (byte)1);
                MessageProducer producer = session.createProducer(null);
                producer.send((Destination)destination, (Message)session.createTextMessage("foo"));
                session.commit();
            }
        });
    }
}

