/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderTestAccessor;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.PageFullMessagePolicy;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PagingSendTest
extends ActiveMQTestBase {
    public static final SimpleString ADDRESS = SimpleString.of((String)"SimpleAddress");
    private ServerLocator locator;
    private ActiveMQServer server;

    protected boolean isNetty() {
        return false;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.newActiveMQServer();
        this.server.start();
        this.waitForServerToStart(this.server);
        this.locator = this.createFactory(this.isNetty());
    }

    private ActiveMQServer newActiveMQServer() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty());
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        return server;
    }

    @Test
    public void testSameMessageOverAndOverBlocking() throws Exception {
        this.dotestSameMessageOverAndOver(true);
    }

    @Test
    public void testSameMessageOverAndOverNonBlocking() throws Exception {
        this.dotestSameMessageOverAndOver(false);
    }

    public void dotestSameMessageOverAndOver(boolean blocking) throws Exception {
        this.locator.setBlockOnNonDurableSend(blocking).setBlockOnDurableSend(blocking).setBlockOnAcknowledge(blocking);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = null;
        message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)message);
        }
        session.close();
        session = sf.createSession(null, null, false, true, true, false, 0);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 200; ++i) {
            ClientMessage message2 = consumer.receive(10000L);
            Assertions.assertNotNull((Object)message2);
            if (i == 100) {
                session.commit();
            }
            message2.acknowledge();
        }
        consumer.close();
        session.close();
    }

    @Test
    public void testOrderOverTX() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession sessionConsumer = sf.createSession(true, true, 0);
        sessionConsumer.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        ClientSession sessionProducer = sf.createSession(false, false);
        ClientProducer producer = sessionProducer.createProducer(ADDRESS);
        AtomicInteger errors = new AtomicInteger(0);
        int TOTAL_MESSAGES = 1000;
        CountDownLatch ready = new CountDownLatch(1);
        Thread tProducer = new Thread(() -> {
            try {
                int commit = 0;
                for (int i = 0; i < 1000; ++i) {
                    ClientMessage msg = sessionProducer.createMessage(true);
                    msg.getBodyBuffer().writeBytes(new byte[1024]);
                    msg.putIntProperty("count", i);
                    producer.send((Message)msg);
                    if (i % 100 != 0 || i <= 0) continue;
                    sessionProducer.commit();
                    if (commit++ <= 2) continue;
                    ready.countDown();
                }
                sessionProducer.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.incrementAndGet();
            }
        });
        ClientConsumer consumer = sessionConsumer.createConsumer(ADDRESS);
        sessionConsumer.start();
        tProducer.start();
        Assertions.assertTrue((boolean)ready.await(10L, TimeUnit.SECONDS));
        for (int i = 0; i < 1000; ++i) {
            ClientMessage msg = consumer.receive(10000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("count"));
            msg.acknowledge();
        }
        tProducer.join();
        sessionConsumer.close();
        sessionProducer.close();
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    @Test
    public void testPagingDoesNotDuplicateBatchMessages() throws Exception {
        int batchSize = 20;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false);
        SimpleString queueAddr = SimpleString.of((String)"testQueue");
        session.createQueue(QueueConfiguration.of((SimpleString)queueAddr));
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(16384L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.sendMessageBatch(batchSize, session, queueAddr);
        Queue queue = this.server.locateQueue(queueAddr);
        Assertions.assertTrue((boolean)this.waitForMessages(queue, batchSize, 3000L), (String)"Messages were not propagated to internal structures.");
        AtomicInteger errors = new AtomicInteger(0);
        CountDownLatch done = new CountDownLatch(1);
        queue.getPagingStore().getExecutor().execute(() -> {
            try {
                this.checkBatchMessagesAreNotPagedTwice(queue);
                for (int i = 0; i < 10; ++i) {
                    Assertions.assertEquals((int)batchSize, (int)this.processCountThroughIterator(queue));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                errors.incrementAndGet();
            }
            done.countDown();
        });
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    @Test
    public void testPagingDoesNotDuplicateBatchMessagesAfterPagingStarted() throws Exception {
        int batchSize = 20;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, false);
        SimpleString queueAddr = SimpleString.of((String)"testQueue");
        session.createQueue(QueueConfiguration.of((SimpleString)queueAddr));
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(16384L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        int numberOfMessages = 0;
        while (!this.server.getPagingManager().getPageStore(queueAddr).isPaging()) {
            this.sendMessageBatch(batchSize, session, queueAddr);
            numberOfMessages += batchSize;
        }
        this.sendMessageBatch(batchSize, session, queueAddr);
        numberOfMessages += batchSize;
        Queue queue = this.server.locateQueue(queueAddr);
        this.checkBatchMessagesAreNotPagedTwice(queue);
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((int)numberOfMessages, (int)this.processCountThroughIterator(queue));
        }
    }

    @Test
    public void testPageLimitBytesValidation() throws Exception {
        String addressName = this.getTestMethodName();
        try (ClientSessionFactory sf = this.createSessionFactory(this.locator);){
            ClientSession session = sf.createSession(false, false);
            SimpleString queueAddr = SimpleString.of((String)addressName);
            session.createQueue(QueueConfiguration.of((SimpleString)queueAddr));
            int size = 0x100000;
            AddressSettings addressSettings = new AddressSettings();
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
            addressSettings.setPageFullMessagePolicy(PageFullMessagePolicy.FAIL);
            addressSettings.setPageSizeBytes(size);
            addressSettings.setPageLimitBytes(Long.valueOf(size));
            addressSettings.setMaxSizeBytes((long)size);
            this.server.getAddressSettingsRepository().addMatch(addressName, (Object)addressSettings);
            int totalMessages = 15;
            int messageSize = 90000;
            this.sendMessageBatch(totalMessages, messageSize, session, queueAddr);
            Queue queue = this.server.locateQueue(queueAddr);
            Assertions.assertTrue((boolean)this.waitForMessages(queue, totalMessages, 10000L));
            PagingStore queuePagingStore = queue.getPagingStore();
            Assertions.assertTrue((queuePagingStore != null && queuePagingStore.isPaging() ? (byte)1 : 0) != 0);
            Assertions.assertFalse((boolean)queuePagingStore.isPageFull());
            addressSettings.setPageLimitBytes(Long.valueOf(size - 1));
            this.server.getAddressSettingsRepository().addMatch(addressName, (Object)addressSettings);
            Assertions.assertEquals((long)(size - 1), (Long)queuePagingStore.getPageLimitBytes());
            Assertions.assertTrue((boolean)queuePagingStore.isPageFull());
            try {
                this.sendMessageBatch(1, messageSize, session, queueAddr);
                Assertions.fail((String)"should be immediate blocked on paging");
            }
            catch (ActiveMQAddressFullException activeMQAddressFullException) {
                // empty catch block
            }
            Assertions.assertTrue((boolean)queuePagingStore.isPageFull());
            addressSettings.setPageLimitBytes(Long.valueOf(size * 2));
            this.server.getAddressSettingsRepository().addMatch(addressName, (Object)addressSettings);
            Assertions.assertFalse((boolean)queuePagingStore.isPageFull());
            this.sendMessageBatch(1, messageSize, session, queueAddr);
            Assertions.assertTrue((boolean)this.waitForMessages(queue, totalMessages + 1, 10000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageLimitBytesAndPageLimitMessagesValidationBlockOnLimitMessagesFirst() throws Exception {
        String queueName = this.getTestMethodName();
        try (ClientSessionFactory sf = this.createSessionFactory(this.locator);){
            ClientSession session = sf.createSession(true, true);
            SimpleString queueAddr = SimpleString.of((String)queueName);
            session.createQueue(QueueConfiguration.of((SimpleString)queueAddr));
            int size = 51200;
            Long maxMessages = 10L;
            int initPageSizeBytes = 51200;
            Long initPageLimitBytes = 512000L;
            AddressSettings addressSettings = new AddressSettings();
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
            addressSettings.setPageFullMessagePolicy(PageFullMessagePolicy.FAIL);
            addressSettings.setPageSizeBytes(51200);
            addressSettings.setPageLimitBytes(initPageLimitBytes);
            addressSettings.setMaxSizeBytes(51200L);
            addressSettings.setPageLimitMessages(maxMessages);
            this.server.getAddressSettingsRepository().addMatch(queueName, (Object)addressSettings);
            int totalMessages = 0;
            int messageSize = 1024;
            ClientProducer producer = session.createProducer(queueAddr);
            boolean stop = false;
            while (!stop) {
                try {
                    ClientMessage message = this.createMessage(session, messageSize, totalMessages, null);
                    producer.send((Message)message);
                    ++totalMessages;
                    session.commit();
                }
                catch (ActiveMQAddressFullException ex) {
                    stop = true;
                }
            }
            Queue queue = this.server.locateQueue(queueAddr);
            Assertions.assertTrue((boolean)this.waitForMessages(queue, totalMessages, 10000L));
            PagingStore queuePagingStore = queue.getPagingStore();
            Assertions.assertTrue((queuePagingStore != null && queuePagingStore.isPageFull() ? (byte)1 : 0) != 0);
            PageCursorProvider cursorProvider = queuePagingStore.getCursorProvider();
            Assertions.assertEquals((Long)PageCursorProviderTestAccessor.getNumberOfMessagesOnSubscriptions(cursorProvider), (Long)maxMessages);
            Assertions.assertEquals((Long)initPageLimitBytes, (Long)queuePagingStore.getPageLimitBytes());
            Assertions.assertEquals((int)51200, (int)queuePagingStore.getPageSizeBytes());
            long existingPages = queuePagingStore.getNumberOfPages();
            Assertions.assertTrue((existingPages <= initPageLimitBytes / 51200L ? (byte)1 : 0) != 0);
            this.server.stop(true);
            this.waitForServerToStop(this.server);
            try {
                this.server.start();
                this.waitForServerToStart(this.server);
                queue = this.server.locateQueue(queueAddr);
                queuePagingStore = queue.getPagingStore();
                Assertions.assertTrue((queuePagingStore != null && queuePagingStore.isPageFull() ? (byte)1 : 0) != 0);
                long currentPages = queuePagingStore.getNumberOfPages();
                Assertions.assertEquals((Long)initPageLimitBytes, (Long)queuePagingStore.getPageLimitBytes());
                Assertions.assertEquals((int)51200, (int)queuePagingStore.getPageSizeBytes());
                long maxPages = initPageLimitBytes / 51200L;
                Assertions.assertTrue((currentPages <= maxPages ? (byte)1 : 0) != 0);
                Long bigLimitMessages = 1000L;
                addressSettings.setPageLimitMessages(bigLimitMessages);
                this.server.getAddressSettingsRepository().addMatch(queueName, (Object)addressSettings);
                Assertions.assertFalse((boolean)queuePagingStore.isPageFull());
                this.locator = this.createFactory(this.isNetty());
                try (ClientSessionFactory csf = this.createSessionFactory(this.locator);){
                    stop = false;
                    session = csf.createSession(true, true);
                    producer = session.createProducer(queueAddr);
                    while (!stop) {
                        try {
                            ClientMessage message = this.createMessage(session, messageSize, totalMessages, null);
                            producer.send((Message)message);
                            Assertions.assertTrue(((long)(++totalMessages) <= bigLimitMessages ? (byte)1 : 0) != 0, (String)"test is broken");
                        }
                        catch (ActiveMQAddressFullException ex) {
                            stop = true;
                        }
                    }
                }
                Assertions.assertTrue((boolean)queuePagingStore.isPageFull());
                currentPages = queuePagingStore.getNumberOfPages();
                Assertions.assertEquals((Long)initPageLimitBytes, (Long)queuePagingStore.getPageLimitBytes());
                Assertions.assertEquals((int)51200, (int)queuePagingStore.getPageSizeBytes());
                maxPages = initPageLimitBytes / 51200L;
                Assertions.assertTrue((currentPages > maxPages ? (byte)1 : 0) != 0);
                cursorProvider = queuePagingStore.getCursorProvider();
                Assertions.assertEquals((Long)bigLimitMessages, (Long)queuePagingStore.getPageLimitMessages());
                Assertions.assertTrue((PageCursorProviderTestAccessor.getNumberOfMessagesOnSubscriptions(cursorProvider) < bigLimitMessages ? (byte)1 : 0) != 0);
            }
            finally {
                this.server.stop(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageLimitBytesAndPageLimitMessagesValidationBlockOnLimitBytesFirst() throws Exception {
        String queueName = this.getTestMethodName();
        try (ClientSessionFactory sf = this.createSessionFactory(this.locator);){
            ClientSession session = sf.createSession(true, true);
            SimpleString queueAddr = SimpleString.of((String)queueName);
            session.createQueue(QueueConfiguration.of((SimpleString)queueAddr));
            int size = 51200;
            Long maxMessages = 200L;
            int initPageSizeBytes = 51200;
            Long initPageLimitBytes = 256000L;
            AddressSettings addressSettings = new AddressSettings();
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
            addressSettings.setPageFullMessagePolicy(PageFullMessagePolicy.FAIL);
            addressSettings.setPageSizeBytes(51200);
            addressSettings.setPageLimitBytes(initPageLimitBytes);
            addressSettings.setMaxSizeBytes(51200L);
            addressSettings.setPageLimitMessages(maxMessages);
            this.server.getAddressSettingsRepository().addMatch(queueName, (Object)addressSettings);
            int totalMessages = 0;
            int messageSize = 1024;
            ClientProducer producer = session.createProducer(queueAddr);
            boolean stop = false;
            while (!stop) {
                try {
                    ClientMessage message = this.createMessage(session, messageSize, totalMessages, null);
                    producer.send((Message)message);
                    ++totalMessages;
                    session.commit();
                }
                catch (ActiveMQAddressFullException ex) {
                    stop = true;
                }
            }
            Queue queue = this.server.locateQueue(queueAddr);
            Assertions.assertTrue((boolean)this.waitForMessages(queue, totalMessages, 10000L));
            PagingStore queuePagingStore = queue.getPagingStore();
            Assertions.assertTrue((queuePagingStore != null && queuePagingStore.isPageFull() ? (byte)1 : 0) != 0);
            long existingPages = queuePagingStore.getNumberOfPages();
            Assertions.assertEquals((Long)initPageLimitBytes, (Long)queuePagingStore.getPageLimitBytes());
            Assertions.assertEquals((int)51200, (int)queuePagingStore.getPageSizeBytes());
            long maxPages = initPageLimitBytes / 51200L;
            Assertions.assertTrue((existingPages > maxPages ? (byte)1 : 0) != 0);
            PageCursorProvider cursorProvider = queuePagingStore.getCursorProvider();
            Long existingMessages = PageCursorProviderTestAccessor.getNumberOfMessagesOnSubscriptions(cursorProvider);
            Assertions.assertTrue((existingMessages < maxMessages ? (byte)1 : 0) != 0, (String)("existing " + existingMessages + " should be less than max " + maxMessages));
            this.server.stop(true);
            this.waitForServerToStop(this.server);
            try {
                this.server.start();
                this.waitForServerToStart(this.server);
                queue = this.server.locateQueue(queueAddr);
                queuePagingStore = queue.getPagingStore();
                Assertions.assertNotNull((Object)queuePagingStore);
                Assertions.assertTrue((boolean)queuePagingStore.isPageFull());
                cursorProvider = queuePagingStore.getCursorProvider();
                existingMessages = PageCursorProviderTestAccessor.getNumberOfMessagesOnSubscriptions(cursorProvider);
                Assertions.assertTrue((existingMessages < maxMessages ? (byte)1 : 0) != 0, (String)("existing " + existingMessages + " should be still less than max " + maxMessages));
                Long newPageLimitBytes = 1024000L;
                addressSettings.setPageLimitBytes(newPageLimitBytes);
                this.server.getAddressSettingsRepository().addMatch(queueName, (Object)addressSettings);
                Assertions.assertFalse((boolean)queuePagingStore.isPageFull());
                this.locator = this.createFactory(this.isNetty());
                try (ClientSessionFactory csf = this.createSessionFactory(this.locator);){
                    stop = false;
                    session = csf.createSession(true, true);
                    producer = session.createProducer(queueAddr);
                    while (!stop) {
                        try {
                            ClientMessage message = this.createMessage(session, messageSize, totalMessages, null);
                            producer.send((Message)message);
                            ++totalMessages;
                        }
                        catch (ActiveMQAddressFullException ex) {
                            stop = true;
                        }
                    }
                }
                Assertions.assertTrue((boolean)queuePagingStore.isPageFull());
                Long currentPages = queuePagingStore.getNumberOfPages();
                Assertions.assertEquals((Long)newPageLimitBytes, (Long)queuePagingStore.getPageLimitBytes());
                Assertions.assertEquals((int)51200, (int)queuePagingStore.getPageSizeBytes());
                maxPages = newPageLimitBytes / 51200L;
                Assertions.assertTrue((currentPages <= maxPages ? (byte)1 : 0) != 0);
                cursorProvider = queuePagingStore.getCursorProvider();
                Assertions.assertEquals((Long)maxMessages, (Long)queuePagingStore.getPageLimitMessages());
                Assertions.assertEquals((Long)PageCursorProviderTestAccessor.getNumberOfMessagesOnSubscriptions(cursorProvider), (Long)maxMessages);
            }
            finally {
                this.server.stop(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageLimitBytesValidationOnRestart() throws Exception {
        String queueName = this.getTestMethodName();
        try (ClientSessionFactory sf = this.createSessionFactory(this.locator);){
            ClientSession session = sf.createSession(false, false);
            SimpleString queueAddr = SimpleString.of((String)queueName);
            session.createQueue(QueueConfiguration.of((SimpleString)queueAddr));
            int size = 51200;
            int initPageSizeBytes = 51200;
            Long initPageLimitBytes = 512000L;
            AddressSettings addressSettings = new AddressSettings();
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
            addressSettings.setPageFullMessagePolicy(PageFullMessagePolicy.FAIL);
            addressSettings.setPageSizeBytes(51200);
            addressSettings.setPageLimitBytes(initPageLimitBytes);
            addressSettings.setMaxSizeBytes(51200L);
            this.server.getAddressSettingsRepository().addMatch(queueName, (Object)addressSettings);
            int totalMessages = 30;
            int messageSize = 10240;
            this.sendMessageBatch(totalMessages, messageSize, session, queueAddr);
            Queue queue = this.server.locateQueue(queueAddr);
            Assertions.assertTrue((boolean)this.waitForMessages(queue, totalMessages, 10000L));
            PagingStore queuePagingStore = queue.getPagingStore();
            Assertions.assertNotNull((Object)queuePagingStore);
            Assertions.assertTrue((boolean)queuePagingStore.isPaging());
            Assertions.assertFalse((boolean)queuePagingStore.isPageFull());
            long existingPages = queuePagingStore.getNumberOfPages();
            Assertions.assertTrue((existingPages > 4L ? (byte)1 : 0) != 0);
            this.server.stop(true);
            this.waitForServerToStop(this.server);
            Long newPageLimitBytes = 204800L;
            addressSettings.setPageLimitBytes(newPageLimitBytes);
            this.server.getAddressSettingsRepository().addMatch(queueName, (Object)addressSettings);
            try {
                this.server.start();
                this.waitForServerToStart(this.server);
                queue = this.server.locateQueue(queueAddr);
                Assertions.assertTrue((boolean)this.waitForMessages(queue, totalMessages, 10000L));
                queuePagingStore = queue.getPagingStore();
                Assertions.assertNotNull((Object)queuePagingStore);
                Assertions.assertTrue((queuePagingStore.isPaging() && queuePagingStore.isPageFull() ? (byte)1 : 0) != 0);
                long currentPages = queuePagingStore.getNumberOfPages();
                Assertions.assertEquals((long)existingPages, (long)currentPages);
                Assertions.assertEquals((Long)newPageLimitBytes, (Long)queuePagingStore.getPageLimitBytes());
                Assertions.assertEquals((int)51200, (int)queuePagingStore.getPageSizeBytes());
                long maxPages = newPageLimitBytes / 51200L;
                Assertions.assertTrue((currentPages > maxPages ? (byte)1 : 0) != 0);
                this.locator = this.createFactory(this.isNetty());
                int numMessages = 25;
                try (ClientSessionFactory csf = this.createSessionFactory(this.locator);){
                    session = csf.createSession(false, true);
                    session.start();
                    ClientConsumer consumer = session.createConsumer(queueName);
                    for (int i = 0; i < 25; ++i) {
                        ClientMessage message = consumer.receive(5000L);
                        Assertions.assertNotNull((Object)message);
                        message.acknowledge();
                        session.commit();
                    }
                    currentPages = queuePagingStore.getNumberOfPages();
                    Assertions.assertTrue((boolean)queuePagingStore.isPaging());
                    Assertions.assertFalse((boolean)queuePagingStore.isPageFull());
                    Assertions.assertTrue((currentPages <= maxPages ? (byte)1 : 0) != 0);
                    ClientProducer producer = session.createProducer(queueName);
                    boolean isFull = false;
                    try {
                        for (int i = 0; i < 25; ++i) {
                            ClientMessage message = this.createMessage(session, messageSize, i, null);
                            producer.send((Message)message);
                            session.commit();
                        }
                    }
                    catch (ActiveMQAddressFullException e) {
                        isFull = true;
                    }
                    Assertions.assertTrue((boolean)isFull);
                    currentPages = queuePagingStore.getNumberOfPages();
                    Assertions.assertTrue((currentPages == maxPages + 1L ? (byte)1 : 0) != 0);
                    Assertions.assertTrue((boolean)queuePagingStore.isPageFull());
                }
            }
            finally {
                this.server.stop(true);
            }
        }
    }

    public void checkBatchMessagesAreNotPagedTwice(Queue queue) throws Exception {
        LinkedListIterator pageIterator = queue.browserIterator();
        HashSet<String> messageOrderSet = new HashSet<String>();
        int duplicates = 0;
        while (pageIterator.hasNext()) {
            MessageReference reference = (MessageReference)pageIterator.next();
            String id = reference.getMessage().getStringProperty("id");
            if (messageOrderSet.add(id)) continue;
            System.out.println("Received a duplicate on " + id);
            ++duplicates;
        }
        Assertions.assertEquals((int)0, (int)duplicates);
    }

    protected int processCountThroughIterator(Queue queue) throws Exception {
        LinkedListIterator pageIterator = queue.browserIterator();
        int count = 0;
        while (pageIterator.hasNext()) {
            MessageReference reference = (MessageReference)pageIterator.next();
            ++count;
        }
        return count;
    }
}

