/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.routing;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.routing.RoutingTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class RedirectTest
extends RoutingTestBase {
    private final String protocol;
    private final String pool;

    @Parameters(name="protocol: {0}, pool: {1}")
    public static Collection<Object[]> data() {
        String[] protocols = new String[]{"AMQP", "CORE", "OPENWIRE"};
        String[] pools = new String[]{"CLUSTER", "DISCOVERY", "STATIC"};
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String protocol : Arrays.asList(protocols)) {
            for (String pool : Arrays.asList(pools)) {
                data.add(new Object[]{protocol, pool});
            }
        }
        return data;
    }

    public RedirectTest(String protocol, String pool) {
        this.protocol = protocol;
        this.pool = pool;
    }

    @TestTemplate
    public void testSimpleRedirect() throws Exception {
        Session session;
        String queueName = "RedirectTestQueue";
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupPrimaryServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        if ("CLUSTER".equals(this.pool)) {
            this.setupDiscoveryClusterConnection("cluster0", 0, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
            this.setupDiscoveryClusterConnection("cluster1", 1, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
            this.setupRouterServerWithCluster(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, "ACTIVEMQ.CLUSTER.ADMIN.USER", 1, "cluster0");
        } else if ("DISCOVERY".equals(this.pool)) {
            this.setupRouterServerWithDiscovery(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, null, 1);
        } else {
            this.setupRouterServerWithStaticConnectors(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, null, 1, 1);
        }
        this.startServers(0, 1);
        this.getServer(0).createQueue(QueueConfiguration.of((String)"RedirectTestQueue").setRoutingType(RoutingType.ANYCAST));
        this.getServer(1).createQueue(QueueConfiguration.of((String)"RedirectTestQueue").setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl0 = (QueueControl)this.getServer(0).getManagementService().getResource("queue.RedirectTestQueue");
        QueueControl queueControl1 = (QueueControl)this.getServer(1).getManagementService().getResource("queue.RedirectTestQueue");
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages());
        Assertions.assertEquals((long)0L, (long)queueControl1.countMessages());
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, null, "admin", "admin");
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
            session = connection.createSession(false, 1);
            try {
                Queue queue = session.createQueue("RedirectTestQueue");
                try (MessageProducer producer = session.createProducer((Destination)queue);){
                    producer.send((Message)session.createTextMessage("TEST"));
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages());
        Assertions.assertEquals((long)1L, (long)queueControl1.countMessages());
        connection = connectionFactory.createConnection();
        try {
            connection.start();
            session = connection.createSession(false, 1);
            try (MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("RedirectTestQueue"));){
                TextMessage message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)"TEST", (Object)message.getText());
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages());
        Assertions.assertEquals((long)0L, (long)queueControl1.countMessages());
        this.stopServers(0, 1);
    }

    @TestTemplate
    public void testRoundRobinRedirect() throws Exception {
        this.testEvenlyRedirect("ROUND_ROBIN", null, false);
    }

    @TestTemplate
    public void testLeastConnectionsRedirect() throws Exception {
        this.testEvenlyRedirect("LEAST_CONNECTIONS", Collections.singletonMap("CONNECTION_COUNT_THRESHOLD", String.valueOf(30)), false);
    }

    @TestTemplate
    public void testRoundRobinRedirectWithFailure() throws Exception {
        this.testEvenlyRedirect("ROUND_ROBIN", null, true);
    }

    @TestTemplate
    public void testLeastConnectionsRedirectWithFailure() throws Exception {
        this.testEvenlyRedirect("LEAST_CONNECTIONS", Collections.singletonMap("CONNECTION_COUNT_THRESHOLD", String.valueOf(30)), true);
    }

    private void testEvenlyRedirect(String policyName, Map<String, String> properties, boolean withFailure) throws Exception {
        int i;
        String queueName = "RedirectTestQueue";
        int targets = 3;
        int[] nodes = new int[4];
        int[] targetNodes = new int[3];
        QueueControl[] queueControls = new QueueControl[4];
        nodes[0] = 0;
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        for (int i2 = 0; i2 < 3; ++i2) {
            nodes[i2 + 1] = i2 + 1;
            targetNodes[i2] = i2 + 1;
            this.setupPrimaryServerWithDiscovery(i2 + 1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        }
        if ("CLUSTER".equals(this.pool)) {
            for (int node : nodes) {
                this.setupDiscoveryClusterConnection("cluster" + node, node, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
            }
            this.setupRouterServerWithCluster(0, KeyType.USER_NAME, policyName, properties, false, "ACTIVEMQ.CLUSTER.ADMIN.USER", 3, "cluster0");
        } else if ("DISCOVERY".equals(this.pool)) {
            this.setupRouterServerWithDiscovery(0, KeyType.USER_NAME, policyName, properties, false, null, 3);
        } else {
            this.setupRouterServerWithStaticConnectors(0, KeyType.USER_NAME, policyName, properties, false, null, 3, 1, 2, 3);
        }
        if (withFailure) {
            this.setupRouterLocalCache(0, true, 0);
        }
        this.startServers(nodes);
        for (int node : nodes) {
            this.getServer(node).createQueue(QueueConfiguration.of((String)"RedirectTestQueue").setRoutingType(RoutingType.ANYCAST));
            queueControls[node] = (QueueControl)this.getServer(node).getManagementService().getResource("queue.RedirectTestQueue");
            Assertions.assertEquals((long)0L, (long)queueControls[node].countMessages(), (String)("Unexpected messagecount for node " + node));
        }
        ConnectionFactory[] connectionFactories = new ConnectionFactory[3];
        Connection[] connections = new Connection[3];
        Session[] sessions = new Session[3];
        for (i = 0; i < 3; ++i) {
            connectionFactories[i] = this.createFactory(this.protocol, false, "localhost", 61616, null, "user" + i, "user" + i);
            connections[i] = connectionFactories[i].createConnection();
            connections[i].start();
            sessions[i] = connections[i].createSession(false, 1);
        }
        for (i = 0; i < 3; ++i) {
            try (MessageProducer producer = sessions[i].createProducer((Destination)sessions[i].createQueue("RedirectTestQueue"));){
                producer.send((Message)sessions[i].createTextMessage("TEST" + i));
            }
            sessions[i].close();
            connections[i].close();
        }
        Assertions.assertEquals((long)0L, (long)queueControls[0].countMessages());
        for (int targetNode : targetNodes) {
            Assertions.assertEquals((long)1L, (long)queueControls[targetNode].countMessages(), (String)("Messages of node " + targetNode));
        }
        if (withFailure) {
            RedirectTest.crashAndWaitForFailure(this.getServer(0), new ClientSession[0]);
            this.startServers(0);
        }
        for (int i3 = 0; i3 < 3; ++i3) {
            try (Connection connection = connectionFactories[i3].createConnection();){
                connection.start();
                try (Session session = connection.createSession(false, 1);
                     MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("RedirectTestQueue"));){
                    TextMessage message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)("TEST" + i3), (Object)message.getText());
                    continue;
                }
            }
        }
        for (int node : nodes) {
            Assertions.assertEquals((long)0L, (long)queueControls[node].countMessages(), (String)("Unexpected message count for node " + node));
        }
        this.stopServers(nodes);
    }

    @TestTemplate
    public void testSymmetricRedirect() throws Exception {
        String queueName = "RedirectTestQueue";
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupPrimaryServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        if ("CLUSTER".equals(this.pool)) {
            this.setupDiscoveryClusterConnection("cluster0", 0, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
            this.setupDiscoveryClusterConnection("cluster1", 1, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
            this.setupRouterServerWithCluster(0, KeyType.USER_NAME, "CONSISTENT_HASH", null, true, "ACTIVEMQ.CLUSTER.ADMIN.USER", 2, "cluster0");
            this.setupRouterServerWithCluster(1, KeyType.USER_NAME, "CONSISTENT_HASH", null, true, "ACTIVEMQ.CLUSTER.ADMIN.USER", 2, "cluster1");
        } else if ("DISCOVERY".equals(this.pool)) {
            this.setupRouterServerWithDiscovery(0, KeyType.USER_NAME, "CONSISTENT_HASH", null, true, null, 2);
            this.setupRouterServerWithDiscovery(1, KeyType.USER_NAME, "CONSISTENT_HASH", null, true, null, 2);
        } else {
            this.setupRouterServerWithStaticConnectors(0, KeyType.USER_NAME, "CONSISTENT_HASH", null, true, null, 2, 1);
            this.setupRouterServerWithStaticConnectors(1, KeyType.USER_NAME, "CONSISTENT_HASH", null, true, null, 2, 0);
        }
        this.startServers(0, 1);
        Assertions.assertTrue((this.getServer(0).getNodeID() != this.getServer(1).getNodeID() ? (byte)1 : 0) != 0);
        this.getServer(0).createQueue(QueueConfiguration.of((String)"RedirectTestQueue").setRoutingType(RoutingType.ANYCAST));
        this.getServer(1).createQueue(QueueConfiguration.of((String)"RedirectTestQueue").setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl0 = (QueueControl)this.getServer(0).getManagementService().getResource("queue.RedirectTestQueue");
        QueueControl queueControl1 = (QueueControl)this.getServer(1).getManagementService().getResource("queue.RedirectTestQueue");
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages(), (String)"Unexpected message count for node 0");
        Assertions.assertEquals((long)0L, (long)queueControl1.countMessages(), (String)"Unexpected message count for node 1");
        ConnectionFactory connectionFactory0 = this.createFactory(this.protocol, false, "localhost", 61616, null, "admin", "admin");
        try (Connection connection = connectionFactory0.createConnection();){
            connection.start();
            try (Session session = connection.createSession(false, 1);){
                Queue queue = session.createQueue("RedirectTestQueue");
                try (MessageProducer producer = session.createProducer((Destination)queue);){
                    producer.send((Message)session.createTextMessage("TEST"));
                }
            }
        }
        Assertions.assertTrue((queueControl0.countMessages() == 0L && queueControl1.countMessages() == 1L || queueControl0.countMessages() == 1L && queueControl1.countMessages() == 0L ? (byte)1 : 0) != 0);
        Assertions.assertTrue((this.getServer(0).getNodeID() != this.getServer(1).getNodeID() ? (byte)1 : 0) != 0);
        ConnectionFactory connectionFactory1 = this.createFactory(this.protocol, false, "localhost", 61617, null, "admin", "admin");
        try (Connection connection = connectionFactory1.createConnection();){
            connection.start();
            try (Session session = connection.createSession(false, 1);
                 MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("RedirectTestQueue"));){
                TextMessage message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)"TEST", (Object)message.getText());
            }
        }
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages(), (String)"Unexpected message count for node 0");
        Assertions.assertEquals((long)0L, (long)queueControl1.countMessages(), (String)"Unexpected message count for node 1");
        this.stopServers(0, 1);
    }

    @TestTemplate
    public void testRedirectAfterFailure() throws Exception {
        int failedNode;
        Session session;
        String queueName = "RedirectTestQueue";
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupPrimaryServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupPrimaryServerWithDiscovery(2, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        if ("CLUSTER".equals(this.pool)) {
            this.setupDiscoveryClusterConnection("cluster0", 0, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
            this.setupDiscoveryClusterConnection("cluster1", 1, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
            this.setupDiscoveryClusterConnection("cluster2", 2, "dg1", "queues", MessageLoadBalancingType.OFF, 1, true);
            this.setupRouterServerWithCluster(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, "ACTIVEMQ.CLUSTER.ADMIN.USER", 1, "cluster0");
        } else if ("DISCOVERY".equals(this.pool)) {
            this.setupRouterServerWithDiscovery(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, null, 1);
        } else {
            this.setupRouterServerWithStaticConnectors(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, null, 1, 1, 2);
        }
        this.startServers(0, 1, 2);
        this.getServer(0).createQueue(QueueConfiguration.of((String)"RedirectTestQueue").setRoutingType(RoutingType.ANYCAST));
        this.getServer(1).createQueue(QueueConfiguration.of((String)"RedirectTestQueue").setRoutingType(RoutingType.ANYCAST));
        this.getServer(2).createQueue(QueueConfiguration.of((String)"RedirectTestQueue").setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl0 = (QueueControl)this.getServer(0).getManagementService().getResource("queue.RedirectTestQueue");
        QueueControl queueControl1 = (QueueControl)this.getServer(1).getManagementService().getResource("queue.RedirectTestQueue");
        QueueControl queueControl2 = (QueueControl)this.getServer(2).getManagementService().getResource("queue.RedirectTestQueue");
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages(), (String)"Unexpected message count for node 0");
        Assertions.assertEquals((long)0L, (long)queueControl1.countMessages(), (String)"Unexpected message count for node 1");
        Assertions.assertEquals((long)0L, (long)queueControl2.countMessages(), (String)"Unexpected message count for node 2");
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, null, "admin", "admin");
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
            session = connection.createSession(false, 1);
            try {
                Queue queue = session.createQueue("RedirectTestQueue");
                try (MessageProducer producer = session.createProducer((Destination)queue);){
                    producer.send((Message)session.createTextMessage("TEST_BEFORE_FAILURE"));
                    failedNode = queueControl1.countMessages() > 0L ? 1 : 2;
                    this.stopServers(failedNode);
                    producer.send((Message)session.createTextMessage("TEST_AFTER_FAILURE"));
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        this.startServers(failedNode);
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages(), (String)"Unexpected message count for node 0");
        Assertions.assertEquals((long)1L, (long)queueControl1.countMessages(), (String)"Unexpected message count for node 1");
        Assertions.assertEquals((long)1L, (long)queueControl2.countMessages(), (String)"Unexpected message count for node 2");
        connection = connectionFactory.createConnection();
        try {
            connection.start();
            session = connection.createSession(false, 1);
            try (MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("RedirectTestQueue"));){
                TextMessage message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)"TEST_AFTER_FAILURE", (Object)message.getText());
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages(), (String)"Unexpected message count for node 0");
        if (failedNode == 1) {
            Assertions.assertEquals((long)1L, (long)queueControl1.countMessages(), (String)"Unexpected message count for node 1");
            Assertions.assertEquals((long)0L, (long)queueControl2.countMessages(), (String)"Unexpected message count for node 2");
        } else {
            Assertions.assertEquals((long)0L, (long)queueControl1.countMessages(), (String)"Unexpected message count for node 1");
            Assertions.assertEquals((long)1L, (long)queueControl2.countMessages(), (String)"Unexpected message count for node 2");
        }
        this.stopServers(0, 1, 2);
    }
}

