/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActivationFailureListenerTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;

    @Test
    public void simpleTest() throws Exception {
        try (ServerSocket s = new ServerSocket();){
            s.bind(new InetSocketAddress("127.0.0.1", 61616));
            this.server = this.createServer(false, this.createDefaultNettyConfig());
            CountDownLatch latch = new CountDownLatch(1);
            this.server.registerActivationFailureListener(exception -> latch.countDown());
            this.server.start();
            Assertions.assertTrue((boolean)latch.await(3000L, TimeUnit.MILLISECONDS));
        }
    }
}

