/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AutoCreateExpiryResourcesTest
extends ActiveMQTestBase {
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    public final SimpleString expiryAddress = SimpleString.of((String)"myExpiry");
    public final long EXPIRY_DELAY = 100L;
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.getConfiguration().setAddressQueueScanPeriod(50L).setMessageExpiryScanPeriod(50L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateExpiryResources(true).setExpiryAddress(this.expiryAddress).setExpiryDelay(Long.valueOf(100L)));
        this.server.start();
    }

    @Test
    public void testAutoCreationOfExpiryResources() throws Exception {
        int before = this.server.getActiveMQServerControl().getQueueNames().length;
        this.triggerExpiration();
        Wait.assertTrue(() -> this.server.getAddressInfo(this.expiryAddress) != null, (long)2000L, (long)100L);
        Assertions.assertNotNull((Object)this.server.locateQueue(this.getDefaultExpiryQueueName(this.addressA)));
        Assertions.assertEquals((int)2, (int)(this.server.getActiveMQServerControl().getQueueNames().length - before));
    }

    @Test
    public void testAutoCreationOfExpiryResourcesWithNullExpiry() throws Exception {
        this.testAutoCreationOfExpiryResourcesWithNoExpiry(null);
    }

    @Test
    public void testAutoCreationOfExpiryResourcesWithEmptyExpiry() throws Exception {
        this.testAutoCreationOfExpiryResourcesWithNoExpiry(SimpleString.of((String)""));
    }

    private void testAutoCreationOfExpiryResourcesWithNoExpiry(SimpleString expiryAddress) throws Exception {
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setExpiryAddress(expiryAddress);
        int before = this.server.getActiveMQServerControl().getQueueNames().length;
        this.triggerExpiration();
        if (expiryAddress != null) {
            Assertions.assertNull((Object)this.server.getAddressInfo(expiryAddress));
        }
        Assertions.assertNull((Object)this.server.locateQueue(this.getDefaultExpiryQueueName(this.addressA)));
        Assertions.assertEquals((int)1, (int)(this.server.getActiveMQServerControl().getQueueNames().length - before));
    }

    @Test
    public void testAutoCreateExpiryQueuePrefix() throws Exception {
        SimpleString prefix = RandomUtil.randomSimpleString();
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setExpiryQueuePrefix(prefix);
        this.triggerExpiration();
        Wait.assertTrue(() -> this.server.locateQueue(prefix.concat(this.addressA).concat(AddressSettings.DEFAULT_EXPIRY_QUEUE_SUFFIX)) != null, (long)2000L, (long)100L);
    }

    @Test
    public void testAutoCreateExpiryQueueSuffix() throws Exception {
        SimpleString suffix = RandomUtil.randomSimpleString();
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setExpiryQueueSuffix(suffix);
        this.triggerExpiration();
        Wait.assertTrue(() -> this.server.locateQueue(AddressSettings.DEFAULT_EXPIRY_QUEUE_PREFIX.concat(this.addressA).concat(suffix)) != null, (long)2000L, (long)100L);
    }

    @Test
    public void testAutoCreateExpiryQueuePrefixAndSuffix() throws Exception {
        SimpleString prefix = RandomUtil.randomSimpleString();
        SimpleString suffix = RandomUtil.randomSimpleString();
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setExpiryQueuePrefix(prefix).setExpiryQueueSuffix(suffix);
        this.triggerExpiration();
        Wait.assertTrue(() -> this.server.locateQueue(prefix.concat(this.addressA).concat(suffix)) != null, (long)2000L, (long)100L);
    }

    @Test
    public void testAutoCreatedExpiryFilterAnycast() throws Exception {
        this.testAutoCreatedExpiryFilter(RoutingType.ANYCAST);
    }

    @Test
    public void testAutoCreatedExpiryFilterMulticast() throws Exception {
        this.testAutoCreatedExpiryFilter(RoutingType.MULTICAST);
    }

    private void testAutoCreatedExpiryFilter(RoutingType routingType) throws Exception {
        int ITERATIONS = 50;
        int MESSAGE_COUNT = 5;
        for (int i = 0; i < 50; ++i) {
            SimpleString address = RandomUtil.randomSimpleString();
            SimpleString queue = RandomUtil.randomSimpleString();
            this.server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setRoutingType(routingType));
            ServerLocator locator = this.createInVMNonHALocator();
            ClientSessionFactory cf = this.createSessionFactory(locator);
            ClientSession s = this.addClientSession(cf.createSession(true, false));
            ClientProducer p = s.createProducer(address);
            for (int j = 0; j < 5; ++j) {
                p.send(s.createMessage(true).setRoutingType(routingType));
            }
            p.close();
            s.close();
            cf.close();
            locator.close();
            Wait.assertTrue(() -> this.server.locateQueue(this.getDefaultExpiryQueueName(address)) != null, (long)2000L, (long)10L);
            Queue expiry = this.server.locateQueue(AddressSettings.DEFAULT_EXPIRY_QUEUE_PREFIX.concat(address).concat(AddressSettings.DEFAULT_EXPIRY_QUEUE_SUFFIX));
            Wait.assertEquals((long)5L, () -> ((Queue)expiry).getMessageCount());
        }
        Assertions.assertEquals((int)50, (int)this.server.getPostOffice().getBindingsForAddress(this.expiryAddress).getBindings().size());
    }

    @Test
    public void testAutoDeletionAndRecreationOfExpiryResources() throws Exception {
        SimpleString expiryQueueName = this.getDefaultExpiryQueueName(this.addressA);
        this.triggerExpiration();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sessionFactory.createSession(true, true));
        Wait.assertTrue(() -> this.server.locateQueue(expiryQueueName) != null, (long)2000L, (long)100L);
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(expiryQueueName)).getMessageCount());
        ClientConsumer consumer = session.createConsumer(expiryQueueName);
        session.start();
        ClientMessage message = consumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        consumer.close();
        session.close();
        sessionFactory.close();
        locator.close();
        Wait.assertTrue(() -> this.server.locateQueue(expiryQueueName) == null, (long)2000L, (long)100L);
        this.server.destroyQueue(this.queueA);
        this.triggerExpiration();
        Wait.assertTrue(() -> this.server.getAddressInfo(this.expiryAddress) != null, (long)2000L, (long)100L);
        Wait.assertTrue(() -> this.server.locateQueue(expiryQueueName) != null, (long)2000L, (long)100L);
    }

    @Test
    public void testWithJMSFQQN() throws Exception {
        SimpleString expiryQueueName = this.getDefaultExpiryQueueName(this.addressA);
        String fqqn = CompositeAddress.toFullyQualified((SimpleString)this.expiryAddress, (SimpleString)expiryQueueName).toString();
        this.triggerExpiration();
        JMSContext context = new ActiveMQConnectionFactory("vm://0").createContext();
        context.start();
        Assertions.assertNotNull((Object)context.createConsumer((Destination)context.createQueue(fqqn)).receive(2000L));
    }

    @Test
    public void testConcurrentExpirations() throws Exception {
        SimpleString expiryQueueName = this.getDefaultExpiryQueueName(this.addressA);
        long COUNT = 5L;
        int i = 0;
        while ((long)i < 5L) {
            this.server.createQueue(QueueConfiguration.of((String)("" + i)).setAddress(this.addressA).setRoutingType(RoutingType.MULTICAST));
            ++i;
        }
        this.triggerExpiration(false);
        Wait.assertTrue(() -> this.server.locateQueue(expiryQueueName) != null, (long)2000L, (long)20L);
        Wait.assertEquals((Long)5L, () -> this.server.locateQueue(expiryQueueName).getMessageCount(), (long)2000L, (long)20L);
    }

    private SimpleString getDefaultExpiryQueueName(SimpleString address) {
        return AddressSettings.DEFAULT_EXPIRY_QUEUE_PREFIX.concat(address).concat(AddressSettings.DEFAULT_EXPIRY_QUEUE_SUFFIX);
    }

    private void triggerExpiration() throws Exception {
        this.triggerExpiration(true);
    }

    private void triggerExpiration(boolean createQueue) throws Exception {
        if (createQueue) {
            this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        }
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sessionFactory.createSession(true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.addressA));
        ClientMessage message = session.createMessage(true);
        message.setExpiration(System.currentTimeMillis());
        producer.send((Message)message);
        producer.close();
        session.close();
        sessionFactory.close();
        locator.close();
    }
}

