/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectionLimitTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Integer> nettyParams = new HashMap<String, Integer>();
        nettyParams.put("connectionsAllowed", 1);
        HashMap<String, Integer> invmParams = new HashMap<String, Integer>();
        invmParams.put("connectionsAllowed", 1);
        ConfigurationImpl configuration = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, nettyParams)).addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY, invmParams));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)false));
        this.server.start();
    }

    @Test
    public void testInVMConnectionLimit() throws Exception {
        ServerLocator locator = this.addServerLocator(this.createNonHALocator(false));
        ClientSessionFactory clientSessionFactory = locator.createSessionFactory();
        try {
            ClientSessionFactory extraClientSessionFactory = locator.createSessionFactory();
            Assertions.fail((String)"creating a session factory here should fail");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQNotConnectedException));
        }
    }

    @Test
    public void testNettyConnectionLimit() throws Exception {
        ServerLocator locator = this.createNonHALocator(true).setCallTimeout(3000L);
        ClientSessionFactory clientSessionFactory = locator.createSessionFactory();
        ClientSession clientSession = this.addClientSession(clientSessionFactory.createSession());
        try {
            ClientSessionFactory extraClientSessionFactory = locator.createSessionFactory();
            ClientSession extraClientSession = this.addClientSession(extraClientSessionFactory.createSession());
            Assertions.fail((String)"creating a session here should fail");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQConnectionTimedOutException));
        }
    }
}

