/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueueConfigPersistenceTest
extends ActiveMQTestBase {
    @Test
    public void testPauseQueue() throws Exception {
        int i;
        ActiveMQServer server = this.createServer(true, false);
        server.start();
        Queue queue = server.createQueue(QueueConfiguration.of((String)"q1").setRoutingType(RoutingType.ANYCAST));
        queue.pause(true);
        server.stop();
        server.start();
        for (i = 0; i < 4; ++i) {
            server.stop();
            server.start();
            queue = server.locateQueue(SimpleString.of((String)"q1"));
            Assertions.assertTrue((boolean)queue.isPaused());
        }
        queue.resume();
        for (i = 0; i < 4; ++i) {
            server.stop();
            server.start();
            queue = server.locateQueue(SimpleString.of((String)"q1"));
            Assertions.assertFalse((boolean)queue.isPaused());
        }
        server.stop();
    }

    @Test
    public void testInternalQueue() throws Exception {
        ActiveMQServer server = this.createServer(true, false);
        server.start();
        server.createQueue(QueueConfiguration.of((String)this.getName()).setInternal(Boolean.valueOf(true)));
        server.stop();
        server.start();
        Queue queue = server.locateQueue(this.getName());
        Assertions.assertTrue((boolean)queue.isInternalQueue());
        Assertions.assertNotNull((Object)server.getManagementService().getResource("queue." + this.getName()));
        server.stop();
    }
}

