/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ssl;

import io.netty.handler.ssl.OpenSsl;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class SSLTestBase
extends ActiveMQTestBase {
    protected static final String QUEUE = "ssl.test.queue";
    protected final String PASSWORD = "securepass";
    protected String SERVER_SIDE_KEYSTORE = "server-keystore.jks";
    protected String SERVER_SIDE_TRUSTSTORE = "client-ca-truststore.jks";
    protected String CLIENT_SIDE_TRUSTSTORE = "server-ca-truststore.jks";
    protected String CLIENT_SIDE_KEYSTORE = "client-keystore.jks";
    protected ActiveMQServer server;
    protected TransportConfiguration tc;
    protected String sslProvider;
    protected String clientSslProvider;

    @Parameters(name="sslProvider={0},clientProvider={1}")
    public static Collection getParameters() {
        return Arrays.asList({"OPENSSL", "JDK"}, {"OPENSSL", "OPENSSL"}, {"JDK", "JDK"}, {"JDK", "OPENSSL"});
    }

    public SSLTestBase(String sslProvider, String clientSslProvider) {
        this.sslProvider = sslProvider;
        this.clientSslProvider = clientSslProvider;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.configureSSLParameters(params);
        ConfigurationImpl config = this.createBasicConfig();
        config.addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, this.getNettyAcceptorName()));
        config.addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), null, (boolean)false));
        this.server.start();
        this.waitForServerToStart(this.server);
        this.tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        this.tc.getParams().put("host", params.get("host"));
        this.tc.getParams().put("port", params.get("port"));
        this.tc.getParams().put("sslProvider", this.clientSslProvider);
    }

    protected void configureSSLParameters(Map<String, Object> params) {
        params.put("sslEnabled", true);
        params.put("sslProvider", this.sslProvider);
        params.put("keyStoreType", "JKS");
        params.put("keyStorePath", this.SERVER_SIDE_KEYSTORE);
        params.put("keyStorePassword", "securepass");
        params.put("host", "localhost");
        params.put("port", "61617");
    }

    public String getNettyAcceptorName() {
        return "SSLTestAcceptor";
    }

    protected boolean isOpenSSLSupported() {
        if (this.sslProvider.equals("OPENSSL") || this.clientSslProvider.equals("OPENSSL")) {
            return OpenSsl.isAvailable();
        }
        return true;
    }
}

