/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompAuditLoggingTest
extends StompTestBase {
    private static final String BASE_AUDIT_LOGGER_NAME = AuditLogger.BASE_LOGGER.getLogger().getName();
    private static AssertionLoggerHandler.LogLevel previousLevel = null;
    private static AssertionLoggerHandler loggerHandler;
    protected StompClientConnection conn;
    private final String user = "nopriv";
    private final String pass = "nopriv";
    private final String role = "nopriv";

    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        this.server = super.createServer();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("nopriv", "nopriv");
        securityManager.getConfiguration().addRole("nopriv", "nopriv");
        this.server.getConfiguration().getSecurityRoles().put("#", new HashSet<Role>(Set.of(new Role("nopriv", false, false, false, false, false, false, false, false, false, false, false, false))));
        return this.server;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
    }

    @BeforeAll
    public static void prepareLogger() {
        previousLevel = AssertionLoggerHandler.setLevel((String)BASE_AUDIT_LOGGER_NAME, (AssertionLoggerHandler.LogLevel)AssertionLoggerHandler.LogLevel.INFO);
        loggerHandler = new AssertionLoggerHandler();
    }

    @AfterAll
    public static void clearLogger() throws Exception {
        try {
            loggerHandler.close();
        }
        finally {
            AssertionLoggerHandler.setLevel((String)BASE_AUDIT_LOGGER_NAME, (AssertionLoggerHandler.LogLevel)previousLevel);
        }
    }

    @TestTemplate
    public void testAuthzFailureAuditLogging() throws Exception {
        this.conn.connect("nopriv", "nopriv");
        ClientStompFrame frame = this.conn.createFrame("SEND");
        frame.addHeader("destination", StompAuditLoggingTest.getQueuePrefix() + StompAuditLoggingTest.getQueueName());
        frame.setBody(RandomUtil.randomString());
        try {
            this.conn.sendFrame(frame);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.disconnect();
        Wait.assertTrue(() -> loggerHandler.matchText(".*User nopriv\\(nopriv\\).* gets security check failure.*"), (long)2000L, (long)100L);
    }
}

