/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.web;

import java.util.Properties;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.BindingDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebServerDTOConfigTest {
    private static final String INVALID_ATTRIBUTE_NAME = "invalidAttribute";
    private static final String BINDING_TEST_NAME = "test-binding";
    private static final String BINDING_TEST_URL = "http://localhost:61616";
    private static final String APP_TEST_NAME = "test-app";
    private static final String APP_TEST_URL = "test-url";

    @Test
    public void testSetWebProperties() throws Throwable {
        WebServerDTO webServer = new WebServerDTO();
        Properties properties = new Properties();
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "customizer", "customizerTest");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "rootRedirectLocation", "locationTest");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "webContentEnabled", "true");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "scanPeriod", "1234");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + INVALID_ATTRIBUTE_NAME, "true");
        ConfigurationImpl configuration = new ConfigurationImpl();
        String systemWebPropertyPrefix = ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix();
        configuration.parsePrefixedProperties((Object)webServer, "system-" + systemWebPropertyPrefix, properties, systemWebPropertyPrefix);
        Assertions.assertEquals((Object)"customizerTest", (Object)webServer.getCustomizer());
        Assertions.assertEquals((Object)"locationTest", (Object)webServer.getRootRedirectLocation());
        Boolean webContentEnabled = webServer.getWebContentEnabled();
        Assertions.assertNotNull((Object)webContentEnabled);
        Assertions.assertTrue((boolean)webContentEnabled);
        Assertions.assertEquals((Integer)1234, (Integer)webServer.getScanPeriod());
        this.testStatus(configuration.getStatus(), "system-" + systemWebPropertyPrefix, "");
    }

    @Test
    public void testSetNewWebBindingProperties() throws Throwable {
        WebServerDTO webServer = new WebServerDTO();
        this.testSetWebBindingProperties(webServer, BINDING_TEST_NAME);
    }

    @Test
    public void testSetExistingWebBindingProperties() throws Throwable {
        WebServerDTO webServer = new WebServerDTO();
        BindingDTO exitingBinding = new BindingDTO();
        exitingBinding.setName(BINDING_TEST_NAME);
        webServer.addBinding(exitingBinding);
        this.testSetWebBindingProperties(webServer, BINDING_TEST_NAME);
    }

    @Test
    public void testSetExistingWebBindingWithoutNameProperties() throws Throwable {
        WebServerDTO webServer = new WebServerDTO();
        BindingDTO exitingBinding = new BindingDTO();
        exitingBinding.setUri(BINDING_TEST_URL);
        webServer.addBinding(exitingBinding);
        this.testSetWebBindingProperties(webServer, BINDING_TEST_URL);
    }

    private void testSetWebBindingProperties(WebServerDTO webServer, String bindingName) throws Throwable {
        Properties properties = new Properties();
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".uri", BINDING_TEST_URL);
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".clientAuth", "true");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".passwordCodec", "test-passwordCodec");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".keyStorePath", "test-keyStorePath");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".trustStorePath", "test-trustStorePath");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".keyStoreType", "test-keyStoreType");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".trustStoreType", "test-trustStoreType");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".includedTLSProtocols", "test-includedTLSProtocols,0");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".excludedTLSProtocols", "test-excludedTLSProtocols,1");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".includedCipherSuites", "test-includedCipherSuites,2");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".excludedCipherSuites", "test-excludedCipherSuites,3");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".keyStorePassword", "test-keyStorePassword");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".trustStorePassword", "test-trustStorePassword");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".sniHostCheck", (Object)false);
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".sniRequired", (Object)true);
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".sslAutoReload", (Object)true);
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".invalidAttribute", "true");
        ConfigurationImpl configuration = new ConfigurationImpl();
        String systemWebPropertyPrefix = ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix();
        configuration.parsePrefixedProperties((Object)webServer, "system-" + systemWebPropertyPrefix, properties, systemWebPropertyPrefix);
        BindingDTO testBinding = webServer.getAllBindings().stream().filter(binding -> bindingName.equals(binding.getName())).findFirst().get();
        Assertions.assertEquals((Object)BINDING_TEST_URL, (Object)testBinding.getUri());
        Boolean getClientAuth = testBinding.getClientAuth();
        Assertions.assertNotNull((Object)getClientAuth);
        Assertions.assertTrue((boolean)getClientAuth);
        Assertions.assertEquals((Object)"test-passwordCodec", (Object)testBinding.getPasswordCodec());
        Assertions.assertEquals((Object)"test-keyStorePath", (Object)testBinding.getKeyStorePath());
        Assertions.assertEquals((Object)"test-trustStorePath", (Object)testBinding.getTrustStorePath());
        Assertions.assertEquals((Object)"test-keyStoreType", (Object)testBinding.getKeyStoreType());
        Assertions.assertEquals((Object)"test-trustStoreType", (Object)testBinding.getTrustStoreType());
        Assertions.assertEquals((Object)"test-includedTLSProtocols,0", (Object)String.join((CharSequence)",", testBinding.getIncludedTLSProtocols()));
        Assertions.assertEquals((Object)"test-excludedTLSProtocols,1", (Object)String.join((CharSequence)",", testBinding.getExcludedTLSProtocols()));
        Assertions.assertEquals((Object)"test-includedCipherSuites,2", (Object)String.join((CharSequence)",", testBinding.getIncludedCipherSuites()));
        Assertions.assertEquals((Object)"test-excludedCipherSuites,3", (Object)String.join((CharSequence)",", testBinding.getExcludedCipherSuites()));
        Assertions.assertEquals((Object)"test-keyStorePassword", (Object)testBinding.getKeyStorePassword());
        Assertions.assertEquals((Object)"test-trustStorePassword", (Object)testBinding.getTrustStorePassword());
        Assertions.assertEquals((Object)false, (Object)testBinding.getSniHostCheck());
        Assertions.assertEquals((Object)true, (Object)testBinding.getSniRequired());
        Assertions.assertEquals((Object)true, (Object)testBinding.getSslAutoReload());
        this.testStatus(configuration.getStatus(), "system-" + systemWebPropertyPrefix, "bindings." + bindingName + ".");
    }

    @Test
    public void testSetNewWebBindingAppProperties() throws Throwable {
        WebServerDTO webServer = new WebServerDTO();
        this.testSetWebBindingAppProperties(webServer, BINDING_TEST_NAME, APP_TEST_NAME);
    }

    @Test
    public void testSetExistingWebBindingAppProperties() throws Throwable {
        WebServerDTO webServer = new WebServerDTO();
        BindingDTO exitingBinding = new BindingDTO();
        exitingBinding.setName(BINDING_TEST_NAME);
        AppDTO existingApp = new AppDTO();
        existingApp.setName(APP_TEST_NAME);
        exitingBinding.addApp(existingApp);
        webServer.addBinding(exitingBinding);
        this.testSetWebBindingAppProperties(webServer, BINDING_TEST_NAME, APP_TEST_NAME);
    }

    @Test
    public void testSetExistingWebBindingAppWithoutNameProperties() throws Throwable {
        WebServerDTO webServer = new WebServerDTO();
        BindingDTO exitingBinding = new BindingDTO();
        exitingBinding.setName(BINDING_TEST_NAME);
        AppDTO existingApp = new AppDTO();
        existingApp.setUrl(APP_TEST_URL);
        exitingBinding.addApp(existingApp);
        webServer.addBinding(exitingBinding);
        this.testSetWebBindingAppProperties(webServer, BINDING_TEST_NAME, APP_TEST_URL);
    }

    @Test
    public void testSetRequestLogProperties() throws Throwable {
        WebServerDTO webServer = new WebServerDTO();
        Properties properties = new Properties();
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "requestLog.filename", "filenameTest");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "requestLog.append", "true");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "requestLog.extended", "true");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "requestLog.filenameDateFormat", "filenameDateFormatTest");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "requestLog.retainDays", "3");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "requestLog.ignorePaths", "ignorePathTest0,ignorePathTest1,ignorePathTest2");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "requestLog.invalidAttribute", "true");
        ConfigurationImpl configuration = new ConfigurationImpl();
        String systemWebPropertyPrefix = ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix();
        configuration.parsePrefixedProperties((Object)webServer, "system-" + systemWebPropertyPrefix, properties, systemWebPropertyPrefix);
        Assertions.assertEquals((Object)"filenameTest", (Object)webServer.getRequestLog().getFilename());
        Boolean getAppend = webServer.getRequestLog().getAppend();
        Assertions.assertNotNull((Object)getAppend);
        Assertions.assertTrue((boolean)getAppend);
        Boolean getExtended = webServer.getRequestLog().getExtended();
        Assertions.assertNotNull((Object)getExtended);
        Assertions.assertTrue((boolean)getExtended);
        Assertions.assertEquals((Object)"filenameDateFormatTest", (Object)webServer.getRequestLog().getFilenameDateFormat());
        Assertions.assertEquals((Integer)3, (Integer)webServer.getRequestLog().getRetainDays());
        Assertions.assertEquals((Object)"ignorePathTest0,ignorePathTest1,ignorePathTest2", (Object)webServer.getRequestLog().getIgnorePaths());
        this.testStatus(configuration.getStatus(), "system-" + systemWebPropertyPrefix, "requestLog.");
    }

    private void testSetWebBindingAppProperties(WebServerDTO webServer, String bindingName, String appName) throws Throwable {
        Properties properties = new Properties();
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".apps." + appName + ".url", APP_TEST_URL);
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".apps." + appName + ".war", "test-war");
        properties.put(ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix() + "bindings." + bindingName + ".apps." + appName + ".invalidAttribute", "true");
        ConfigurationImpl configuration = new ConfigurationImpl();
        String systemWebPropertyPrefix = ActiveMQDefaultConfiguration.getDefaultSystemWebPropertyPrefix();
        configuration.parsePrefixedProperties((Object)webServer, "system-" + systemWebPropertyPrefix, properties, systemWebPropertyPrefix);
        BindingDTO testBinding = webServer.getAllBindings().stream().filter(binding -> bindingName.equals(binding.getName())).findFirst().get();
        AppDTO testApp = testBinding.getApps().stream().filter(app -> appName.equals(app.getName())).findFirst().get();
        Assertions.assertEquals((Object)APP_TEST_URL, (Object)testApp.getUrl());
        Assertions.assertEquals((Object)"test-war", (Object)testApp.getWar());
        this.testStatus(configuration.getStatus(), "system-" + systemWebPropertyPrefix, "bindings." + bindingName + ".apps." + appName + ".");
    }

    private void testStatus(String status, String name, String prefix) {
        Assertions.assertNotNull((Object)status);
        JsonObject statusJsonObject = JsonUtil.readJsonObject((String)status);
        Assertions.assertNotNull((Object)statusJsonObject);
        JsonObject propertiesJsonObject = statusJsonObject.getJsonObject("properties");
        Assertions.assertNotNull((Object)propertiesJsonObject);
        JsonObject systemWebPropertiesJsonObject = propertiesJsonObject.getJsonObject(name);
        Assertions.assertNotNull((Object)systemWebPropertiesJsonObject);
        JsonArray errorsJsonObject = systemWebPropertiesJsonObject.getJsonArray("errors");
        Assertions.assertNotNull((Object)errorsJsonObject);
        Assertions.assertEquals((Object)(prefix + "invalidAttribute=true"), (Object)errorsJsonObject.getJsonObject(0).getString("value"));
    }
}

