/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.config.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ConnectorServiceFactory;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.impl.ConnectorsService;
import org.apache.activemq.artemis.core.server.impl.ServiceRegistryImpl;
import org.apache.activemq.artemis.tests.unit.core.config.impl.fakes.FakeConnectorService;
import org.apache.activemq.artemis.tests.unit.core.config.impl.fakes.FakeConnectorServiceFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectorsServiceTest
extends ActiveMQTestBase {
    private Configuration configuration;
    private ServiceRegistry serviceRegistry;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.configuration = new ConfigurationImpl();
        this.serviceRegistry = new ServiceRegistryImpl();
    }

    @Test
    public void testConnectorsServiceUsesInjectedConnectorServiceFactory() throws Exception {
        ConnectorServiceConfiguration connectorServiceConfiguration = new ConnectorServiceConfiguration().setFactoryClassName(null).setParams(new HashMap()).setName("myfact");
        FakeConnectorService connectorService = new FakeConnectorService();
        FakeConnectorServiceFactory connectorServiceFactory = new FakeConnectorServiceFactory();
        this.serviceRegistry.addConnectorService((ConnectorServiceFactory)connectorServiceFactory, connectorServiceConfiguration);
        ConnectorsService connectorsService = new ConnectorsService(this.configuration, null, null, null, this.serviceRegistry);
        connectorsService.start();
        Assertions.assertTrue((connectorsService.getConnectors().size() == 1 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((boolean)connectorsService.getConnectors().values().contains(connectorServiceFactory.getConnectorService()));
    }

    @Test
    public void testConnectorsServiceUsesConfiguredConnectorServices() throws Exception {
        ConnectorServiceConfiguration connectorServiceConfiguration = new ConnectorServiceConfiguration().setFactoryClassName(FakeConnectorServiceFactory.class.getCanonicalName()).setParams(new HashMap()).setName("myfact");
        ArrayList<ConnectorServiceConfiguration> connectorServiceConfigurations = new ArrayList<ConnectorServiceConfiguration>();
        connectorServiceConfigurations.add(connectorServiceConfiguration);
        this.configuration.setConnectorServiceConfigurations(connectorServiceConfigurations);
        ConnectorsService connectorsService = new ConnectorsService(this.configuration, null, null, null, this.serviceRegistry);
        connectorsService.start();
        Assertions.assertTrue((connectorsService.getConnectors().size() == 1 ? (byte)1 : 0) != 0);
    }

    @Test
    public void testConnectorServiceUsedDirectly() throws Exception {
        ConnectorServiceConfiguration connectorServiceConfiguration = new ConnectorServiceConfiguration().setFactoryClassName(FakeConnectorServiceFactory.class.getCanonicalName()).setParams(new HashMap()).setName("myfact");
        this.configuration.setConnectorServiceConfigurations(Arrays.asList(connectorServiceConfiguration));
        ConnectorsService connectorsService = new ConnectorsService(this.configuration, null, null, null, this.serviceRegistry);
        connectorsService.start();
        Assertions.assertEquals((int)1, (int)connectorsService.getConnectors().size());
        FakeConnectorServiceFactory connectorServiceFactory = new FakeConnectorServiceFactory();
        try {
            connectorsService.createService(connectorServiceConfiguration, (ConnectorServiceFactory)connectorServiceFactory);
            Assertions.assertTrue((boolean)false, (String)"Expected exception when creating service with same name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConnectorServiceConfiguration additionalServiceConfiguration = new ConnectorServiceConfiguration().setFactoryClassName(FakeConnectorServiceFactory.class.getCanonicalName()).setParams(new HashMap()).setName("myfact2");
        connectorsService.createService(additionalServiceConfiguration, (ConnectorServiceFactory)connectorServiceFactory);
        Assertions.assertEquals((int)2, (int)connectorsService.getConnectors().size());
        connectorsService.destroyService("myfact");
        Assertions.assertEquals((int)1, (int)connectorsService.getConnectors().size());
        connectorsService.destroyService("myfact2");
        Assertions.assertEquals((int)0, (int)connectorsService.getConnectors().size());
        try {
            connectorsService.destroyService("myfact");
            Assertions.assertTrue((boolean)false, (String)"Expected exception when destroying non-existing service");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

