/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.client;

import jakarta.jms.MessageFormatException;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ActiveMQMapMessageTest
extends ActiveMQTestBase {
    private String itemName;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.itemName = RandomUtil.randomString();
    }

    @Test
    public void testClearBody() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setBoolean(this.itemName, true);
        Assertions.assertTrue((boolean)message.itemExists(this.itemName));
        message.clearBody();
        Assertions.assertFalse((boolean)message.itemExists(this.itemName));
    }

    @Test
    public void testGetType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        Assertions.assertEquals((byte)5, (byte)message.getType());
    }

    @Test
    public void testCheckItemNameIsNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.setBoolean(null, true);
            Assertions.fail((String)"item name can not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckItemNameIsEmpty() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.setBoolean("", true);
            Assertions.fail((String)"item name can not be empty");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBooleanFromBoolean() throws Exception {
        boolean value = true;
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setBoolean(this.itemName, value);
        Assertions.assertEquals((Object)value, (Object)message.getBoolean(this.itemName));
    }

    @Test
    public void testGetBooleanFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        Assertions.assertFalse((boolean)message.getBoolean(this.itemName));
    }

    @Test
    public void testGetBooleanFromString() throws Exception {
        boolean value = true;
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString(this.itemName, Boolean.toString(value));
        Assertions.assertEquals((Object)value, (Object)message.getBoolean(this.itemName));
    }

    @Test
    public void testGetBooleanFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, RandomUtil.randomFloat());
        try {
            message.getBoolean(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetByteFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setByte(this.itemName, value);
        Assertions.assertEquals((byte)value, (byte)message.getByte(this.itemName));
    }

    @Test
    public void testGetByteFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.getByte(this.itemName);
            Assertions.fail((String)"NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetByteFromString() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString(this.itemName, Byte.toString(value));
        Assertions.assertEquals((byte)value, (byte)message.getByte(this.itemName));
    }

    @Test
    public void testGetByteFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, RandomUtil.randomFloat());
        try {
            message.getByte(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetShortFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setByte(this.itemName, value);
        Assertions.assertEquals((short)value, (short)message.getShort(this.itemName));
    }

    @Test
    public void testGetShortFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setShort(this.itemName, value);
        Assertions.assertEquals((short)value, (short)message.getShort(this.itemName));
    }

    @Test
    public void testGetShortFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.getShort(this.itemName);
            Assertions.fail((String)"NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetShortFromString() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString(this.itemName, Short.toString(value));
        Assertions.assertEquals((short)value, (short)message.getShort(this.itemName));
    }

    @Test
    public void testGetShortFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, RandomUtil.randomFloat());
        try {
            message.getShort(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetIntFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setByte(this.itemName, value);
        Assertions.assertEquals((int)value, (int)message.getInt(this.itemName));
    }

    @Test
    public void testGetIntFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setShort(this.itemName, value);
        Assertions.assertEquals((int)value, (int)message.getInt(this.itemName));
    }

    @Test
    public void testGetIntFromInt() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setInt(this.itemName, value);
        Assertions.assertEquals((int)value, (int)message.getInt(this.itemName));
    }

    @Test
    public void testGetIntFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.getInt(this.itemName);
            Assertions.fail((String)"NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetIntFromString() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString(this.itemName, Integer.toString(value));
        Assertions.assertEquals((int)value, (int)message.getInt(this.itemName));
    }

    @Test
    public void testGetIntFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, RandomUtil.randomFloat());
        try {
            message.getInt(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetCharFromChar() throws Exception {
        char value = RandomUtil.randomChar();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setChar(this.itemName, value);
        Assertions.assertEquals((char)value, (char)message.getChar(this.itemName));
    }

    @Test
    public void testGetCharFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.getChar(this.itemName);
            Assertions.fail((String)"NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetCharFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, RandomUtil.randomFloat());
        try {
            message.getChar(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLongFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setByte(this.itemName, value);
        Assertions.assertEquals((long)value, (long)message.getLong(this.itemName));
    }

    @Test
    public void testGetLongFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setShort(this.itemName, value);
        Assertions.assertEquals((long)value, (long)message.getLong(this.itemName));
    }

    @Test
    public void testGetLongFromInt() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setInt(this.itemName, value);
        Assertions.assertEquals((long)value, (long)message.getLong(this.itemName));
    }

    @Test
    public void testGetLongFromLong() throws Exception {
        long value = RandomUtil.randomLong();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setLong(this.itemName, value);
        Assertions.assertEquals((long)value, (long)message.getLong(this.itemName));
    }

    @Test
    public void testGetLongFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.getLong(this.itemName);
            Assertions.fail((String)"NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLongFromString() throws Exception {
        long value = RandomUtil.randomLong();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString(this.itemName, Long.toString(value));
        Assertions.assertEquals((long)value, (long)message.getLong(this.itemName));
    }

    @Test
    public void testGetLongFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, RandomUtil.randomFloat());
        try {
            message.getLong(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFloatFromFloat() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, value);
        Assertions.assertEquals((double)value, (double)message.getFloat(this.itemName), (double)1.0E-6);
    }

    @Test
    public void testGetFloatFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.getFloat(this.itemName);
            Assertions.fail((String)"NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFloatFromString() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString(this.itemName, Float.toString(value));
        Assertions.assertEquals((double)value, (double)message.getFloat(this.itemName), (double)1.0E-6);
    }

    @Test
    public void testGetFloatFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setChar(this.itemName, RandomUtil.randomChar());
        try {
            message.getFloat(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDoubleFromFloat() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, value);
        Assertions.assertEquals((double)Float.valueOf(value).doubleValue(), (double)message.getDouble(this.itemName), (double)1.0E-6);
    }

    @Test
    public void testGetDoubleFromDouble() throws Exception {
        double value = RandomUtil.randomDouble();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setDouble(this.itemName, value);
        Assertions.assertEquals((double)value, (double)message.getDouble(this.itemName), (double)1.0E-6);
    }

    @Test
    public void testGetDoubleFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        try {
            message.getDouble(this.itemName);
            Assertions.fail((String)"NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDoubleFromString() throws Exception {
        double value = RandomUtil.randomDouble();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString(this.itemName, Double.toString(value));
        Assertions.assertEquals((double)value, (double)message.getDouble(this.itemName), (double)1.0E-6);
    }

    @Test
    public void testGetDoubleFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setChar(this.itemName, RandomUtil.randomChar());
        try {
            message.getDouble(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStringFromBoolean() throws Exception {
        boolean value = RandomUtil.randomBoolean();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setBoolean(this.itemName, value);
        Assertions.assertEquals((Object)Boolean.toString(value), (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromByte() throws Exception {
        byte value = RandomUtil.randomByte();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setByte(this.itemName, value);
        Assertions.assertEquals((Object)Byte.toString(value), (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromChar() throws Exception {
        char value = RandomUtil.randomChar();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setChar(this.itemName, value);
        Assertions.assertEquals((Object)Character.toString(value), (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromShort() throws Exception {
        short value = RandomUtil.randomShort();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setShort(this.itemName, value);
        Assertions.assertEquals((Object)Short.toString(value), (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromInt() throws Exception {
        int value = RandomUtil.randomInt();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setInt(this.itemName, value);
        Assertions.assertEquals((Object)Integer.toString(value), (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromLong() throws Exception {
        long value = RandomUtil.randomLong();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setLong(this.itemName, value);
        Assertions.assertEquals((Object)Long.toString(value), (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromFloat() throws Exception {
        float value = RandomUtil.randomFloat();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setFloat(this.itemName, value);
        Assertions.assertEquals((Object)Float.toString(value), (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromDouble() throws Exception {
        double value = RandomUtil.randomByte();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setDouble(this.itemName, value);
        Assertions.assertEquals((Object)Double.toString(value), (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        Assertions.assertNull((Object)message.getString(this.itemName));
    }

    @Test
    public void testGetStringFromString() throws Exception {
        String value = RandomUtil.randomString();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString(this.itemName, value);
        Assertions.assertEquals((Object)value, (Object)message.getString(this.itemName));
    }

    @Test
    public void testGetBytesFromBytes() throws Exception {
        byte[] value = RandomUtil.randomBytes();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setBytes(this.itemName, value);
        ActiveMQTestBase.assertEqualsByteArrays(value, message.getBytes(this.itemName));
    }

    @Test
    public void testGetBytesFromNull() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        Assertions.assertNull((Object)message.getBytes(this.itemName));
    }

    @Test
    public void testGetBytesFromInvalidType() throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setChar(this.itemName, RandomUtil.randomChar());
        try {
            message.getBytes(this.itemName);
            Assertions.fail((String)"MessageFormatException");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testSetObjectFromBoolean() throws Exception {
        boolean value = RandomUtil.randomBoolean();
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setObject(this.itemName, (Object)value);
        Assertions.assertEquals((Object)value, (Object)message.getObject(this.itemName));
    }

    @Test
    public void testSetObjectFromByte() throws Exception {
        this.doTestSetObject(RandomUtil.randomByte());
    }

    @Test
    public void testSetObjectFromShort() throws Exception {
        this.doTestSetObject(RandomUtil.randomShort());
    }

    @Test
    public void testSetObjectFromChar() throws Exception {
        this.doTestSetObject(Character.valueOf(RandomUtil.randomChar()));
    }

    @Test
    public void testSetObjectFromInt() throws Exception {
        this.doTestSetObject(RandomUtil.randomInt());
    }

    @Test
    public void testSetObjectFromLong() throws Exception {
        this.doTestSetObject(RandomUtil.randomLong());
    }

    @Test
    public void testSetObjectFromFloat() throws Exception {
        this.doTestSetObject(Float.valueOf(RandomUtil.randomFloat()));
    }

    @Test
    public void testSetObjectFromDouble() throws Exception {
        this.doTestSetObject(RandomUtil.randomDouble());
    }

    @Test
    public void testSetObjectFromString() throws Exception {
        this.doTestSetObject(RandomUtil.randomString());
    }

    @Test
    public void testSetObjectFromBytes() throws Exception {
        this.doTestSetObject(RandomUtil.randomBytes());
    }

    private void doTestSetObject(Object value) throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setObject(this.itemName, value);
        Assertions.assertEquals((Object)value, (Object)message.getObject(this.itemName));
    }
}

