/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.ra;

import jakarta.resource.spi.InvalidPropertyException;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationValidationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActiveMQActivationsSpecTest {
    @Test
    public void nullDestinationName() throws InvalidPropertyException {
        Assertions.assertThrows(InvalidPropertyException.class, () -> ActiveMQActivationValidationUtils.validate(null, (String)"destinationType", (Boolean)false, (String)"subscriptionName"));
    }

    @Test
    public void emptyDestinationName() throws InvalidPropertyException {
        Assertions.assertThrows(InvalidPropertyException.class, () -> ActiveMQActivationValidationUtils.validate(null, (String)"destinationType", (Boolean)false, (String)"subscriptionName"));
    }

    public void nullDestinationType() throws InvalidPropertyException {
        ActiveMQActivationValidationUtils.validate((String)"destinationName", null, (Boolean)false, (String)"subscriptionName");
    }

    @Test
    public void emptyDestinationType() throws InvalidPropertyException {
        Assertions.assertThrows(InvalidPropertyException.class, () -> ActiveMQActivationValidationUtils.validate((String)"destinationName", (String)"", (Boolean)false, (String)"subscriptionName"));
    }

    @Test
    public void subscriptionDurableButNoName() throws InvalidPropertyException {
        Assertions.assertThrows(InvalidPropertyException.class, () -> ActiveMQActivationValidationUtils.validate((String)"", (String)"", (Boolean)true, (String)"subscriptionName"));
    }

    @Test
    public void validateAcknowledgeMode() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Assertions.assertEquals((int)ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"DUPS_OK_ACKNOWLEDGE"), (int)3);
            Assertions.assertEquals((int)ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"Dups-ok-acknowledge"), (int)3);
            Assertions.assertEquals((int)ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"AUTO_ACKNOWLEDGE"), (int)1);
            Assertions.assertEquals((int)ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"Auto-acknowledge"), (int)1);
            ActiveMQActivationValidationUtils.validateAcknowledgeMode((String)"Invalid Acknowledge Mode");
        });
    }
}

