/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.server.config.JMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.JMSConfigurationImpl;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.unit.util.InVMNamingContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class JMSClusteredTestBase
extends ActiveMQTestBase {
    protected MBeanServer mBeanServer1;
    protected ActiveMQServer server1;
    protected JMSServerManagerImpl jmsServer1;
    protected MBeanServer mBeanServer2;
    protected ActiveMQServer server2;
    protected JMSServerManagerImpl jmsServer2;
    protected ConnectionFactory cf1;
    protected ConnectionFactory cf2;
    protected InVMNamingContext context1;
    protected InVMNamingContext context2;
    protected static final int MAX_HOPS = 1;

    protected Queue createQueue(String name) throws Exception {
        this.jmsServer2.createQueue(false, name, null, true, new String[]{"/queue/" + name});
        this.jmsServer1.createQueue(false, name, null, true, new String[]{"/queue/" + name});
        Assertions.assertTrue((boolean)this.waitForBindings(this.server1, name, false, 1, 0, 10000L));
        Assertions.assertTrue((boolean)this.waitForBindings(this.server2, name, false, 1, 0, 10000L));
        return (Queue)this.context1.lookup("/queue/" + name);
    }

    protected Topic createTopic(String name) throws Exception {
        return this.createTopic(name, false);
    }

    protected Topic createTopic(String name, boolean durable) throws Exception {
        this.jmsServer2.createTopic(durable, name, new String[]{"/topic/" + name});
        this.jmsServer1.createTopic(durable, name, new String[]{"/topic/" + name});
        return (Topic)this.context1.lookup("/topic/" + name);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServer2();
        this.setupServer1();
        this.jmsServer1.start();
        this.jmsServer1.activated();
        this.waitForServerToStart(this.jmsServer1.getActiveMQServer());
        this.jmsServer2.start();
        this.jmsServer2.activated();
        this.waitForServerToStart(this.jmsServer2.getActiveMQServer());
        JMSClusteredTestBase.waitForTopology(this.jmsServer1.getActiveMQServer(), 2);
        JMSClusteredTestBase.waitForTopology(this.jmsServer2.getActiveMQServer(), 2);
        this.cf1 = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), this.generateInVMParams(1))});
        this.cf2 = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), this.generateInVMParams(2))});
    }

    private void setupServer2() throws Exception {
        Configuration configuration = this.createConfigServer(2, 1);
        JMSConfigurationImpl jmsconfig = new JMSConfigurationImpl();
        this.mBeanServer2 = this.createMBeanServer();
        this.server2 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (MBeanServer)this.mBeanServer2, (boolean)this.enablePersistence()));
        this.jmsServer2 = new JMSServerManagerImpl(this.server2, (JMSConfiguration)jmsconfig);
        this.context2 = new InVMNamingContext();
        this.jmsServer2.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)this.context2));
    }

    private void setupServer1() throws Exception {
        Configuration configuration = this.createConfigServer(1, 2);
        JMSConfigurationImpl jmsconfig = new JMSConfigurationImpl();
        this.mBeanServer1 = this.createMBeanServer();
        this.server1 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (MBeanServer)this.mBeanServer1, (boolean)this.enablePersistence()));
        this.jmsServer1 = new JMSServerManagerImpl(this.server1, (JMSConfiguration)jmsconfig);
        this.context1 = new InVMNamingContext();
        this.jmsServer1.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)this.context1));
    }

    protected boolean enablePersistence() {
        return false;
    }

    protected Configuration createConfigServer(int source, int destination) throws Exception {
        String destinationLabel = "toServer" + destination;
        String sourceLabel = "server" + source;
        Configuration configuration = this.createDefaultInVMConfig(source).setSecurityEnabled(false).setJMXManagementEnabled(true).setPersistenceEnabled(false).addConnectorConfiguration(destinationLabel, new TransportConfiguration(InVMConnectorFactory.class.getName(), this.generateInVMParams(destination))).addConnectorConfiguration(sourceLabel, new TransportConfiguration(InVMConnectorFactory.class.getName(), this.generateInVMParams(source))).addClusterConfiguration(new ClusterConnectionConfiguration().setName(destinationLabel).setConnectorName(sourceLabel).setRetryInterval(250L).setMaxHops(1).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(new ArrayList<CallSite>(List.of(destinationLabel))));
        configuration.getAddressSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        return configuration;
    }
}

