/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import jakarta.jms.InvalidDestinationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpAbstractResource;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpJmsSelectorFilter;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpNoLocalFilter;
import org.apache.activemq.transport.amqp.client.AmqpOperationTimedOutException;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.util.AsyncResult;
import org.apache.activemq.transport.amqp.client.util.ClientFuture;
import org.apache.activemq.transport.amqp.client.util.IOExceptionSupport;
import org.apache.activemq.transport.amqp.client.util.UnmodifiableProxy;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpReceiver
extends AmqpAbstractResource<Receiver> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AtomicBoolean closed = new AtomicBoolean();
    private final BlockingQueue<AmqpMessage> prefetch = new LinkedBlockingDeque<AmqpMessage>();
    private final AmqpSession session;
    private final String address;
    private final String receiverId;
    private final Source userSpecifiedSource;
    private final SenderSettleMode userSpecifiedSenderSettlementMode;
    private final ReceiverSettleMode userSpecifiedReceiverSettlementMode;
    private String subscriptionName;
    private String selector;
    private boolean presettle;
    private boolean noLocal;
    private Map<Symbol, Object> properties;
    private AsyncResult pullRequest;
    private AsyncResult stopRequest;

    public int getPrefetchSize() {
        return this.prefetch.size();
    }

    public AmqpReceiver(AmqpSession session, String address, String receiverId) {
        this(session, address, receiverId, null, null);
    }

    public AmqpReceiver(AmqpSession session, String address, String receiverId, SenderSettleMode senderMode, ReceiverSettleMode receiverMode) {
        if (address != null && address.isEmpty()) {
            throw new IllegalArgumentException("Address cannot be empty.");
        }
        this.userSpecifiedSource = null;
        this.session = session;
        this.address = address;
        this.receiverId = receiverId;
        this.userSpecifiedSenderSettlementMode = senderMode;
        this.userSpecifiedReceiverSettlementMode = receiverMode;
    }

    public AmqpReceiver(AmqpSession session, Source source, String receiverId) {
        if (source == null) {
            throw new IllegalArgumentException("User specified Source cannot be null");
        }
        this.session = session;
        this.address = source.getAddress();
        this.receiverId = receiverId;
        this.userSpecifiedSource = source;
        this.userSpecifiedSenderSettlementMode = null;
        this.userSpecifiedReceiverSettlementMode = null;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            ClientFuture request = new ClientFuture();
            this.session.getScheduler().execute(() -> {
                this.checkClosed();
                this.close(request);
                this.session.pumpToProtonTransport(request);
            });
            request.sync();
        }
    }

    public void setProperties(Map<Symbol, Object> properties) {
        if (this.getEndpoint() != null) {
            throw new IllegalStateException("Endpoint already established");
        }
        this.properties = properties;
    }

    public void detach() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            ClientFuture request = new ClientFuture();
            this.session.getScheduler().execute(() -> {
                this.checkClosed();
                this.detach(request);
                this.session.pumpToProtonTransport(request);
            });
            request.sync();
        }
    }

    public AmqpSession getSession() {
        return this.session;
    }

    public String getAddress() {
        return this.address;
    }

    public AmqpMessage receive() throws Exception {
        this.checkClosed();
        return this.prefetch.take();
    }

    public AmqpMessage receive(long timeout, TimeUnit unit) throws Exception {
        this.checkClosed();
        return this.prefetch.poll(timeout, unit);
    }

    public AmqpMessage receiveNoWait() throws Exception {
        this.checkClosed();
        return (AmqpMessage)this.prefetch.poll();
    }

    public AmqpMessage pull() throws IOException {
        return this.pull(-1L, TimeUnit.MILLISECONDS);
    }

    public AmqpMessage pullImmediate() throws IOException {
        return this.pull(0L, TimeUnit.MILLISECONDS);
    }

    public AmqpMessage pull(long timeout, TimeUnit unit) throws IOException {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        this.session.getScheduler().execute(() -> {
            this.checkClosed();
            long timeoutMills = unit.toMillis(timeout);
            try {
                logger.trace("Pull on Receiver {} with timeout = {}", (Object)this.getSubscriptionName(), (Object)timeoutMills);
                if (timeoutMills < 0L) {
                    if (((Receiver)this.getEndpoint()).getCredit() == 0) {
                        logger.trace("Receiver {} granting 1 additional credit for pull.", (Object)this.getSubscriptionName());
                        ((Receiver)this.getEndpoint()).flow(1);
                    }
                    this.pullRequest = request;
                } else if (timeoutMills == 0L) {
                    if (((Receiver)this.getEndpoint()).getCredit() == 0) {
                        logger.trace("Receiver {} granting 1 additional credit for pull.", (Object)this.getSubscriptionName());
                        ((Receiver)this.getEndpoint()).flow(1);
                    }
                    this.stop(request);
                } else if (timeoutMills > 0L) {
                    if (((Receiver)this.getEndpoint()).getCredit() == 0) {
                        logger.trace("Receiver {} granting 1 additional credit for pull.", (Object)this.getSubscriptionName());
                        ((Receiver)this.getEndpoint()).flow(1);
                    }
                    this.stopOnSchedule(timeoutMills, request);
                }
                this.session.pumpToProtonTransport(request);
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
        return (AmqpMessage)this.prefetch.poll();
    }

    public void flow(int credit) throws IOException {
        this.flow(credit, false);
    }

    public void flow(int credit, boolean deferWrite) throws IOException {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        this.session.getScheduler().execute(() -> {
            this.checkClosed();
            try {
                ((Receiver)this.getEndpoint()).flow(credit);
                if (!deferWrite) {
                    this.session.pumpToProtonTransport(request);
                }
                request.onSuccess();
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public void drain(int credit) throws IOException {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        this.session.getScheduler().execute(() -> {
            this.checkClosed();
            try {
                ((Receiver)this.getEndpoint()).drain(credit);
                this.session.pumpToProtonTransport(request);
                request.onSuccess();
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public void stop() throws IOException {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        this.session.getScheduler().execute(() -> {
            this.checkClosed();
            try {
                this.stop(request);
                this.session.pumpToProtonTransport(request);
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public void accept(Delivery delivery) throws IOException {
        this.accept(delivery, this.session, true);
    }

    public void accept(Delivery delivery, boolean settle) throws IOException {
        this.accept(delivery, this.session, settle);
    }

    public void accept(Delivery delivery, AmqpSession session) throws IOException {
        this.accept(delivery, session, true);
    }

    public void accept(Delivery delivery, AmqpSession session, boolean settle) throws IOException {
        this.checkClosed();
        if (delivery == null) {
            throw new IllegalArgumentException("Delivery to accept cannot be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session given cannot be null");
        }
        if (session.getConnection() != this.session.getConnection()) {
            throw new IllegalArgumentException("The session used for accept must originate from the connection that created this receiver.");
        }
        ClientFuture request = new ClientFuture();
        session.getScheduler().execute(() -> {
            this.checkClosed();
            try {
                if (!delivery.isSettled()) {
                    if (session.isInTransaction()) {
                        Binary txnId = session.getTransactionId().getRemoteTxId();
                        if (txnId != null) {
                            TransactionalState txState = new TransactionalState();
                            txState.setOutcome((Outcome)Accepted.getInstance());
                            txState.setTxnId(txnId);
                            delivery.disposition((DeliveryState)txState);
                            session.getTransactionContext().registerTxConsumer(this);
                        }
                    } else {
                        delivery.disposition((DeliveryState)Accepted.getInstance());
                    }
                    if (settle) {
                        delivery.settle();
                    }
                }
                session.pumpToProtonTransport(request);
                request.onSuccess();
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public void modified(Delivery delivery, Boolean deliveryFailed, Boolean undeliverableHere) throws IOException {
        this.checkClosed();
        if (delivery == null) {
            throw new IllegalArgumentException("Delivery to reject cannot be null");
        }
        ClientFuture request = new ClientFuture();
        this.session.getScheduler().execute(() -> {
            this.checkClosed();
            try {
                if (!delivery.isSettled()) {
                    Modified disposition = new Modified();
                    disposition.setUndeliverableHere(undeliverableHere);
                    disposition.setDeliveryFailed(deliveryFailed);
                    delivery.disposition((DeliveryState)disposition);
                    delivery.settle();
                    this.session.pumpToProtonTransport(request);
                }
                request.onSuccess();
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public void release(Delivery delivery) throws IOException {
        this.checkClosed();
        if (delivery == null) {
            throw new IllegalArgumentException("Delivery to release cannot be null");
        }
        ClientFuture request = new ClientFuture();
        this.session.getScheduler().execute(() -> {
            this.checkClosed();
            try {
                if (!delivery.isSettled()) {
                    delivery.disposition((DeliveryState)Released.getInstance());
                    delivery.settle();
                    this.session.pumpToProtonTransport(request);
                }
                request.onSuccess();
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public void reject(Delivery delivery) throws IOException {
        this.checkClosed();
        if (delivery == null) {
            throw new IllegalArgumentException("Delivery to release cannot be null");
        }
        ClientFuture request = new ClientFuture();
        this.session.getScheduler().execute(() -> {
            this.checkClosed();
            try {
                if (!delivery.isSettled()) {
                    delivery.disposition((DeliveryState)new Rejected());
                    delivery.settle();
                    this.session.pumpToProtonTransport(request);
                }
                request.onSuccess();
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public Receiver getReceiver() {
        return UnmodifiableProxy.receiverProxy((Receiver)this.getEndpoint());
    }

    public boolean isPresettle() {
        return this.presettle;
    }

    public void setPresettle(boolean presettle) {
        this.presettle = presettle;
    }

    public boolean isDurable() {
        return this.subscriptionName != null;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public long getDrainTimeout() {
        return this.session.getConnection().getDrainTimeout();
    }

    @Override
    protected void doOpen() {
        Source source = this.userSpecifiedSource;
        Target target = new Target();
        if (source == null && this.address != null) {
            source = new Source();
            source.setAddress(this.address);
            this.configureSource(source);
        }
        Object receiverName = this.receiverId + ":" + this.address;
        if (this.getSubscriptionName() != null && !this.getSubscriptionName().isEmpty()) {
            receiverName = this.getSubscriptionName();
        }
        Receiver receiver = ((Session)this.session.getEndpoint()).receiver((String)receiverName);
        receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        if (this.userSpecifiedSenderSettlementMode != null) {
            receiver.setSenderSettleMode(this.userSpecifiedSenderSettlementMode);
            if (SenderSettleMode.SETTLED.equals((Object)this.userSpecifiedSenderSettlementMode)) {
                this.setPresettle(true);
            }
        } else if (this.isPresettle()) {
            receiver.setSenderSettleMode(SenderSettleMode.SETTLED);
        } else {
            receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        }
        if (this.userSpecifiedReceiverSettlementMode != null) {
            receiver.setReceiverSettleMode(this.userSpecifiedReceiverSettlementMode);
        } else {
            receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        }
        if (this.properties != null) {
            receiver.setProperties(this.properties);
        }
        this.setEndpoint(receiver);
        super.doOpen();
    }

    @Override
    protected void doOpenCompletion() {
        org.apache.qpid.proton.amqp.transport.Source s = ((Receiver)this.getEndpoint()).getRemoteSource();
        if (s != null) {
            super.doOpenCompletion();
        }
    }

    @Override
    protected void doClose() {
        ((Receiver)this.getEndpoint()).close();
    }

    @Override
    protected void doDetach() {
        ((Receiver)this.getEndpoint()).detach();
    }

    @Override
    protected Exception getOpenAbortException() {
        org.apache.qpid.proton.amqp.transport.Source s = ((Receiver)this.getEndpoint()).getRemoteSource();
        if (s != null) {
            return super.getOpenAbortException();
        }
        return new InvalidDestinationException("Link creation was refused");
    }

    @Override
    protected void doOpenInspection() {
        try {
            this.getStateInspector().inspectOpenedResource(this.getReceiver());
        }
        catch (Throwable error) {
            this.getStateInspector().markAsInvalid(error.getMessage());
        }
    }

    @Override
    protected void doClosedInspection() {
        try {
            this.getStateInspector().inspectClosedResource(this.getReceiver());
        }
        catch (Throwable error) {
            this.getStateInspector().markAsInvalid(error.getMessage());
        }
    }

    @Override
    protected void doDetachedInspection() {
        try {
            this.getStateInspector().inspectDetachedResource(this.getReceiver());
        }
        catch (Throwable error) {
            this.getStateInspector().markAsInvalid(error.getMessage());
        }
    }

    protected void configureSource(Source source) {
        HashMap<Symbol, Object> filters = new HashMap<Symbol, Object>();
        Symbol[] outcomes = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
        if (this.getSubscriptionName() != null && !this.getSubscriptionName().isEmpty()) {
            source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
            source.setDurable(TerminusDurability.UNSETTLED_STATE);
            source.setDistributionMode(AmqpSupport.COPY);
        } else {
            source.setDurable(TerminusDurability.NONE);
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }
        source.setOutcomes(outcomes);
        Modified modified = new Modified();
        modified.setDeliveryFailed(Boolean.valueOf(true));
        modified.setUndeliverableHere(Boolean.valueOf(false));
        source.setDefaultOutcome((Outcome)modified);
        if (this.isNoLocal()) {
            filters.put(AmqpSupport.NO_LOCAL_NAME, AmqpNoLocalFilter.NO_LOCAL);
        }
        if (this.getSelector() != null && !this.getSelector().trim().equals("")) {
            filters.put(AmqpSupport.JMS_SELECTOR_NAME, new AmqpJmsSelectorFilter(this.getSelector()));
        }
        if (!filters.isEmpty()) {
            source.setFilter(filters);
        }
    }

    @Override
    public void processDeliveryUpdates(AmqpConnection connection, Delivery delivery) throws IOException {
        Delivery incoming = null;
        do {
            if ((incoming = ((Receiver)this.getEndpoint()).current()) != null) {
                if (incoming.isReadable() && !incoming.isPartial()) {
                    logger.trace("{} has incoming Message(s).", (Object)this);
                    try {
                        this.processDelivery(incoming);
                    }
                    catch (Exception e) {
                        throw IOExceptionSupport.create(e);
                    }
                    ((Receiver)this.getEndpoint()).advance();
                    continue;
                }
                logger.trace("{} has a partial incoming Message(s), deferring.", (Object)this);
                incoming = null;
                continue;
            }
            if (((Receiver)this.getEndpoint()).getRemoteCredit() > 0 || this.stopRequest == null) continue;
            this.stopRequest.onSuccess();
            this.stopRequest = null;
        } while (incoming != null);
        super.processDeliveryUpdates(connection, delivery);
    }

    private void processDelivery(Delivery incoming) throws Exception {
        this.doDeliveryInspection(incoming);
        Message message = null;
        try {
            message = this.decodeIncomingMessage(incoming);
        }
        catch (Exception e) {
            logger.warn("Error on transform: {}", (Object)e.getMessage());
            this.deliveryFailed(incoming, true);
            return;
        }
        AmqpMessage amqpMessage = new AmqpMessage(this, message, incoming);
        incoming.setContext((Object)amqpMessage);
        this.prefetch.add(amqpMessage);
        if (this.pullRequest != null) {
            this.pullRequest.onSuccess();
            this.pullRequest = null;
        }
    }

    private void doDeliveryInspection(Delivery delivery) {
        try {
            this.getStateInspector().inspectDelivery(this.getReceiver(), delivery);
        }
        catch (Throwable error) {
            this.getStateInspector().markAsInvalid(error.getMessage());
        }
    }

    @Override
    public void processFlowUpdates(AmqpConnection connection) throws IOException {
        Receiver receiver;
        if ((this.pullRequest != null || this.stopRequest != null) && (receiver = (Receiver)this.getEndpoint()).getRemoteCredit() <= 0 && receiver.getQueued() == 0) {
            if (this.pullRequest != null) {
                this.pullRequest.onSuccess();
                this.pullRequest = null;
            }
            if (this.stopRequest != null) {
                this.stopRequest.onSuccess();
                this.stopRequest = null;
            }
        }
        logger.trace("Consumer {} flow updated, remote credit = {}", (Object)this.getSubscriptionName(), (Object)((Receiver)this.getEndpoint()).getRemoteCredit());
        super.processFlowUpdates(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message decodeIncomingMessage(Delivery incoming) {
        int count;
        byte[] chunk = new byte[2048];
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        while ((count = ((Receiver)this.getEndpoint()).recv(chunk, 0, chunk.length)) > 0) {
            stream.write(chunk, 0, count);
        }
        byte[] messageBytes = stream.toByteArray();
        try {
            Message protonMessage = Message.Factory.create();
            protonMessage.decode(messageBytes, 0, messageBytes.length);
            Message message = protonMessage;
            return message;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void deliveryFailed(Delivery incoming, boolean expandCredit) {
        Modified disposition = new Modified();
        disposition.setUndeliverableHere(Boolean.valueOf(true));
        disposition.setDeliveryFailed(Boolean.valueOf(true));
        incoming.disposition((DeliveryState)disposition);
        incoming.settle();
        if (expandCredit) {
            ((Receiver)this.getEndpoint()).flow(1);
        }
    }

    private void stop(AsyncResult request) {
        Receiver receiver = (Receiver)this.getEndpoint();
        if (receiver.getRemoteCredit() <= 0) {
            if (receiver.getQueued() == 0) {
                request.onSuccess();
            } else {
                this.stopRequest = request;
            }
        } else {
            this.stopRequest = request;
            receiver.drain(0);
            if (this.getDrainTimeout() > 0L) {
                ScheduledFuture<?> future = this.getSession().getScheduler().schedule(() -> {
                    AmqpOperationTimedOutException cause = new AmqpOperationTimedOutException("Remote did not respond to a drain request in time");
                    this.locallyClosed(this.session.getConnection(), (Exception)((Object)cause));
                    this.stopRequest.onFailure((Throwable)((Object)cause));
                    this.session.pumpToProtonTransport(this.stopRequest);
                }, this.getDrainTimeout(), TimeUnit.MILLISECONDS);
                this.stopRequest = new ScheduledRequest(future, this.stopRequest);
            }
        }
    }

    private void stopOnSchedule(long timeout, AsyncResult request) {
        logger.trace("Receiver {} scheduling stop", (Object)this);
        ScheduledFuture<?> future = this.getSession().getScheduler().schedule(() -> {
            if (((Receiver)this.getEndpoint()).getRemoteCredit() != 0) {
                this.stop(request);
                this.session.pumpToProtonTransport(request);
            }
        }, timeout, TimeUnit.MILLISECONDS);
        this.stopRequest = new ScheduledRequest(future, request);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ address = " + this.address + "}";
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Receiver is already closed");
        }
    }

    void preCommit() {
    }

    void preRollback() {
    }

    void postCommit() {
    }

    void postRollback() {
    }

    protected static final class ScheduledRequest
    implements AsyncResult {
        private final ScheduledFuture<?> sheduledTask;
        private final AsyncResult origRequest;

        public ScheduledRequest(ScheduledFuture<?> completionTask, AsyncResult origRequest) {
            this.sheduledTask = completionTask;
            this.origRequest = origRequest;
        }

        @Override
        public void onFailure(Throwable cause) {
            this.sheduledTask.cancel(false);
            this.origRequest.onFailure(cause);
        }

        @Override
        public void onSuccess() {
            boolean cancelled = this.sheduledTask.cancel(false);
            if (cancelled) {
                this.origRequest.onSuccess();
            }
        }

        @Override
        public boolean isComplete() {
            return this.origRequest.isComplete();
        }
    }
}

